/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.ui.StackUtils;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.JavaCompatibility;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import javax.swing.JComponent;
import javax.swing.RepaintManager;

public class HiDPIUtils {
    private static Boolean useTextYCorrection;
    private static final float[] SCALE_FACTORS;
    private static final float[] CORRECTION_SEGOE_UI;
    private static final float[] CORRECTION_TAHOMA;
    private static final float[] CORRECTION_INTER;
    private static final float[] CORRECTION_OPEN_SANS;
    private static Boolean useDebugScaleFactor;

    public static void paintAtScale1x(Graphics2D g15, JComponent c15, Painter painter) {
        HiDPIUtils.paintAtScale1x(g15, 0, 0, c15.getWidth(), c15.getHeight(), painter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintAtScale1x(Graphics2D g15, int x15, int y15, int width, int height, Painter painter) {
        double realScaleY;
        double realScaleX;
        boolean rotated;
        AffineTransform t15 = g15.getTransform();
        double scaleX = t15.getScaleX();
        double scaleY = t15.getScaleY();
        double shearX = t15.getShearX();
        double shearY = t15.getShearY();
        boolean bl4 = rotated = shearX != 0.0 || shearY != 0.0 || scaleX <= 0.0 || scaleY <= 0.0;
        if (rotated) {
            realScaleX = Math.hypot(scaleX, shearX);
            realScaleY = Math.hypot(scaleY, shearY);
        } else {
            realScaleX = Math.abs(scaleX);
            realScaleY = Math.abs(scaleY);
        }
        if (realScaleX == 1.0 && realScaleY == 1.0) {
            painter.paint(g15, x15, y15, width, height, 1.0);
            return;
        }
        double px4 = (double)x15 * scaleX + (double)y15 * shearX + t15.getTranslateX();
        double py4 = (double)y15 * scaleY + (double)x15 * shearY + t15.getTranslateY();
        Rectangle2D.Double scaledRect = HiDPIUtils.scale(realScaleX, realScaleY, px4, py4, width, height);
        try {
            AffineTransform t1x;
            if (rotated) {
                t1x = new AffineTransform(scaleX, shearY, shearX, scaleY, Math.floor(scaledRect.x), Math.floor(scaledRect.y));
                t1x.scale(1.0 / realScaleX, 1.0 / realScaleY);
            } else {
                t1x = new AffineTransform(1.0, 0.0, 0.0, 1.0, Math.floor(scaledRect.x), Math.floor(scaledRect.y));
            }
            g15.setTransform(t1x);
            int swidth = (int)scaledRect.width;
            int sheight = (int)scaledRect.height;
            painter.paint(g15, 0, 0, swidth, sheight, realScaleX);
        }
        finally {
            g15.setTransform(t15);
        }
    }

    private static Rectangle2D.Double scale(double scaleX, double scaleY, double px4, double py4, int width, int height) {
        double newX = HiDPIUtils.normalize(px4);
        double newY = HiDPIUtils.normalize(py4);
        double newWidth = HiDPIUtils.normalize(px4 + (double)width * scaleX) - newX;
        double newHeight = HiDPIUtils.normalize(py4 + (double)height * scaleY) - newY;
        return new Rectangle2D.Double(newX, newY, newWidth, newHeight);
    }

    private static double normalize(double value) {
        return Math.floor(value + 0.25) + 0.25;
    }

    private static boolean useTextYCorrection() {
        if (useTextYCorrection == null) {
            useTextYCorrection = FlatSystemProperties.getBoolean("flatlaf.useTextYCorrection", true);
        }
        return useTextYCorrection;
    }

    public static float computeTextYCorrection(Graphics2D g15) {
        if (!HiDPIUtils.useTextYCorrection() || !SystemInfo.isWindows) {
            return 0.0f;
        }
        if (!SystemInfo.isJava_9_orLater) {
            float scaleFactor = HiDPIUtils.getUserScaleFactor();
            if (scaleFactor > 1.0f) {
                switch (g15.getFont().getFamily()) {
                    case "Segoe UI": 
                    case "Segoe UI Light": 
                    case "Segoe UI Semibold": {
                        return -((scaleFactor == 2.25f || scaleFactor == 4.0f ? 0.875f : 0.625f) * scaleFactor);
                    }
                    case "Noto Sans": 
                    case "Open Sans": {
                        return -(0.3f * scaleFactor);
                    }
                    case "Verdana": {
                        return -((scaleFactor < 2.0f ? 0.4f : 0.3f) * scaleFactor);
                    }
                }
            }
        } else {
            switch (g15.getFont().getFamily()) {
                case "Segoe UI": 
                case "Segoe UI Light": 
                case "Segoe UI Semibold": 
                case "Verdana": 
                case "Dialog": 
                case "SansSerif": {
                    return HiDPIUtils.correctionForScaleY(g15, CORRECTION_SEGOE_UI);
                }
                case "Tahoma": {
                    return HiDPIUtils.correctionForScaleY(g15, CORRECTION_TAHOMA);
                }
                case "Inter": 
                case "Inter Light": 
                case "Inter Semi Bold": 
                case "Inter SemiBold": 
                case "Roboto": 
                case "Roboto Light": 
                case "Roboto Medium": {
                    return HiDPIUtils.correctionForScaleY(g15, CORRECTION_INTER);
                }
                case "Noto Sans": 
                case "Open Sans": {
                    return HiDPIUtils.correctionForScaleY(g15, CORRECTION_OPEN_SANS);
                }
            }
        }
        return 0.0f;
    }

    private static float correctionForScaleY(Graphics2D g15, float[] correction) {
        if (correction.length != 9) {
            throw new IllegalArgumentException();
        }
        double scaleY = g15.getTransform().getScaleY();
        return scaleY < 1.25 ? 0.0f : correction[HiDPIUtils.scaleFactor2index((float)scaleY)];
    }

    private static int scaleFactor2index(float scaleFactor) {
        for (int i15 = 0; i15 < SCALE_FACTORS.length; ++i15) {
            if (!(scaleFactor <= SCALE_FACTORS[i15])) continue;
            return i15;
        }
        return SCALE_FACTORS.length - 1;
    }

    private static boolean useDebugScaleFactor() {
        if (useDebugScaleFactor == null) {
            useDebugScaleFactor = FlatSystemProperties.getBoolean("FlatLaf.debug.HiDPIUtils.useDebugScaleFactor", false);
        }
        return useDebugScaleFactor;
    }

    private static float getUserScaleFactor() {
        return !HiDPIUtils.useDebugScaleFactor() ? UIScale.getUserScaleFactor() : Float.parseFloat(System.getProperty("FlatLaf.debug.HiDPIUtils.debugScaleFactor", "1"));
    }

    public static void drawStringWithYCorrection(JComponent c15, Graphics2D g15, String text, int x15, int y15) {
        HiDPIUtils.drawStringUnderlineCharAtWithYCorrection(c15, g15, text, -1, x15, y15);
    }

    public static void drawStringUnderlineCharAtWithYCorrection(JComponent c15, Graphics2D g15, String text, int underlinedIndex, int x15, int y15) {
        float yCorrection = HiDPIUtils.computeTextYCorrection(g15);
        if (yCorrection != 0.0f) {
            g15.translate(0.0, yCorrection);
            JavaCompatibility.drawStringUnderlineCharAt(c15, g15, text, underlinedIndex, x15, y15);
            g15.translate(0.0, -yCorrection);
        } else {
            JavaCompatibility.drawStringUnderlineCharAt(c15, g15, text, underlinedIndex, x15, y15);
        }
    }

    public static Graphics2D createGraphicsTextYCorrection(Graphics2D g15) {
        final float yCorrection = HiDPIUtils.computeTextYCorrection(g15);
        if (yCorrection == 0.0f) {
            return g15;
        }
        return new Graphics2DProxy(g15){

            @Override
            public void drawString(String str, int x15, int y15) {
                super.drawString(str, (float)x15, (float)y15 + yCorrection);
            }

            @Override
            public void drawString(String str, float x15, float y15) {
                super.drawString(str, x15, y15 + yCorrection);
            }

            @Override
            public void drawString(AttributedCharacterIterator iterator2, int x15, int y15) {
                super.drawString(iterator2, (float)x15, (float)y15 + yCorrection);
            }

            @Override
            public void drawString(AttributedCharacterIterator iterator2, float x15, float y15) {
                super.drawString(iterator2, x15, y15 + yCorrection);
            }

            @Override
            public void drawChars(char[] data, int offset, int length, int x15, int y15) {
                super.drawChars(data, offset, length, x15, Math.round((float)y15 + yCorrection));
            }

            @Override
            public void drawBytes(byte[] data, int offset, int length, int x15, int y15) {
                super.drawBytes(data, offset, length, x15, Math.round((float)y15 + yCorrection));
            }

            @Override
            public void drawGlyphVector(GlyphVector g15, float x15, float y15) {
                super.drawGlyphVector(g15, x15, y15 + yCorrection);
            }

            @Override
            public void fillRect(int x15, int y15, int width, int height) {
                if (super.getColor() == Color.black && StackUtils.wasInvokedFrom("javax.swing.text.html.HRuleView", "paint", 4)) {
                    super.setColor(FlatLaf.isLafDark() ? Color.lightGray : Color.darkGray);
                    super.fillRect(x15, y15, width, height);
                    super.setColor(Color.black);
                } else {
                    super.fillRect(x15, y15, width, height);
                }
            }
        };
    }

    public static void repaint(Component c15) {
        HiDPIUtils.repaint(c15, 0, 0, c15.getWidth(), c15.getHeight());
    }

    public static void repaint(Component c15, Rectangle r15) {
        HiDPIUtils.repaint(c15, r15.x, r15.y, r15.width, r15.height);
    }

    public static void repaint(Component c15, int x15, int y15, int width, int height) {
        c15.repaint(x15, y15, width, height);
        if (RepaintManager.currentManager(c15) instanceof HiDPIRepaintManager) {
            return;
        }
        if (HiDPIUtils.needsSpecialRepaint(c15, x15, y15, width, height)) {
            int x25 = x15 + c15.getX();
            int y25 = y15 + c15.getY();
            for (Container p15 = c15.getParent(); p15 != null; p15 = p15.getParent()) {
                if ((x25 += p15.getX()) + width >= p15.getWidth() || (y25 += p15.getY()) + height >= p15.getHeight()) continue;
                p15.repaint(x25, y25, width, height);
                break;
            }
        }
    }

    private static boolean needsSpecialRepaint(Component c15, int x15, int y15, int width, int height) {
        double scaleFactor;
        double fraction;
        if (!SystemInfo.isJava_9_orLater || !SystemInfo.isWindows) {
            return false;
        }
        if (width <= 0 || height <= 0 || c15 == null) {
            return false;
        }
        int compWidth = c15.getWidth();
        int compHeight = c15.getHeight();
        if (compWidth <= 0 || compHeight <= 0) {
            return false;
        }
        if (x15 + width < compWidth && y15 + height < compHeight) {
            return false;
        }
        if (!c15.isOpaque()) {
            int x25 = x15;
            int y25 = y15;
            for (Container p15 = c15.getParent(); p15 != null; p15 = p15.getParent()) {
                x25 += p15.getX();
                y25 += p15.getY();
                if (!p15.isOpaque()) continue;
                if (x25 + width >= p15.getWidth() || y25 + height >= p15.getHeight()) break;
                return false;
            }
        }
        return (fraction = (scaleFactor = UIScale.getSystemScaleFactor(c15.getGraphicsConfiguration())) - (double)((int)scaleFactor)) != 0.0 && fraction != 0.5;
    }

    public static void installHiDPIRepaintManager() {
        if (!SystemInfo.isJava_9_orLater || !SystemInfo.isWindows) {
            return;
        }
        RepaintManager manager = RepaintManager.currentManager((Component)null);
        if (manager.getClass() == RepaintManager.class) {
            RepaintManager.setCurrentManager(new HiDPIRepaintManager());
        }
    }

    public static void addDirtyRegion(JComponent c15, int x15, int y15, int width, int height, DirtyRegionCallback callback) {
        if (HiDPIUtils.needsSpecialRepaint(c15, x15, y15, width, height)) {
            int x25 = x15 + c15.getX();
            int y25 = y15 + c15.getY();
            for (Container p15 = c15.getParent(); p15 != null; p15 = p15.getParent()) {
                if (x25 + width < p15.getWidth() && y25 + height < p15.getHeight() && p15 instanceof JComponent) {
                    callback.addDirtyRegion((JComponent)p15, x25, y25, width, height);
                    return;
                }
                x25 += p15.getX();
                y25 += p15.getY();
            }
        }
        callback.addDirtyRegion(c15, x15, y15, width, height);
    }

    static {
        SCALE_FACTORS = new float[]{1.25f, 1.5f, 1.75f, 2.0f, 2.25f, 2.5f, 3.0f, 3.5f, 4.0f};
        CORRECTION_SEGOE_UI = new float[]{-0.5f, -0.5f, -0.625f, -0.75f, -0.75f, -0.75f, -0.75f, -0.75f, -0.875f};
        CORRECTION_TAHOMA = new float[]{-0.25f, -0.25f, -0.25f, -0.0f, -0.125f, -0.125f, -0.125f, -0.125f, -0.0f};
        CORRECTION_INTER = new float[]{-0.25f, -0.25f, -0.25f, -0.0f, -0.125f, -0.125f, -0.0f, -0.25f, -0.0f};
        CORRECTION_OPEN_SANS = new float[]{-0.5f, -0.25f, -0.25f, -0.0f, -0.25f, -0.25f, -0.0f, -0.25f, -0.25f};
    }

    public static class HiDPIRepaintManager
    extends RepaintManager {
        @Override
        public void addDirtyRegion(JComponent c15, int x15, int y15, int w15, int h15) {
            HiDPIUtils.addDirtyRegion(c15, x15, y15, w15, h15, (x$0, x$1, x$2, x$3, x$4) -> super.addDirtyRegion(x$0, x$1, x$2, x$3, x$4));
        }
    }

    public static interface DirtyRegionCallback {
        public void addDirtyRegion(JComponent var1, int var2, int var3, int var4, int var5);
    }

    public static interface Painter {
        public void paint(Graphics2D var1, int var2, int var3, int var4, int var5, double var6);
    }
}

