/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatMarginBorder;
import com.formdev.flatlaf.ui.FlatToolBarUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.function.Function;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ToolBarUI;

public class FlatToolBarBorder
extends FlatMarginBorder {
    private static final int DOT_COUNT = 4;
    private static final int DOT_SIZE = 2;
    private static final int GRIP_SIZE = 6;
    protected Color gripColor = UIManager.getColor("ToolBar.gripColor");

    public FlatToolBarBorder() {
        super(UIManager.getInsets("ToolBar.borderMargins"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c15, Graphics g15, int x15, int y15, int width, int height) {
        if (c15 instanceof JToolBar && ((JToolBar)c15).isFloatable()) {
            Graphics2D g25 = (Graphics2D)g15.create();
            try {
                FlatUIUtils.setRenderingHints(g25);
                Color color = FlatToolBarBorder.getStyleFromToolBarUI(c15, ui4 -> ui4.gripColor);
                g25.setColor(color != null ? color : this.gripColor);
                this.paintGrip(c15, g25, x15, y15, width, height);
            }
            finally {
                g25.dispose();
            }
        }
    }

    protected void paintGrip(Component c15, Graphics g15, int x15, int y15, int width, int height) {
        Rectangle r15 = this.calculateGripBounds(c15, x15, y15, width, height);
        FlatUIUtils.paintGrip(g15, r15.x, r15.y, r15.width, r15.height, ((JToolBar)c15).getOrientation() == 1, 4, 2, 2, false);
    }

    protected Rectangle calculateGripBounds(Component c15, int x15, int y15, int width, int height) {
        Insets insets = super.getBorderInsets(c15, new Insets(0, 0, 0, 0));
        Rectangle r15 = FlatUIUtils.subtractInsets(new Rectangle(x15, y15, width, height), insets);
        int gripSize = UIScale.scale(6);
        if (((JToolBar)c15).getOrientation() == 0) {
            if (!c15.getComponentOrientation().isLeftToRight()) {
                r15.x = r15.x + r15.width - gripSize;
            }
            r15.width = gripSize;
        } else {
            r15.height = gripSize;
        }
        return r15;
    }

    @Override
    public Insets getBorderInsets(Component c15, Insets insets) {
        Insets m15 = FlatToolBarBorder.getStyleFromToolBarUI(c15, ui4 -> ui4.borderMargins);
        if (m15 != null) {
            int t15 = this.top;
            int l15 = this.left;
            int b15 = this.bottom;
            int r15 = this.right;
            this.top = m15.top;
            this.left = m15.left;
            this.bottom = m15.bottom;
            this.right = m15.right;
            insets = super.getBorderInsets(c15, insets);
            this.top = t15;
            this.left = l15;
            this.bottom = b15;
            this.right = r15;
        } else {
            insets = super.getBorderInsets(c15, insets);
        }
        if (c15 instanceof JToolBar && ((JToolBar)c15).isFloatable()) {
            int gripInset = UIScale.scale(6);
            if (((JToolBar)c15).getOrientation() == 0) {
                if (c15.getComponentOrientation().isLeftToRight()) {
                    insets.left += gripInset;
                } else {
                    insets.right += gripInset;
                }
            } else {
                insets.top += gripInset;
            }
        }
        return insets;
    }

    static <T> T getStyleFromToolBarUI(Component c15, Function<FlatToolBarUI, T> f15) {
        ToolBarUI ui4;
        if (c15 instanceof JToolBar && (ui4 = ((JToolBar)c15).getUI()) instanceof FlatToolBarUI) {
            return f15.apply((FlatToolBarUI)ui4);
        }
        return null;
    }
}

