/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class FlatToggleButtonUI
extends FlatButtonUI {
    @FlatStylingSupport.Styleable(dot=true)
    protected int tabUnderlineHeight;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color tabUnderlineColor;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color tabDisabledUnderlineColor;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color tabSelectedBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color tabSelectedForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color tabHoverBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color tabHoverForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color tabFocusBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color tabFocusForeground;
    private boolean defaults_initialized = false;

    public static ComponentUI createUI(JComponent c15) {
        return FlatUIUtils.canUseSharedUI(c15) ? FlatUIUtils.createSharedUI(FlatToggleButtonUI.class, () -> new FlatToggleButtonUI(true)) : new FlatToggleButtonUI(false);
    }

    protected FlatToggleButtonUI(boolean shared) {
        super(shared);
    }

    @Override
    String getStyleType() {
        return "ToggleButton";
    }

    @Override
    protected String getPropertyPrefix() {
        return "ToggleButton.";
    }

    @Override
    protected void installDefaults(AbstractButton b15) {
        super.installDefaults(b15);
        if (!this.defaults_initialized) {
            this.tabUnderlineHeight = UIManager.getInt("ToggleButton.tab.underlineHeight");
            this.tabUnderlineColor = UIManager.getColor("ToggleButton.tab.underlineColor");
            this.tabDisabledUnderlineColor = UIManager.getColor("ToggleButton.tab.disabledUnderlineColor");
            this.tabSelectedBackground = UIManager.getColor("ToggleButton.tab.selectedBackground");
            this.tabSelectedForeground = UIManager.getColor("ToggleButton.tab.selectedForeground");
            this.tabHoverBackground = UIManager.getColor("ToggleButton.tab.hoverBackground");
            this.tabHoverForeground = UIManager.getColor("ToggleButton.tab.hoverForeground");
            this.tabFocusBackground = UIManager.getColor("ToggleButton.tab.focusBackground");
            this.tabFocusForeground = UIManager.getColor("ToggleButton.tab.focusForeground");
            this.defaults_initialized = true;
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton b15) {
        super.uninstallDefaults(b15);
        this.defaults_initialized = false;
    }

    @Override
    protected void propertyChange(AbstractButton b15, PropertyChangeEvent e15) {
        super.propertyChange(b15, e15);
        switch (e15.getPropertyName()) {
            case "JButton.buttonType": {
                if ("tab".equals(e15.getOldValue()) || "tab".equals(e15.getNewValue())) {
                    MigLayoutVisualPadding.uninstall(b15);
                    MigLayoutVisualPadding.install(b15);
                    b15.revalidate();
                }
                HiDPIUtils.repaint(b15);
                break;
            }
            case "JToggleButton.tab.underlinePlacement": 
            case "JToggleButton.tab.underlineHeight": 
            case "JToggleButton.tab.underlineColor": 
            case "JToggleButton.tab.selectedBackground": {
                HiDPIUtils.repaint(b15);
            }
        }
    }

    @Override
    protected Object applyStyleProperty(AbstractButton b15, String key, Object value) {
        if (key.startsWith("help.")) {
            throw new FlatStylingSupport.UnknownStyleException(key);
        }
        return super.applyStyleProperty(b15, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c15) {
        Map<String, Class<?>> infos = super.getStyleableInfos(c15);
        infos.keySet().removeIf(s15 -> s15.startsWith("help."));
        return infos;
    }

    static boolean isTabButton(Component c15) {
        return c15 instanceof JToggleButton && "tab".equals(FlatToggleButtonUI.getButtonTypeStr((JToggleButton)c15));
    }

    @Override
    protected void paintBackground(Graphics g15, JComponent c15) {
        if (FlatToggleButtonUI.isTabButton(c15)) {
            Color background;
            Color bg5;
            Color enabledColor;
            int height = c15.getHeight();
            int width = c15.getWidth();
            boolean selected = ((AbstractButton)c15).isSelected();
            Color color = enabledColor = selected ? FlatClientProperties.clientPropertyColor(c15, "JToggleButton.tab.selectedBackground", this.tabSelectedBackground) : null;
            if (enabledColor == null && this.isCustomBackground(bg5 = c15.getBackground())) {
                enabledColor = bg5;
            }
            if ((background = FlatToggleButtonUI.buttonStateColor(c15, enabledColor, null, this.tabFocusBackground, this.tabHoverBackground, null)) != null) {
                g15.setColor(background);
                g15.fillRect(0, 0, width, height);
            }
            if (selected) {
                int underlineThickness = UIScale.scale(FlatClientProperties.clientPropertyInt(c15, "JToggleButton.tab.underlineHeight", this.tabUnderlineHeight));
                g15.setColor(c15.isEnabled() ? FlatClientProperties.clientPropertyColor(c15, "JToggleButton.tab.underlineColor", this.tabUnderlineColor) : this.tabDisabledUnderlineColor);
                int placement = FlatClientProperties.clientPropertyInt(c15, "JToggleButton.tab.underlinePlacement", 3);
                switch (placement) {
                    case 1: {
                        g15.fillRect(0, 0, width, underlineThickness);
                        break;
                    }
                    case 2: {
                        g15.fillRect(0, 0, underlineThickness, height);
                        break;
                    }
                    case 4: {
                        g15.fillRect(width - underlineThickness, 0, underlineThickness, height);
                        break;
                    }
                    default: {
                        g15.fillRect(0, height - underlineThickness, width, underlineThickness);
                    }
                }
            }
        } else {
            super.paintBackground(g15, c15);
        }
    }

    @Override
    protected Color getForeground(JComponent c15) {
        if (FlatToggleButtonUI.isTabButton(c15)) {
            if (!c15.isEnabled()) {
                return this.disabledText;
            }
            if (this.tabSelectedForeground != null && ((AbstractButton)c15).isSelected()) {
                return this.tabSelectedForeground;
            }
            return FlatToggleButtonUI.buttonStateColor(c15, c15.getForeground(), this.disabledText, this.tabFocusForeground, this.tabHoverForeground, null);
        }
        return super.getForeground(c15);
    }
}

