/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatScrollPaneUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class FlatScrollPaneBorder
extends FlatBorder {
    @FlatStylingSupport.Styleable
    protected int arc = UIManager.getInt("ScrollPane.arc");
    private boolean isArcStyled;
    private final int listArc = FlatUIUtils.getUIInt("ScrollPane.List.arc", -1);
    private final int tableArc = FlatUIUtils.getUIInt("ScrollPane.Table.arc", -1);
    private final int textComponentArc = FlatUIUtils.getUIInt("ScrollPane.TextComponent.arc", -1);
    private final int treeArc = FlatUIUtils.getUIInt("ScrollPane.Tree.arc", -1);

    @Override
    public Object applyStyleProperty(String key, Object value) {
        Object oldValue = super.applyStyleProperty(key, value);
        if ("arc".equals(key)) {
            this.isArcStyled = true;
        }
        return oldValue;
    }

    @Override
    public Insets getBorderInsets(Component c15, Insets insets) {
        insets = super.getBorderInsets(c15, insets);
        int padding = this.getLeftRightPadding(c15);
        if (padding > 0) {
            insets.left += padding;
            insets.right += padding;
        }
        return insets;
    }

    @Override
    protected int getArc(Component c15) {
        if (this.isCellEditor(c15)) {
            return 0;
        }
        if (this.isArcStyled) {
            return this.arc;
        }
        if (c15 instanceof JScrollPane) {
            Component view = FlatScrollPaneUI.getView((JScrollPane)c15);
            if (this.listArc >= 0 && view instanceof JList) {
                return this.listArc;
            }
            if (this.tableArc >= 0 && view instanceof JTable) {
                return this.tableArc;
            }
            if (this.textComponentArc >= 0 && view instanceof JTextComponent) {
                return this.textComponentArc;
            }
            if (this.treeArc >= 0 && view instanceof JTree) {
                return this.treeArc;
            }
        }
        return this.arc;
    }

    public int getLeftRightPadding(Component c15) {
        int arc = this.getArc(c15);
        return arc > 0 ? Math.max(Math.round(UIScale.scale(((float)arc / 2.0f - (float)this.getLineWidth(c15)) * 0.9f)), 0) : 0;
    }
}

