/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatHTML;
import com.formdev.flatlaf.ui.FlatPanelUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;

public class FlatLabelUI
extends BasicLabelUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Color disabledForeground;
    @FlatStylingSupport.Styleable
    protected int arc = -1;
    private final boolean shared;
    private boolean defaults_initialized = false;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c15) {
        return FlatUIUtils.canUseSharedUI(c15) ? FlatUIUtils.createSharedUI(FlatLabelUI.class, () -> new FlatLabelUI(true)) : new FlatLabelUI(false);
    }

    protected FlatLabelUI(boolean shared) {
        this.shared = shared;
    }

    @Override
    public void installUI(JComponent c15) {
        super.installUI(c15);
        this.installStyle((JLabel)c15);
    }

    @Override
    protected void installDefaults(JLabel c15) {
        super.installDefaults(c15);
        if (!this.defaults_initialized) {
            this.disabledForeground = UIManager.getColor("Label.disabledForeground");
            this.defaults_initialized = true;
        }
    }

    @Override
    protected void uninstallDefaults(JLabel c15) {
        super.uninstallDefaults(c15);
        this.defaults_initialized = false;
        this.oldStyleValues = null;
    }

    @Override
    protected void installComponents(JLabel c15) {
        super.installComponents(c15);
        FlatHTML.updateRendererCSSFontBaseSize(c15);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e15) {
        String name = e15.getPropertyName();
        if (name.equals("FlatLaf.style") || name.equals("FlatLaf.styleClass")) {
            JLabel label = (JLabel)e15.getSource();
            if (this.shared && FlatStylingSupport.hasStyleProperty(label)) {
                label.updateUI();
            } else {
                this.installStyle(label);
            }
            label.revalidate();
            HiDPIUtils.repaint(label);
        }
        super.propertyChange(e15);
        FlatHTML.propertyChange(e15);
    }

    protected void installStyle(JLabel c15) {
        try {
            this.applyStyle(c15, FlatStylingSupport.getResolvedStyle(c15, "Label"));
        }
        catch (RuntimeException ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
    }

    protected void applyStyle(JLabel c15, Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, (key, value) -> this.applyStyleProperty(c15, (String)key, value));
    }

    protected Object applyStyleProperty(JLabel c15, String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, c15, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c15) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent c15, String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    @Override
    public void update(Graphics g15, JComponent c15) {
        FlatPanelUI.fillRoundedBackground(g15, c15, this.arc);
        this.paint(g15, c15);
    }

    static Graphics createGraphicsHTMLTextYCorrection(Graphics g15, JComponent c15) {
        return c15.getClientProperty("html") != null ? HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)g15) : g15;
    }

    @Override
    public void paint(Graphics g15, JComponent c15) {
        super.paint(FlatLabelUI.createGraphicsHTMLTextYCorrection(g15, c15), c15);
    }

    @Override
    protected void paintEnabledText(JLabel l15, Graphics g15, String s15, int textX, int textY) {
        int mnemIndex = FlatLaf.isShowMnemonics() ? l15.getDisplayedMnemonicIndex() : -1;
        g15.setColor(l15.getForeground());
        FlatUIUtils.drawStringUnderlineCharAt(l15, g15, s15, mnemIndex, textX, textY);
    }

    @Override
    protected void paintDisabledText(JLabel l15, Graphics g15, String s15, int textX, int textY) {
        int mnemIndex = FlatLaf.isShowMnemonics() ? l15.getDisplayedMnemonicIndex() : -1;
        g15.setColor(this.disabledForeground);
        FlatUIUtils.drawStringUnderlineCharAt(l15, g15, s15, mnemIndex, textX, textY);
    }

    @Override
    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        return SwingUtilities.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, UIScale.scale(label.getIconTextGap()));
    }
}

