/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatDropShadowBorder;
import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatInternalFrameTitlePane;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.FlatWindowResizer;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public class FlatInternalFrameUI
extends BasicInternalFrameUI
implements FlatStylingSupport.StyleableUI {
    protected FlatWindowResizer windowResizer;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;

    public static ComponentUI createUI(JComponent c15) {
        return new FlatInternalFrameUI((JInternalFrame)c15);
    }

    public FlatInternalFrameUI(JInternalFrame b15) {
        super(b15);
    }

    @Override
    public void installUI(JComponent c15) {
        super.installUI(c15);
        LookAndFeel.installProperty(this.frame, "opaque", false);
        this.windowResizer = this.createWindowResizer();
        this.installStyle();
    }

    @Override
    public void uninstallUI(JComponent c15) {
        super.uninstallUI(c15);
        if (this.windowResizer != null) {
            this.windowResizer.uninstall();
            this.windowResizer = null;
        }
        this.oldStyleValues = null;
        this.borderShared = null;
    }

    @Override
    protected JComponent createNorthPane(JInternalFrame w15) {
        return new FlatInternalFrameTitlePane(w15);
    }

    protected FlatWindowResizer createWindowResizer() {
        return new FlatWindowResizer.InternalFrameResizer(this.frame, this::getDesktopManager);
    }

    @Override
    protected MouseInputAdapter createBorderListener(JInternalFrame w15) {
        return new FlatBorderListener();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return FlatStylingSupport.createPropertyChangeListener(this.frame, this::installStyle, super.createPropertyChangeListener());
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.frame, "InternalFrame"));
        }
        catch (RuntimeException ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
    }

    protected void applyStyle(Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String key, Object value) {
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, key, value, this.frame, this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c15) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this, this.frame.getBorder());
    }

    @Override
    public Object getStyleableValue(JComponent c15, String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, this.frame.getBorder(), key);
    }

    @Override
    public void update(Graphics g15, JComponent c15) {
        if (!c15.isOpaque() && !FlatUIUtils.hasOpaqueBeenExplicitlySet(c15)) {
            Insets insets = c15.getInsets();
            g15.setColor(c15.getBackground());
            g15.fillRect(insets.left, insets.top, c15.getWidth() - insets.left - insets.right, c15.getHeight() - insets.top - insets.bottom);
        }
        super.update(g15, c15);
    }

    protected class FlatBorderListener
    extends BasicInternalFrameUI.BorderListener {
        protected FlatBorderListener() {
            super(FlatInternalFrameUI.this);
        }

        @Override
        public void mouseClicked(MouseEvent e15) {
            Rectangle iconBounds;
            if (e15.getClickCount() == 2 && !FlatInternalFrameUI.this.frame.isIcon() && e15.getSource() instanceof FlatInternalFrameTitlePane && (iconBounds = ((FlatInternalFrameTitlePane)e15.getSource()).getFrameIconBounds()) != null && iconBounds.contains(e15.getX(), e15.getY())) {
                if (FlatInternalFrameUI.this.frame.isClosable()) {
                    FlatInternalFrameUI.this.frame.doDefaultCloseAction();
                }
                return;
            }
            super.mouseClicked(e15);
        }
    }

    public static class FlatInternalFrameBorder
    extends FlatEmptyBorder
    implements FlatStylingSupport.StyleableObject {
        @FlatStylingSupport.Styleable
        protected Color activeBorderColor = UIManager.getColor("InternalFrame.activeBorderColor");
        @FlatStylingSupport.Styleable
        protected Color inactiveBorderColor = UIManager.getColor("InternalFrame.inactiveBorderColor");
        @FlatStylingSupport.Styleable
        protected int borderLineWidth = FlatUIUtils.getUIInt("InternalFrame.borderLineWidth", 1);
        @FlatStylingSupport.Styleable
        protected boolean dropShadowPainted = UIManager.getBoolean("InternalFrame.dropShadowPainted");
        private final FlatDropShadowBorder activeDropShadowBorder = new FlatDropShadowBorder(UIManager.getColor("InternalFrame.activeDropShadowColor"), UIManager.getInsets("InternalFrame.activeDropShadowInsets"), FlatUIUtils.getUIFloat("InternalFrame.activeDropShadowOpacity", 0.5f));
        private final FlatDropShadowBorder inactiveDropShadowBorder = new FlatDropShadowBorder(UIManager.getColor("InternalFrame.inactiveDropShadowColor"), UIManager.getInsets("InternalFrame.inactiveDropShadowInsets"), FlatUIUtils.getUIFloat("InternalFrame.inactiveDropShadowOpacity", 0.5f));

        public FlatInternalFrameBorder() {
            super(UIManager.getInsets("InternalFrame.borderMargins"));
        }

        @Override
        public Object applyStyleProperty(String key, Object value) {
            switch (key) {
                case "borderMargins": {
                    return this.applyStyleProperty((Insets)value);
                }
                case "activeDropShadowColor": {
                    return this.activeDropShadowBorder.applyStyleProperty("shadowColor", value);
                }
                case "activeDropShadowInsets": {
                    return this.activeDropShadowBorder.applyStyleProperty("shadowInsets", value);
                }
                case "activeDropShadowOpacity": {
                    return this.activeDropShadowBorder.applyStyleProperty("shadowOpacity", value);
                }
                case "inactiveDropShadowColor": {
                    return this.inactiveDropShadowBorder.applyStyleProperty("shadowColor", value);
                }
                case "inactiveDropShadowInsets": {
                    return this.inactiveDropShadowBorder.applyStyleProperty("shadowInsets", value);
                }
                case "inactiveDropShadowOpacity": {
                    return this.inactiveDropShadowBorder.applyStyleProperty("shadowOpacity", value);
                }
            }
            return FlatStylingSupport.applyToAnnotatedObject(this, key, value);
        }

        @Override
        public Map<String, Class<?>> getStyleableInfos() {
            FlatStylingSupport.StyleableInfosMap infos = new FlatStylingSupport.StyleableInfosMap();
            FlatStylingSupport.collectAnnotatedStyleableInfos(this, infos);
            infos.put("borderMargins", Insets.class);
            infos.put("activeDropShadowColor", Color.class);
            infos.put("activeDropShadowInsets", Insets.class);
            infos.put("activeDropShadowOpacity", Float.TYPE);
            infos.put("inactiveDropShadowColor", Color.class);
            infos.put("inactiveDropShadowInsets", Insets.class);
            infos.put("inactiveDropShadowOpacity", Float.TYPE);
            return infos;
        }

        @Override
        public Object getStyleableValue(String key) {
            switch (key) {
                case "borderMargins": {
                    return this.getStyleableValue();
                }
                case "activeDropShadowColor": {
                    return this.activeDropShadowBorder.getStyleableValue("shadowColor");
                }
                case "activeDropShadowInsets": {
                    return this.activeDropShadowBorder.getStyleableValue("shadowInsets");
                }
                case "activeDropShadowOpacity": {
                    return this.activeDropShadowBorder.getStyleableValue("shadowOpacity");
                }
                case "inactiveDropShadowColor": {
                    return this.inactiveDropShadowBorder.getStyleableValue("shadowColor");
                }
                case "inactiveDropShadowInsets": {
                    return this.inactiveDropShadowBorder.getStyleableValue("shadowInsets");
                }
                case "inactiveDropShadowOpacity": {
                    return this.inactiveDropShadowBorder.getStyleableValue("shadowOpacity");
                }
            }
            return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
        }

        @Override
        public Insets getBorderInsets(Component c15, Insets insets) {
            if (c15 instanceof JInternalFrame && ((JInternalFrame)c15).isMaximum()) {
                insets.left = UIScale.scale(Math.min(this.borderLineWidth, this.left));
                insets.top = UIScale.scale(Math.min(this.borderLineWidth, this.top));
                insets.right = UIScale.scale(Math.min(this.borderLineWidth, this.right));
                insets.bottom = UIScale.scale(Math.min(this.borderLineWidth, this.bottom));
                return insets;
            }
            return super.getBorderInsets(c15, insets);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintBorder(Component c15, Graphics g15, int x15, int y15, int width, int height) {
            JInternalFrame f15 = (JInternalFrame)c15;
            Insets insets = this.getBorderInsets(c15);
            float lineWidth = UIScale.scale((float)this.borderLineWidth);
            float rx4 = (float)(x15 + insets.left) - lineWidth;
            float ry4 = (float)(y15 + insets.top) - lineWidth;
            float rwidth = (float)(width - insets.left - insets.right) + lineWidth * 2.0f;
            float rheight = (float)(height - insets.top - insets.bottom) + lineWidth * 2.0f;
            Graphics2D g25 = (Graphics2D)g15.create();
            try {
                FlatUIUtils.setRenderingHints(g25);
                g25.setColor(f15.isSelected() ? this.activeBorderColor : this.inactiveBorderColor);
                if (this.dropShadowPainted) {
                    FlatDropShadowBorder dropShadowBorder = f15.isSelected() ? this.activeDropShadowBorder : this.inactiveDropShadowBorder;
                    Insets dropShadowInsets = dropShadowBorder.getBorderInsets();
                    dropShadowBorder.paintBorder(c15, g25, (int)rx4 - dropShadowInsets.left, (int)ry4 - dropShadowInsets.top, (int)rwidth + dropShadowInsets.left + dropShadowInsets.right, (int)rheight + dropShadowInsets.top + dropShadowInsets.bottom);
                }
                g25.fill(FlatUIUtils.createRectangle(rx4, ry4, rwidth, rheight, lineWidth));
            }
            finally {
                g25.dispose();
            }
        }
    }
}

