/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.LabelView;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class FlatHTML {
    static BiConsumer<JComponent, String> testUpdateRenderer;
    private static final Set<String> absoluteSizeKeywordsSet;

    private FlatHTML() {
    }

    public static void updateRendererCSSFontBaseSize(JComponent c15) {
        int insertIndex;
        String text;
        View view = (View)c15.getClientProperty("html");
        if (view == null) {
            return;
        }
        Document doc = view.getDocument();
        if (!(doc instanceof HTMLDocument)) {
            return;
        }
        StyleSheet styleSheet = ((HTMLDocument)doc).getStyleSheet();
        Font font = c15.getFont();
        if (styleSheet.getPointSize(7) != 36.0f || font == null || styleSheet.getPointSize(4) == (float)font.getSize()) {
            return;
        }
        if (!FlatHTML.usesAbsoluteSizeKeywordForFontSize(view)) {
            return;
        }
        if (c15 instanceof JLabel) {
            text = ((JLabel)c15).getText();
        } else if (c15 instanceof AbstractButton) {
            text = ((AbstractButton)c15).getText();
        } else if (c15 instanceof JToolTip) {
            text = ((JToolTip)c15).getTipText();
        } else {
            return;
        }
        if (text == null || !BasicHTML.isHTMLString(text)) {
            return;
        }
        String style = "<style>BASE_SIZE " + font.getSize() + "</style>";
        String openTag = "";
        String closeTag = "";
        int headIndex = FlatHTML.indexOfTag(text, "head", true);
        if (headIndex >= 0) {
            insertIndex = headIndex;
        } else {
            int styleIndex = FlatHTML.indexOfTag(text, "style", false);
            if (styleIndex >= 0) {
                insertIndex = styleIndex;
            } else {
                insertIndex = "<html>".length();
                openTag = "<head>";
                closeTag = "</head>";
            }
        }
        String newText = text.substring(0, insertIndex) + openTag + style + closeTag + text.substring(insertIndex);
        BasicHTML.updateRenderer(c15, newText);
        if (testUpdateRenderer != null) {
            testUpdateRenderer.accept(c15, newText);
        }
    }

    private static int indexOfTag(String html, String tag, boolean endIndex) {
        int tagLength = tag.length();
        int maxLength = html.length() - tagLength - 2;
        char lastTagChar = tag.charAt(tagLength - 1);
        for (int i15 = "<html>".length(); i15 < maxLength; ++i15) {
            if (html.charAt(i15) != '<' || Character.toLowerCase(html.charAt(i15 + tagLength)) != lastTagChar) continue;
            for (int j15 = tagLength - 2; j15 >= 0 && Character.toLowerCase(html.charAt(i15 + 1 + j15)) == tag.charAt(j15); --j15) {
                if (j15 != 0) continue;
                return endIndex ? html.indexOf(62, i15 + tagLength) + 1 : i15;
            }
        }
        return -1;
    }

    private static boolean usesAbsoluteSizeKeywordForFontSize(View view) {
        Object fontSize;
        AttributeSet attributes = view.getAttributes();
        if (attributes != null && (fontSize = attributes.getAttribute(CSS.Attribute.FONT_SIZE)) != null && absoluteSizeKeywordsSet.contains(fontSize.toString())) {
            return true;
        }
        int viewCount = view.getViewCount();
        for (int i15 = 0; i15 < viewCount; ++i15) {
            if (!FlatHTML.usesAbsoluteSizeKeywordForFontSize(view.getView(i15))) continue;
            return true;
        }
        return false;
    }

    public static void updateRendererCSSForeground(View view, Color foreground) {
        Document doc = view.getDocument();
        if (!(doc instanceof HTMLDocument) || foreground == null) {
            return;
        }
        Style bodyStyle = ((HTMLDocument)doc).getStyle("body");
        if (bodyStyle == null) {
            StyleSheet styleSheet = ((HTMLDocument)doc).getStyleSheet();
            styleSheet.addRule(String.format("body { color: #%06x; }", foreground.getRGB() & 0xFFFFFF));
            FlatHTML.clearViewCaches(view);
        } else if (!foreground.equals(bodyStyle.getAttribute(StyleConstants.Foreground))) {
            bodyStyle.addAttribute(StyleConstants.Foreground, foreground);
            FlatHTML.clearViewCaches(view);
        }
    }

    private static void clearViewCaches(View view) {
        if (view instanceof LabelView) {
            ((LabelView)view).changedUpdate(null, null, null);
        }
        int viewCount = view.getViewCount();
        for (int i15 = 0; i15 < viewCount; ++i15) {
            FlatHTML.clearViewCaches(view.getView(i15));
        }
    }

    public static PropertyChangeListener createPropertyChangeListener(PropertyChangeListener superListener) {
        return e15 -> {
            if (superListener != null) {
                superListener.propertyChange(e15);
            }
            FlatHTML.propertyChange(e15);
        };
    }

    public static void propertyChange(PropertyChangeEvent e15) {
        if ("html".equals(e15.getPropertyName()) && e15.getNewValue() instanceof View) {
            FlatHTML.updateRendererCSSFontBaseSize((JComponent)e15.getSource());
        }
    }

    static {
        absoluteSizeKeywordsSet = new HashSet<String>(Arrays.asList("xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large"));
    }
}

