/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.icons;

import com.formdev.flatlaf.icons.FlatAbstractIcon;
import com.formdev.flatlaf.ui.FlatTreeUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Path2D;
import java.util.function.Function;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TreeUI;

public class FlatTreeCollapsedIcon
extends FlatAbstractIcon {
    private final boolean chevron = FlatUIUtils.isChevron(UIManager.getString("Component.arrowType"));
    private Path2D path;

    public FlatTreeCollapsedIcon() {
        this(UIManager.getColor("Tree.icon.collapsedColor"));
    }

    FlatTreeCollapsedIcon(Color color) {
        super(11, 11, color);
    }

    @Override
    protected void paintIcon(Component c15, Graphics2D g15) {
        boolean chevron;
        this.setStyleColorFromTreeUI(c15, g15);
        this.rotate(c15, g15);
        String arrowType = FlatTreeCollapsedIcon.getStyleFromTreeUI(c15, ui4 -> ui4.iconArrowType);
        boolean bl4 = chevron = arrowType != null ? FlatUIUtils.isChevron(arrowType) : this.chevron;
        if (chevron) {
            g15.setStroke(new BasicStroke(1.0f, 1, 0));
            if (this.path == null) {
                this.path = FlatUIUtils.createPath(false, 3.5, 1.5, 7.5, 5.5, 3.5, 9.5);
            }
            g15.draw(this.path);
        } else {
            if (this.path == null) {
                this.path = FlatUIUtils.createPath(2.0, 1.0, 2.0, 10.0, 10.0, 5.5);
            }
            g15.fill(this.path);
        }
    }

    void setStyleColorFromTreeUI(Component c15, Graphics2D g15) {
        FlatTreeCollapsedIcon.setStyleColorFromTreeUI(c15, g15, ui4 -> ui4.iconCollapsedColor);
    }

    void rotate(Component c15, Graphics2D g15) {
        if (!c15.getComponentOrientation().isLeftToRight()) {
            g15.rotate(Math.toRadians(180.0), (double)this.width / 2.0, (double)this.height / 2.0);
        }
    }

    static <T> T getStyleFromTreeUI(Component c15, Function<FlatTreeUI, T> f15) {
        TreeUI ui4;
        JTree tree;
        JTree jTree = tree = c15 instanceof JTree ? (JTree)c15 : (JTree)SwingUtilities.getAncestorOfClass(JTree.class, c15);
        if (tree != null && (ui4 = tree.getUI()) instanceof FlatTreeUI) {
            return f15.apply((FlatTreeUI)ui4);
        }
        return null;
    }

    static void setStyleColorFromTreeUI(Component c15, Graphics2D g15, Function<FlatTreeUI, Color> f15) {
        Color color = FlatTreeCollapsedIcon.getStyleFromTreeUI(c15, f15);
        if (color != null) {
            g15.setColor(color);
        }
    }
}

