/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked.raw;

import com.android.tools.smali.dexlib2.dexbacked.DexBuffer;

public class OdexHeaderItem {
    public static final int ITEM_SIZE = 40;
    private static final byte[] MAGIC_VALUE = new byte[]{100, 101, 121, 10, 0, 0, 0, 0};
    private static final int[] SUPPORTED_ODEX_VERSIONS = new int[]{35, 36};
    public static final int MAGIC_OFFSET = 0;
    public static final int MAGIC_LENGTH = 8;
    public static final int DEX_OFFSET = 8;
    public static final int DEX_LENGTH_OFFSET = 12;
    public static final int DEPENDENCIES_OFFSET = 16;
    public static final int DEPENDENCIES_LENGTH_OFFSET = 20;
    public static final int AUX_OFFSET = 24;
    public static final int AUX_LENGTH_OFFSET = 28;
    public static final int FLAGS_OFFSET = 32;

    public static boolean verifyMagic(byte[] buf, int offset) {
        int i15;
        if (buf.length - offset < 8) {
            return false;
        }
        for (i15 = 0; i15 < 4; ++i15) {
            if (buf[offset + i15] == MAGIC_VALUE[i15]) continue;
            return false;
        }
        for (i15 = 4; i15 < 7; ++i15) {
            if (buf[offset + i15] >= 48 && buf[offset + i15] <= 57) continue;
            return false;
        }
        return buf[offset + 7] == MAGIC_VALUE[7];
    }

    public static int getVersion(byte[] buf, int offset) {
        if (!OdexHeaderItem.verifyMagic(buf, offset)) {
            return -1;
        }
        return OdexHeaderItem.getVersionUnchecked(buf, offset);
    }

    private static int getVersionUnchecked(byte[] buf, int offset) {
        int version = (buf[offset + 4] - 48) * 100;
        version += (buf[offset + 5] - 48) * 10;
        return version += buf[offset + 6] - 48;
    }

    public static boolean isSupportedOdexVersion(int version) {
        for (int i15 = 0; i15 < SUPPORTED_ODEX_VERSIONS.length; ++i15) {
            if (SUPPORTED_ODEX_VERSIONS[i15] != version) continue;
            return true;
        }
        return false;
    }

    public static int getDexOffset(byte[] buf) {
        DexBuffer bdb = new DexBuffer(buf);
        return bdb.readSmallUint(8);
    }

    public static int getDependenciesOffset(byte[] buf) {
        DexBuffer bdb = new DexBuffer(buf);
        return bdb.readSmallUint(16);
    }
}

