/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.mergers;

import com.android.tools.build.bundletool.mergers.AndroidManifestMerger;
import com.android.tools.build.bundletool.mergers.AutoValue_FusingAndroidManifestMerger_ApplicationElementId;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ManifestEditor;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttribute;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoAttributeBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElement;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElementBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNodeBuilder;
import com.google.auto.value.AutoValue;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class FusingAndroidManifestMerger
implements AndroidManifestMerger {
    private final ImmutableSet<String> elementsToMerge;
    private final Mode mode;

    public FusingAndroidManifestMerger(ImmutableSet<String> elementsToMerge, Mode mode) {
        this.elementsToMerge = elementsToMerge;
        this.mode = mode;
    }

    @Override
    public AndroidManifest merge(SetMultimap<BundleModuleName, AndroidManifest> manifests) {
        if (!manifests.containsKey(BundleModuleName.BASE_MODULE_NAME)) {
            throw CommandExecutionException.builder().withInternalMessage("Expected to have base module.").build();
        }
        return this.merge(FusingAndroidManifestMerger.ensureOneManifestPerModule(manifests));
    }

    private AndroidManifest merge(Map<BundleModuleName, AndroidManifest> manifests) {
        AndroidManifest baseManifest = manifests.get(BundleModuleName.BASE_MODULE_NAME);
        List featureManifests = manifests.entrySet().stream().filter(entry -> !BundleModuleName.BASE_MODULE_NAME.equals(entry.getKey())).sorted(Comparator.comparing(entry -> ((BundleModuleName)entry.getKey()).getName())).map(Map.Entry::getValue).collect(ImmutableList.toImmutableList());
        if (featureManifests.isEmpty()) {
            return baseManifest;
        }
        return this.mergeManifests(baseManifest, featureManifests);
    }

    private AndroidManifest mergeManifests(AndroidManifest baseManifest, List<AndroidManifest> featureManifests) {
        ImmutableListMultimap<ApplicationElementId, XmlProtoElement> applicationElements = FusingAndroidManifestMerger.gatherApplicationElementsManifests((List<AndroidManifest>)((Object)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(featureManifests)).add(baseManifest)).build()), this.elementsToMerge);
        long numberOfMergeableElementsInBase = ((XmlProtoElement)baseManifest.getManifestRoot().getElement()).getChildrenElements("application").flatMap(application -> application.getChildrenElements()).filter(element -> this.elementsToMerge.contains(element.getName())).count();
        if (numberOfMergeableElementsInBase == (long)applicationElements.size()) {
            return baseManifest;
        }
        ImmutableMap mergedElements = applicationElements.keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), key -> this.mergeElements((ApplicationElementId)key, (List<XmlProtoElement>)((Object)applicationElements.get(key)))));
        ManifestEditor manifestEditor = baseManifest.toEditor();
        XmlProtoElementBuilder applicationElement = manifestEditor.getRawProto().getOrCreateChildElement("application");
        Set replacedElements = Sets.newIdentityHashSet();
        applicationElement.modifyChildElements(child -> Streams.stream(FusingAndroidManifestMerger.getCorrespondingElementFromMergedElements(child, mergedElements)).peek(replacedElements::add).map(element -> XmlProtoNodeBuilder.createElementNode(element.toBuilder())).collect(MoreCollectors.toOptional()).orElse((XmlProtoNodeBuilder)child));
        mergedElements.values().stream().filter(Predicates.not(replacedElements::contains)).forEach(element -> applicationElement.addChildElement(element.toBuilder()));
        return manifestEditor.save();
    }

    private XmlProtoElement mergeElements(ApplicationElementId elementId, List<XmlProtoElement> elements) {
        if (this.mode.equals((Object)Mode.REPLACE) || elements.size() == 1) {
            return elements.get(0);
        }
        List elementsNoSource = elements.stream().map(element -> element.toBuilder().removeSourceDataRecursive().build()).collect(ImmutableList.toImmutableList());
        Set intentFilters = elementsNoSource.stream().flatMap(element -> element.getChildrenElements("intent-filter")).collect(ImmutableSet.toImmutableSet());
        ImmutableMap metadataByName = elementsNoSource.stream().flatMap(element -> element.getChildrenElements("meta-data")).filter(meta -> meta.getAndroidAttribute(0x1010003).isPresent()).collect(ImmutableMap.toImmutableMap(meta -> ((XmlProtoAttribute)meta.getAndroidAttribute(0x1010003).get()).getValueAsString(), Function.identity(), (a15, b15) -> {
            if (!a15.equals(b15)) {
                throw CommandExecutionException.builder().withInternalMessage("Multiple meta-data entries with the same name are found inside %s:%s: %s, %s", elementId.getType(), elementId.getName(), a15, b15).build();
            }
            return a15;
        }));
        XmlProtoElementBuilder builder = ((XmlProtoElement)elementsNoSource.get(0)).toBuilder();
        builder.removeChildrenElementsIf(child -> {
            if (!child.isElement()) {
                return false;
            }
            XmlProtoElementBuilder childElement = (XmlProtoElementBuilder)child.getElement();
            String tag = childElement.getName();
            Optional<String> name = childElement.getAndroidAttribute(0x1010003).map(rec$ -> ((XmlProtoAttributeBuilder)rec$).getValueAsString());
            if (tag.equals("intent-filter")) return true;
            if (!tag.equals("meta-data")) return false;
            if (name.map(metadataByName::containsKey).orElse(false) == false) return false;
            return true;
        });
        intentFilters.forEach(e15 -> builder.addChildElement(e15.toBuilder()));
        metadataByName.values().forEach(e15 -> builder.addChildElement(e15.toBuilder()));
        return builder.build();
    }

    private static ImmutableListMultimap<ApplicationElementId, XmlProtoElement> gatherApplicationElementsManifests(List<AndroidManifest> featureManifests, ImmutableSet<String> elementsToMerge) {
        ImmutableListMultimap.Builder featureElementsBuilder = ImmutableListMultimap.builder();
        featureManifests.forEach(manifest -> FusingAndroidManifestMerger.gatherApplicationElements(manifest, elementsToMerge, featureElementsBuilder));
        return featureElementsBuilder.build();
    }

    private static void gatherApplicationElements(AndroidManifest manifest, ImmutableSet<String> elementsToMerge, ImmutableListMultimap.Builder<ApplicationElementId, XmlProtoElement> featureElementsBuilder) {
        Optional manifestElement = ((XmlProtoElement)manifest.getManifestRoot().getElement()).getOptionalChildElement("application");
        Streams.stream(manifestElement).flatMap(application -> application.getChildrenElements()).filter(child -> elementsToMerge.contains(child.getName())).filter(child -> child.getAndroidAttribute(0x1010003).isPresent() && !FusingAndroidManifestMerger.isMetaDataGmsCoreVersion(child)).forEach(child -> featureElementsBuilder.put(ApplicationElementId.create(child.getName(), FusingAndroidManifestMerger.getNameAttribute(child)), child));
    }

    private static Optional<XmlProtoElement> getCorrespondingElementFromMergedElements(XmlProtoNodeBuilder node, ImmutableMap<ApplicationElementId, XmlProtoElement> mergedElements) {
        if (!node.isElement()) {
            return Optional.empty();
        }
        Optional name = ((XmlProtoElementBuilder)node.getElement()).getAndroidAttribute(0x1010003);
        return name.map(xmlProtoAttributeBuilder -> (XmlProtoElement)mergedElements.get(ApplicationElementId.create(((XmlProtoElementBuilder)node.getElement()).getName(), xmlProtoAttributeBuilder.getValueAsString())));
    }

    private static String getNameAttribute(XmlProtoElement element) {
        return ((XmlProtoAttribute)element.getAndroidAttribute(0x1010003).get()).getValueAsString();
    }

    private static ImmutableMap<BundleModuleName, AndroidManifest> ensureOneManifestPerModule(SetMultimap<BundleModuleName, AndroidManifest> manifests) {
        ImmutableMap.Builder<BundleModuleName, AndroidManifest> builder = ImmutableMap.builder();
        for (BundleModuleName moduleName : manifests.keySet()) {
            Collection moduleManifests = manifests.get((Object)moduleName);
            if (moduleManifests.size() != 1) {
                throw CommandExecutionException.builder().withInternalMessage("Expected exactly one %s module manifest, but found %d.", moduleName.getName(), moduleManifests.size()).build();
            }
            builder.put(moduleName, (AndroidManifest)Iterables.getOnlyElement(moduleManifests));
        }
        return builder.build();
    }

    private static boolean isMetaDataGmsCoreVersion(XmlProtoElement element) {
        return element.getAndroidAttribute(0x1010003).isPresent() && ((XmlProtoAttribute)element.getAndroidAttribute(0x1010003).get()).getValueAsString().equals("com.google.android.gms.version");
    }

    @AutoValue
    static abstract class ApplicationElementId {
        ApplicationElementId() {
        }

        abstract String getType();

        abstract String getName();

        static ApplicationElementId create(String type, String name) {
            return new AutoValue_FusingAndroidManifestMerger_ApplicationElementId(type, name);
        }
    }

    public static enum Mode {
        REPLACE,
        MERGE_CHILDREN;

    }
}

