/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.mergers;

import com.android.tools.build.bundletool.commands.BuildApksModule;
import com.android.tools.build.bundletool.mergers.DexMerger;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.ThrowableUtils;
import com.android.tools.build.bundletool.model.utils.files.FilePreconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import javax.inject.Inject;
import shadow.bundletool.com.android.tools.r8.CompilationFailedException;
import shadow.bundletool.com.android.tools.r8.CompilationMode;
import shadow.bundletool.com.android.tools.r8.D8;
import shadow.bundletool.com.android.tools.r8.D8Command;
import shadow.bundletool.com.android.tools.r8.DexIndexedConsumer;
import shadow.bundletool.com.android.tools.r8.Diagnostic;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.OutputMode;

public class D8DexMerger
implements DexMerger {
    private static final String CORE_DESUGARING_PREFIX = "j$.";
    private static final String CORE_DESUGARING_LIBRARY_EXCEPTION = "Merging dex file containing classes with prefix 'j$.'";
    private static final String CORE_DESUGARING_LIBRARY_EXCEPTION_NEW = "Merging DEX file containing classes with prefix 'j$.'";
    private static final String DEX_OVERFLOW_MSG = "Cannot fit requested classes in a single dex file";
    private final boolean verbose;

    @Inject
    D8DexMerger(@BuildApksModule.VerboseLogs boolean verbose) {
        this.verbose = verbose;
    }

    D8DexMerger() {
        this(false);
    }

    @Override
    public ImmutableList<Path> merge(ImmutableList<Path> dexFiles, Path outputDir, Optional<Path> mainDexListFile, Optional<Path> proguardMap, boolean isDebuggable, int minSdkVersion) {
        try {
            D8DexMerger.validateInput(dexFiles, outputDir);
            D8Command.Builder command = (D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)D8Command.builder(new DiagnosticsHandler(){

                @Override
                public void error(Diagnostic error) {
                    if (D8DexMerger.isCoreDesugaringMessage(error.getDiagnosticMessage())) {
                        return;
                    }
                    DiagnosticsHandler.super.error(error);
                }

                @Override
                public void warning(Diagnostic warning) {
                    if (D8DexMerger.this.verbose) {
                        DiagnosticsHandler.super.warning(warning);
                    }
                }

                @Override
                public void info(Diagnostic info) {
                    if (D8DexMerger.this.verbose) {
                        DiagnosticsHandler.super.info(info);
                    }
                }
            }).setOutput(outputDir, OutputMode.DexIndexed)).addProgramFiles(dexFiles)).setMinApiLevel(minSdkVersion)).setMode(isDebuggable ? CompilationMode.DEBUG : CompilationMode.RELEASE);
            mainDexListFile.ifPresent(xva$0 -> {
                D8Command.Builder cfr_ignored_0 = (D8Command.Builder)command.addMainDexListFiles((Path)xva$0);
            });
            proguardMap.ifPresent(command::setProguardInputMapFile);
            D8.run((D8Command)command.build());
            File[] mergedFiles = outputDir.toFile().listFiles();
            return Arrays.stream(mergedFiles).map(File::toPath).collect(ImmutableList.toImmutableList());
        }
        catch (CompilationFailedException e15) {
            D8DexMerger.cleanupOutputDir(outputDir);
            if (D8DexMerger.isCoreDesugaringException(e15)) {
                return this.mergeAppDexFilesAndRenameCoreDesugaringDex(dexFiles, outputDir, mainDexListFile, proguardMap, isDebuggable, minSdkVersion);
            }
            if (proguardMap.isPresent()) {
                return this.merge(dexFiles, outputDir, mainDexListFile, Optional.empty(), isDebuggable, minSdkVersion);
            }
            throw D8DexMerger.translateD8Exception(e15);
        }
    }

    private static void validateInput(ImmutableList<Path> dexFiles, Path outputDir) {
        FilePreconditions.checkDirectoryExistsAndEmpty(outputDir);
        dexFiles.forEach(FilePreconditions::checkFileExistsAndReadable);
    }

    private static CommandExecutionException translateD8Exception(CompilationFailedException d8Exception) {
        if (ThrowableUtils.anyInCausalChainOrSuppressedMatches(d8Exception, t15 -> t15.getMessage() != null && t15.getMessage().contains(DEX_OVERFLOW_MSG))) {
            return CommandExecutionException.builder().withInternalMessage("Dex merging failed because the result does not fit into a single dex file and multidex is not supported by the input.").withCause(d8Exception).build();
        }
        Throwable rootCause = Throwables.getRootCause(d8Exception);
        return CommandExecutionException.builder().withInternalMessage("Dex merging failed. %s", rootCause.getMessage()).withCause(d8Exception).build();
    }

    private static boolean isCoreDesugaringException(CompilationFailedException d8Exception) {
        return ThrowableUtils.anyInCausalChainOrSuppressedMatches(d8Exception, t15 -> t15.getMessage() != null && D8DexMerger.isCoreDesugaringMessage(t15.getMessage()));
    }

    private static boolean isCoreDesugaringMessage(String message2) {
        return message2.contains(CORE_DESUGARING_LIBRARY_EXCEPTION) || message2.contains(CORE_DESUGARING_LIBRARY_EXCEPTION_NEW);
    }

    private ImmutableList<Path> mergeAppDexFilesAndRenameCoreDesugaringDex(ImmutableList<Path> dexFiles, Path outputDir, Optional<Path> mainDexListFile, Optional<Path> proguardMap, boolean isDebuggable, int minSdkVersion) {
        ImmutableList desugaringDexFiles = dexFiles.stream().filter(D8DexMerger::isCoreDesugaringDex).collect(ImmutableList.toImmutableList());
        ImmutableList<Path> appDexFiles = dexFiles.stream().filter(dex -> !desugaringDexFiles.contains(dex)).collect(ImmutableList.toImmutableList());
        ImmutableList<Path> mergedAppDexFiles = this.merge(appDexFiles, outputDir, mainDexListFile, proguardMap, isDebuggable, minSdkVersion);
        ImmutableList mergedDesugaringDexFiles = Streams.mapWithIndex(desugaringDexFiles.stream(), (dex, index) -> D8DexMerger.copyDexToOutput(dex, outputDir, (int)index + 1 + mergedAppDexFiles.size())).collect(ImmutableList.toImmutableList());
        return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(mergedAppDexFiles)).addAll((Iterable)mergedDesugaringDexFiles)).build();
    }

    private static Path copyDexToOutput(Path input, Path outputDir, int index) {
        String outputName = index == 1 ? "classes.dex" : String.format("classes%d.dex", index);
        Path output = outputDir.resolve(outputName);
        try {
            Files.copy(input, output, new CopyOption[0]);
            return output;
        }
        catch (IOException e15) {
            throw new UncheckedIOException(e15);
        }
    }

    private static boolean isCoreDesugaringDex(Path dexFile) {
        try {
            boolean[] isDesugaringDex = new boolean[]{false};
            D8Command.Builder builder = (D8Command.Builder)((D8Command.Builder)D8Command.builder().addProgramFiles(dexFile)).setProgramConsumer(new DexIndexedConsumer.ForwardingConsumer(null));
            builder.addOutputInspection(inspection -> inspection.forEachClass(clazz -> {
                isDesugaringDex[0] = isDesugaringDex[0] || clazz.getClassReference().getTypeName().startsWith(CORE_DESUGARING_PREFIX);
            }));
            D8.run((D8Command)builder.build());
            return isDesugaringDex[0];
        }
        catch (CompilationFailedException e15) {
            throw CommandExecutionException.builder().withInternalMessage("Failed to read dex file %s.", dexFile.getFileName().toString()).withCause(e15).build();
        }
    }

    private static void cleanupOutputDir(Path outputDir) {
        try {
            MoreFiles.deleteDirectoryContents(outputDir, RecursiveDeleteOption.ALLOW_INSECURE);
        }
        catch (IOException e15) {
            throw new UncheckedIOException(e15);
        }
    }
}

