/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.util;

import com.android.dx.util.BitIntSet;
import com.android.dx.util.Bits;
import com.android.dx.util.IntIterator;
import com.android.dx.util.IntList;
import com.android.dx.util.IntSet;
import java.util.NoSuchElementException;

public class ListIntSet
implements IntSet {
    final IntList ints = new IntList();

    public ListIntSet() {
        this.ints.sort();
    }

    @Override
    public void add(int value) {
        int index = this.ints.binarysearch(value);
        if (index < 0) {
            this.ints.insert(-(index + 1), value);
        }
    }

    @Override
    public void remove(int value) {
        int index = this.ints.indexOf(value);
        if (index >= 0) {
            this.ints.removeIndex(index);
        }
    }

    @Override
    public boolean has(int value) {
        return this.ints.indexOf(value) >= 0;
    }

    @Override
    public void merge(IntSet other) {
        if (other instanceof ListIntSet) {
            ListIntSet o15 = (ListIntSet)other;
            int szThis = this.ints.size();
            int szOther = o15.ints.size();
            int i15 = 0;
            int j15 = 0;
            while (j15 < szOther && i15 < szThis) {
                while (j15 < szOther && o15.ints.get(j15) < this.ints.get(i15)) {
                    this.add(o15.ints.get(j15++));
                }
                if (j15 == szOther) break;
                while (i15 < szThis && o15.ints.get(j15) >= this.ints.get(i15)) {
                    ++i15;
                }
            }
            while (j15 < szOther) {
                this.add(o15.ints.get(j15++));
            }
            this.ints.sort();
        } else if (other instanceof BitIntSet) {
            BitIntSet o16 = (BitIntSet)other;
            int i16 = 0;
            while (i16 >= 0) {
                this.ints.add(i16);
                i16 = Bits.findFirst(o16.bits, i16 + 1);
            }
            this.ints.sort();
        } else {
            IntIterator iter = other.iterator();
            while (iter.hasNext()) {
                this.add(iter.next());
            }
        }
    }

    @Override
    public int elements() {
        return this.ints.size();
    }

    @Override
    public IntIterator iterator() {
        return new IntIterator(){
            private int idx = 0;

            @Override
            public boolean hasNext() {
                return this.idx < ListIntSet.this.ints.size();
            }

            @Override
            public int next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ListIntSet.this.ints.get(this.idx++);
            }
        };
    }

    public String toString() {
        return this.ints.toString();
    }
}

