/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.dump;

import com.android.dx.cf.code.ConcreteMethod;
import com.android.dx.cf.code.Ropper;
import com.android.dx.cf.iface.Member;
import com.android.dx.cf.iface.Method;
import com.android.dx.command.dump.Args;
import com.android.dx.command.dump.BlockDumper;
import com.android.dx.rop.code.AccessFlags;
import com.android.dx.rop.code.DexTranslationAdvice;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.ssa.Optimizer;
import com.android.dx.ssa.SsaBasicBlock;
import com.android.dx.ssa.SsaInsn;
import com.android.dx.ssa.SsaMethod;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;
import com.android.dx.util.IntList;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;

public class SsaDumper
extends BlockDumper {
    public static void dump(byte[] bytes, PrintStream out, String filePath, Args args) {
        SsaDumper sd5 = new SsaDumper(bytes, out, filePath, args);
        sd5.dump();
    }

    private SsaDumper(byte[] bytes, PrintStream out, String filePath, Args args) {
        super(bytes, out, filePath, true, args);
    }

    @Override
    public void endParsingMember(ByteArray bytes, int offset, String name, String descriptor2, Member member) {
        if (!(member instanceof Method)) {
            return;
        }
        if (!this.shouldDumpMethod(name)) {
            return;
        }
        if ((member.getAccessFlags() & 0x500) != 0) {
            return;
        }
        ConcreteMethod meth = new ConcreteMethod((Method)member, this.classFile, true, true);
        DexTranslationAdvice advice = DexTranslationAdvice.THE_ONE;
        RopMethod rmeth = Ropper.convert(meth, advice, this.classFile.getMethods(), this.dexOptions);
        SsaMethod ssaMeth = null;
        boolean isStatic = AccessFlags.isStatic(meth.getAccessFlags());
        int paramWidth = SsaDumper.computeParamWidth(meth, isStatic);
        if (this.args.ssaStep == null) {
            ssaMeth = Optimizer.debugNoRegisterAllocation(rmeth, paramWidth, isStatic, true, advice, EnumSet.allOf(Optimizer.OptionalStep.class));
        } else if ("edge-split".equals(this.args.ssaStep)) {
            ssaMeth = Optimizer.debugEdgeSplit(rmeth, paramWidth, isStatic, true, advice);
        } else if ("phi-placement".equals(this.args.ssaStep)) {
            ssaMeth = Optimizer.debugPhiPlacement(rmeth, paramWidth, isStatic, true, advice);
        } else if ("renaming".equals(this.args.ssaStep)) {
            ssaMeth = Optimizer.debugRenaming(rmeth, paramWidth, isStatic, true, advice);
        } else if ("dead-code".equals(this.args.ssaStep)) {
            ssaMeth = Optimizer.debugDeadCodeRemover(rmeth, paramWidth, isStatic, true, advice);
        }
        StringBuilder sb5 = new StringBuilder(2000);
        sb5.append("first ");
        sb5.append(Hex.u2(ssaMeth.blockIndexToRopLabel(ssaMeth.getEntryBlockIndex())));
        sb5.append('\n');
        ArrayList<SsaBasicBlock> blocks = ssaMeth.getBlocks();
        ArrayList sortedBlocks = (ArrayList)blocks.clone();
        Collections.sort(sortedBlocks, SsaBasicBlock.LABEL_COMPARATOR);
        for (SsaBasicBlock block : sortedBlocks) {
            sb5.append("block ").append(Hex.u2(block.getRopLabel())).append('\n');
            BitSet preds = block.getPredecessors();
            int i15 = preds.nextSetBit(0);
            while (i15 >= 0) {
                sb5.append("  pred ");
                sb5.append(Hex.u2(ssaMeth.blockIndexToRopLabel(i15)));
                sb5.append('\n');
                i15 = preds.nextSetBit(i15 + 1);
            }
            sb5.append("  live in:" + block.getLiveInRegs());
            sb5.append("\n");
            for (SsaInsn insn : block.getInsns()) {
                sb5.append("  ");
                sb5.append(insn.toHuman());
                sb5.append('\n');
            }
            if (block.getSuccessors().cardinality() == 0) {
                sb5.append("  returns\n");
            } else {
                int primary = block.getPrimarySuccessorRopLabel();
                IntList succLabelList = block.getRopLabelSuccessorList();
                int szSuccLabels = succLabelList.size();
                for (int i16 = 0; i16 < szSuccLabels; ++i16) {
                    sb5.append("  next ");
                    sb5.append(Hex.u2(succLabelList.get(i16)));
                    if (szSuccLabels != 1 && primary == succLabelList.get(i16)) {
                        sb5.append(" *");
                    }
                    sb5.append('\n');
                }
            }
            sb5.append("  live out:" + block.getLiveOutRegs());
            sb5.append("\n");
        }
        this.suppressDump = false;
        this.parsed(bytes, 0, bytes.size(), sb5.toString());
        this.suppressDump = true;
    }
}

