/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.direct;

import com.android.dx.cf.direct.AttributeFactory;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.iface.Attribute;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.cf.iface.ParseObserver;
import com.android.dx.cf.iface.StdAttributeList;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;

final class AttributeListParser {
    private final DirectClassFile cf;
    private final int context;
    private final int offset;
    private final AttributeFactory attributeFactory;
    private final StdAttributeList list;
    private int endOffset;
    private ParseObserver observer;

    public AttributeListParser(DirectClassFile cf5, int context, int offset, AttributeFactory attributeFactory) {
        if (cf5 == null) {
            throw new NullPointerException("cf == null");
        }
        if (attributeFactory == null) {
            throw new NullPointerException("attributeFactory == null");
        }
        int size = cf5.getBytes().getUnsignedShort(offset);
        this.cf = cf5;
        this.context = context;
        this.offset = offset;
        this.attributeFactory = attributeFactory;
        this.list = new StdAttributeList(size);
        this.endOffset = -1;
    }

    public void setObserver(ParseObserver observer) {
        this.observer = observer;
    }

    public int getEndOffset() {
        this.parseIfNecessary();
        return this.endOffset;
    }

    public StdAttributeList getList() {
        this.parseIfNecessary();
        return this.list;
    }

    private void parseIfNecessary() {
        if (this.endOffset < 0) {
            this.parse();
        }
    }

    private void parse() {
        int sz4 = this.list.size();
        int at4 = this.offset + 2;
        ByteArray bytes = this.cf.getBytes();
        if (this.observer != null) {
            this.observer.parsed(bytes, this.offset, 2, "attributes_count: " + Hex.u2(sz4));
        }
        for (int i15 = 0; i15 < sz4; ++i15) {
            try {
                if (this.observer != null) {
                    this.observer.parsed(bytes, at4, 0, "\nattributes[" + i15 + "]:\n");
                    this.observer.changeIndent(1);
                }
                Attribute attrib = this.attributeFactory.parse(this.cf, this.context, at4, this.observer);
                at4 += attrib.byteLength();
                this.list.set(i15, attrib);
                if (this.observer == null) continue;
                this.observer.changeIndent(-1);
                this.observer.parsed(bytes, at4, 0, "end attributes[" + i15 + "]\n");
                continue;
            }
            catch (ParseException ex4) {
                ex4.addContext("...while parsing attributes[" + i15 + "]");
                throw ex4;
            }
            catch (RuntimeException ex5) {
                ParseException pe5 = new ParseException(ex5);
                pe5.addContext("...while parsing attributes[" + i15 + "]");
                throw pe5;
            }
        }
        this.endOffset = at4;
    }
}

