/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dex.util.ExceptionWithContext;
import com.android.dx.cf.code.LocalsArray;
import com.android.dx.cf.code.OneLocalsArray;
import com.android.dx.cf.code.SimException;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeBearer;
import com.android.dx.util.Hex;
import java.util.ArrayList;

public class LocalsArraySet
extends LocalsArray {
    private final OneLocalsArray primary;
    private final ArrayList<LocalsArray> secondaries;

    public LocalsArraySet(int maxLocals) {
        super(maxLocals != 0);
        this.primary = new OneLocalsArray(maxLocals);
        this.secondaries = new ArrayList();
    }

    public LocalsArraySet(OneLocalsArray primary, ArrayList<LocalsArray> secondaries) {
        super(primary.getMaxLocals() > 0);
        this.primary = primary;
        this.secondaries = secondaries;
    }

    private LocalsArraySet(LocalsArraySet toCopy) {
        super(toCopy.getMaxLocals() > 0);
        this.primary = toCopy.primary.copy();
        this.secondaries = new ArrayList(toCopy.secondaries.size());
        int sz4 = toCopy.secondaries.size();
        for (int i15 = 0; i15 < sz4; ++i15) {
            LocalsArray la5 = toCopy.secondaries.get(i15);
            if (la5 == null) {
                this.secondaries.add(null);
                continue;
            }
            this.secondaries.add(la5.copy());
        }
    }

    @Override
    public void setImmutable() {
        this.primary.setImmutable();
        for (LocalsArray la5 : this.secondaries) {
            if (la5 == null) continue;
            la5.setImmutable();
        }
        super.setImmutable();
    }

    @Override
    public LocalsArray copy() {
        return new LocalsArraySet(this);
    }

    @Override
    public void annotate(ExceptionWithContext ex4) {
        ex4.addContext("(locals array set; primary)");
        this.primary.annotate(ex4);
        int sz4 = this.secondaries.size();
        for (int label = 0; label < sz4; ++label) {
            LocalsArray la5 = this.secondaries.get(label);
            if (la5 == null) continue;
            ex4.addContext("(locals array set: primary for caller " + Hex.u2(label) + ')');
            la5.getPrimary().annotate(ex4);
        }
    }

    @Override
    public String toHuman() {
        StringBuilder sb5 = new StringBuilder();
        sb5.append("(locals array set; primary)\n");
        sb5.append(this.getPrimary().toHuman());
        sb5.append('\n');
        int sz4 = this.secondaries.size();
        for (int label = 0; label < sz4; ++label) {
            LocalsArray la5 = this.secondaries.get(label);
            if (la5 == null) continue;
            sb5.append("(locals array set: primary for caller " + Hex.u2(label) + ")\n");
            sb5.append(la5.getPrimary().toHuman());
            sb5.append('\n');
        }
        return sb5.toString();
    }

    @Override
    public void makeInitialized(Type type) {
        int len = this.primary.getMaxLocals();
        if (len == 0) {
            return;
        }
        this.throwIfImmutable();
        this.primary.makeInitialized(type);
        for (LocalsArray la5 : this.secondaries) {
            if (la5 == null) continue;
            la5.makeInitialized(type);
        }
    }

    @Override
    public int getMaxLocals() {
        return this.primary.getMaxLocals();
    }

    @Override
    public void set(int idx, TypeBearer type) {
        this.throwIfImmutable();
        this.primary.set(idx, type);
        for (LocalsArray la5 : this.secondaries) {
            if (la5 == null) continue;
            la5.set(idx, type);
        }
    }

    @Override
    public void set(RegisterSpec spec) {
        this.set(spec.getReg(), spec);
    }

    @Override
    public void invalidate(int idx) {
        this.throwIfImmutable();
        this.primary.invalidate(idx);
        for (LocalsArray la5 : this.secondaries) {
            if (la5 == null) continue;
            la5.invalidate(idx);
        }
    }

    @Override
    public TypeBearer getOrNull(int idx) {
        return this.primary.getOrNull(idx);
    }

    @Override
    public TypeBearer get(int idx) {
        return this.primary.get(idx);
    }

    @Override
    public TypeBearer getCategory1(int idx) {
        return this.primary.getCategory1(idx);
    }

    @Override
    public TypeBearer getCategory2(int idx) {
        return this.primary.getCategory2(idx);
    }

    private LocalsArraySet mergeWithSet(LocalsArraySet other) {
        boolean secondariesChanged = false;
        OneLocalsArray newPrimary = this.primary.merge(other.getPrimary());
        int sz12 = this.secondaries.size();
        int sz22 = other.secondaries.size();
        int sz4 = Math.max(sz12, sz22);
        ArrayList<LocalsArray> newSecondaries = new ArrayList<LocalsArray>(sz4);
        for (int i15 = 0; i15 < sz4; ++i15) {
            LocalsArray la12 = i15 < sz12 ? this.secondaries.get(i15) : null;
            LocalsArray la22 = i15 < sz22 ? other.secondaries.get(i15) : null;
            LocalsArray resultla = null;
            if (la12 == la22) {
                resultla = la12;
            } else if (la12 == null) {
                resultla = la22;
            } else if (la22 == null) {
                resultla = la12;
            } else {
                try {
                    resultla = la12.merge(la22);
                }
                catch (SimException ex4) {
                    ex4.addContext("Merging locals set for caller block " + Hex.u2(i15));
                }
            }
            secondariesChanged = secondariesChanged || la12 != resultla;
            newSecondaries.add(resultla);
        }
        if (this.primary == newPrimary && !secondariesChanged) {
            return this;
        }
        return new LocalsArraySet(newPrimary, newSecondaries);
    }

    private LocalsArraySet mergeWithOne(OneLocalsArray other) {
        boolean secondariesChanged = false;
        OneLocalsArray newPrimary = this.primary.merge(other.getPrimary());
        ArrayList<LocalsArray> newSecondaries = new ArrayList<LocalsArray>(this.secondaries.size());
        int sz4 = this.secondaries.size();
        for (int i15 = 0; i15 < sz4; ++i15) {
            LocalsArray la5 = this.secondaries.get(i15);
            LocalsArray resultla = null;
            if (la5 != null) {
                try {
                    resultla = la5.merge(other);
                }
                catch (SimException ex4) {
                    ex4.addContext("Merging one locals against caller block " + Hex.u2(i15));
                }
            }
            secondariesChanged = secondariesChanged || la5 != resultla;
            newSecondaries.add(resultla);
        }
        if (this.primary == newPrimary && !secondariesChanged) {
            return this;
        }
        return new LocalsArraySet(newPrimary, newSecondaries);
    }

    @Override
    public LocalsArraySet merge(LocalsArray other) {
        LocalsArraySet result;
        try {
            result = other instanceof LocalsArraySet ? this.mergeWithSet((LocalsArraySet)other) : this.mergeWithOne((OneLocalsArray)other);
        }
        catch (SimException ex4) {
            ex4.addContext("underlay locals:");
            this.annotate(ex4);
            ex4.addContext("overlay locals:");
            other.annotate(ex4);
            throw ex4;
        }
        result.setImmutable();
        return result;
    }

    private LocalsArray getSecondaryForLabel(int label) {
        if (label >= this.secondaries.size()) {
            return null;
        }
        return this.secondaries.get(label);
    }

    @Override
    public LocalsArraySet mergeWithSubroutineCaller(LocalsArray other, int predLabel) {
        LocalsArray mine = this.getSecondaryForLabel(predLabel);
        OneLocalsArray newPrimary = this.primary.merge(other.getPrimary());
        LocalsArray newSecondary = mine == other ? mine : (mine == null ? other : mine.merge(other));
        if (newSecondary == mine && newPrimary == this.primary) {
            return this;
        }
        newPrimary = null;
        int szSecondaries = this.secondaries.size();
        int sz4 = Math.max(predLabel + 1, szSecondaries);
        ArrayList<LocalsArray> newSecondaries = new ArrayList<LocalsArray>(sz4);
        for (int i15 = 0; i15 < sz4; ++i15) {
            LocalsArray la5 = null;
            if (i15 == predLabel) {
                la5 = newSecondary;
            } else if (i15 < szSecondaries) {
                la5 = this.secondaries.get(i15);
            }
            if (la5 != null) {
                newPrimary = newPrimary == null ? la5.getPrimary() : newPrimary.merge(la5.getPrimary());
            }
            newSecondaries.add(la5);
        }
        LocalsArraySet result = new LocalsArraySet(newPrimary, newSecondaries);
        result.setImmutable();
        return result;
    }

    public LocalsArray subArrayForLabel(int subLabel) {
        LocalsArray result = this.getSecondaryForLabel(subLabel);
        return result;
    }

    @Override
    protected OneLocalsArray getPrimary() {
        return this.primary;
    }
}

