/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.ThrowableToStringArray;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.StatusUtil;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class StatusPrinter2 {
    private PrintStream ps = System.out;
    static CachingDateFormatter cachingDateFormat = new CachingDateFormatter("HH:mm:ss,SSS");

    public void setPrintStream(PrintStream printStream) {
        this.ps = printStream;
    }

    public void printInCaseOfErrorsOrWarnings(Context context) {
        this.printInCaseOfErrorsOrWarnings(context, 0L);
    }

    public void printInCaseOfErrorsOrWarnings(Context context, long threshold) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager sm4 = context.getStatusManager();
        if (sm4 == null) {
            this.ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        } else {
            StatusUtil statusUtil = new StatusUtil(context);
            if (statusUtil.getHighestLevel(threshold) >= 1) {
                this.print(sm4, threshold);
            }
        }
    }

    public void printIfErrorsOccured(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager sm4 = context.getStatusManager();
        if (sm4 == null) {
            this.ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        } else {
            StatusUtil statusUtil = new StatusUtil(context);
            if (statusUtil.getHighestLevel(0L) == 2) {
                this.print(sm4);
            }
        }
    }

    public void print(Context context) {
        this.print(context, 0L);
    }

    public void print(Context context, long threshold) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager sm4 = context.getStatusManager();
        if (sm4 == null) {
            this.ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        } else {
            this.print(sm4, threshold);
        }
    }

    public void print(StatusManager sm4) {
        this.print(sm4, 0L);
    }

    public void print(StatusManager sm4, long threshold) {
        StringBuilder sb5 = new StringBuilder();
        List<Status> filteredList = StatusUtil.filterStatusListByTimeThreshold(sm4.getCopyOfStatusList(), threshold);
        this.buildStrFromStatusList(sb5, filteredList);
        this.ps.println(sb5.toString());
    }

    public void print(List<Status> statusList) {
        StringBuilder sb5 = new StringBuilder();
        this.buildStrFromStatusList(sb5, statusList);
        this.ps.println(sb5.toString());
    }

    private void buildStrFromStatusList(StringBuilder sb5, List<Status> statusList) {
        if (statusList == null) {
            return;
        }
        for (Status s15 : statusList) {
            this.buildStr(sb5, "", s15);
        }
    }

    private void appendThrowable(StringBuilder sb5, Throwable t15) {
        String[] stringRep;
        for (String s15 : stringRep = ThrowableToStringArray.convert(t15)) {
            if (!s15.startsWith("Caused by: ")) {
                if (Character.isDigit(s15.charAt(0))) {
                    sb5.append("\t... ");
                } else {
                    sb5.append("\tat ");
                }
            }
            sb5.append(s15).append(CoreConstants.LINE_SEPARATOR);
        }
    }

    public void buildStr(StringBuilder sb5, String indentation, Status s15) {
        String prefix = s15.hasChildren() ? indentation + "+ " : indentation + "|-";
        if (cachingDateFormat != null) {
            String dateStr = cachingDateFormat.format(s15.getTimestamp());
            sb5.append(dateStr).append(" ");
        }
        sb5.append(prefix).append(s15).append(CoreConstants.LINE_SEPARATOR);
        if (s15.getThrowable() != null) {
            this.appendThrowable(sb5, s15.getThrowable());
        }
        if (s15.hasChildren()) {
            Iterator<Status> ite = s15.iterator();
            while (ite.hasNext()) {
                Status child = ite.next();
                this.buildStr(sb5, indentation + "  ", child);
            }
        }
    }
}

