/*
 * Decompiled with CFR 0.152.
 */
package antlr;

import antlr.ActionElement;
import antlr.ActionTransInfo;
import antlr.Alternative;
import antlr.AlternativeBlock;
import antlr.AlternativeElement;
import antlr.BlockEndElement;
import antlr.CharLiteralElement;
import antlr.CharRangeElement;
import antlr.CodeGenerator;
import antlr.Grammar;
import antlr.GrammarAtom;
import antlr.GrammarSymbol;
import antlr.JavaCharFormatter;
import antlr.LexerGrammar;
import antlr.Lookahead;
import antlr.MakeGrammar;
import antlr.OneOrMoreBlock;
import antlr.ParserGrammar;
import antlr.RuleBlock;
import antlr.RuleRefElement;
import antlr.RuleSymbol;
import antlr.StringLiteralElement;
import antlr.SynPredBlock;
import antlr.TokenManager;
import antlr.TokenRangeElement;
import antlr.TokenRefElement;
import antlr.Tool;
import antlr.TreeElement;
import antlr.TreeWalkerGrammar;
import antlr.WildcardElement;
import antlr.ZeroOrMoreBlock;
import antlr.collections.impl.Vector;
import java.io.IOException;
import java.util.Enumeration;

public class HTMLCodeGenerator
extends CodeGenerator {
    protected int syntacticPredLevel = 0;
    protected boolean doingLexRules = false;
    protected boolean firstElementInAlt;
    protected AlternativeElement prevAltElem = null;

    public HTMLCodeGenerator() {
        this.charFormatter = new JavaCharFormatter();
    }

    static String HTMLEncode(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n15 = string.length();
        for (int i15 = 0; i15 < n15; ++i15) {
            char c15 = string.charAt(i15);
            if (c15 == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c15 == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c15 == '\'') {
                stringBuffer.append("&#039;");
                continue;
            }
            if (c15 == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c15 == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            stringBuffer.append(c15);
        }
        return stringBuffer.toString();
    }

    public void gen() {
        try {
            Enumeration enumeration = this.behavior.grammars.elements();
            while (enumeration.hasMoreElements()) {
                Grammar grammar = (Grammar)enumeration.nextElement();
                grammar.setCodeGenerator(this);
                grammar.generate();
                if (!this.antlrTool.hasError()) continue;
                this.antlrTool.fatalError("Exiting due to errors.");
            }
        }
        catch (IOException iOException) {
            this.antlrTool.reportException(iOException, null);
        }
    }

    public void gen(ActionElement actionElement) {
    }

    public void gen(AlternativeBlock alternativeBlock) {
        this.genGenericBlock(alternativeBlock, "");
    }

    public void gen(BlockEndElement blockEndElement) {
    }

    public void gen(CharLiteralElement charLiteralElement) {
        if (charLiteralElement.not) {
            this._print("~");
        }
        this._print(HTMLCodeGenerator.HTMLEncode(charLiteralElement.atomText) + " ");
    }

    public void gen(CharRangeElement charRangeElement) {
        this.print(charRangeElement.beginText + ".." + charRangeElement.endText + " ");
    }

    public void gen(LexerGrammar lexerGrammar) throws IOException {
        this.setGrammar(lexerGrammar);
        this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + ".html");
        this.currentOutput = this.antlrTool.openOutputFile(this.grammar.getClassName() + ".html");
        this.tabs = 0;
        this.doingLexRules = true;
        this.genHeader();
        this.println("");
        if (this.grammar.comment != null) {
            this._println(HTMLCodeGenerator.HTMLEncode(this.grammar.comment));
        }
        this.println("Definition of lexer " + this.grammar.getClassName() + ", which is a subclass of " + this.grammar.getSuperClass() + ".");
        this.genNextToken();
        Enumeration enumeration = this.grammar.rules.elements();
        while (enumeration.hasMoreElements()) {
            RuleSymbol ruleSymbol = (RuleSymbol)enumeration.nextElement();
            if (ruleSymbol.id.equals("mnextToken")) continue;
            this.genRule(ruleSymbol);
        }
        this.currentOutput.close();
        this.currentOutput = null;
        this.doingLexRules = false;
    }

    public void gen(OneOrMoreBlock oneOrMoreBlock) {
        this.genGenericBlock(oneOrMoreBlock, "+");
    }

    public void gen(ParserGrammar parserGrammar) throws IOException {
        this.setGrammar(parserGrammar);
        this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + ".html");
        this.currentOutput = this.antlrTool.openOutputFile(this.grammar.getClassName() + ".html");
        this.tabs = 0;
        this.genHeader();
        this.println("");
        if (this.grammar.comment != null) {
            this._println(HTMLCodeGenerator.HTMLEncode(this.grammar.comment));
        }
        this.println("Definition of parser " + this.grammar.getClassName() + ", which is a subclass of " + this.grammar.getSuperClass() + ".");
        Enumeration enumeration = this.grammar.rules.elements();
        while (enumeration.hasMoreElements()) {
            this.println("");
            GrammarSymbol grammarSymbol = (GrammarSymbol)enumeration.nextElement();
            if (!(grammarSymbol instanceof RuleSymbol)) continue;
            this.genRule((RuleSymbol)grammarSymbol);
        }
        --this.tabs;
        this.println("");
        this.genTail();
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(RuleRefElement ruleRefElement) {
        RuleSymbol ruleSymbol = (RuleSymbol)this.grammar.getSymbol(ruleRefElement.targetRule);
        this._print("<a href=\"" + this.grammar.getClassName() + ".html#" + ruleRefElement.targetRule + "\">");
        this._print(ruleRefElement.targetRule);
        this._print("</a>");
        this._print(" ");
    }

    public void gen(StringLiteralElement stringLiteralElement) {
        if (stringLiteralElement.not) {
            this._print("~");
        }
        this._print(HTMLCodeGenerator.HTMLEncode(stringLiteralElement.atomText));
        this._print(" ");
    }

    public void gen(TokenRangeElement tokenRangeElement) {
        this.print(tokenRangeElement.beginText + ".." + tokenRangeElement.endText + " ");
    }

    public void gen(TokenRefElement tokenRefElement) {
        if (tokenRefElement.not) {
            this._print("~");
        }
        this._print(tokenRefElement.atomText);
        this._print(" ");
    }

    public void gen(TreeElement treeElement) {
        this.print(treeElement + " ");
    }

    public void gen(TreeWalkerGrammar treeWalkerGrammar) throws IOException {
        this.setGrammar(treeWalkerGrammar);
        this.antlrTool.reportProgress("Generating " + this.grammar.getClassName() + ".html");
        this.currentOutput = this.antlrTool.openOutputFile(this.grammar.getClassName() + ".html");
        this.tabs = 0;
        this.genHeader();
        this.println("");
        this.println("");
        if (this.grammar.comment != null) {
            this._println(HTMLCodeGenerator.HTMLEncode(this.grammar.comment));
        }
        this.println("Definition of tree parser " + this.grammar.getClassName() + ", which is a subclass of " + this.grammar.getSuperClass() + ".");
        this.println("");
        ++this.tabs;
        Enumeration enumeration = this.grammar.rules.elements();
        while (enumeration.hasMoreElements()) {
            this.println("");
            GrammarSymbol grammarSymbol = (GrammarSymbol)enumeration.nextElement();
            if (!(grammarSymbol instanceof RuleSymbol)) continue;
            this.genRule((RuleSymbol)grammarSymbol);
        }
        --this.tabs;
        this.println("");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public void gen(WildcardElement wildcardElement) {
        this._print(". ");
    }

    public void gen(ZeroOrMoreBlock zeroOrMoreBlock) {
        this.genGenericBlock(zeroOrMoreBlock, "*");
    }

    protected void genAlt(Alternative alternative) {
        if (alternative.getTreeSpecifier() != null) {
            this._print(alternative.getTreeSpecifier().getText());
        }
        this.prevAltElem = null;
        AlternativeElement alternativeElement = alternative.head;
        while (!(alternativeElement instanceof BlockEndElement)) {
            alternativeElement.generate();
            this.firstElementInAlt = false;
            this.prevAltElem = alternativeElement;
            alternativeElement = alternativeElement.next;
        }
    }

    public void genCommonBlock(AlternativeBlock alternativeBlock) {
        for (int i15 = 0; i15 < alternativeBlock.alternatives.size(); ++i15) {
            Alternative alternative = alternativeBlock.getAlternativeAt(i15);
            AlternativeElement alternativeElement = alternative.head;
            if (i15 > 0 && alternativeBlock.alternatives.size() > 1) {
                this._println("");
                this.print("|\t");
            }
            boolean bl4 = this.firstElementInAlt;
            this.firstElementInAlt = true;
            ++this.tabs;
            this.genAlt(alternative);
            --this.tabs;
            this.firstElementInAlt = bl4;
        }
    }

    public void genFollowSetForRuleBlock(RuleBlock ruleBlock) {
        Lookahead lookahead = this.grammar.theLLkAnalyzer.FOLLOW(1, ruleBlock.endNode);
        this.printSet(this.grammar.maxk, 1, lookahead);
    }

    protected void genGenericBlock(AlternativeBlock alternativeBlock, String string) {
        if (alternativeBlock.alternatives.size() > 1) {
            if (!this.firstElementInAlt) {
                if (this.prevAltElem == null || !(this.prevAltElem instanceof AlternativeBlock) || ((AlternativeBlock)this.prevAltElem).alternatives.size() == 1) {
                    this._println("");
                    this.print("(\t");
                } else {
                    this._print("(\t");
                }
            } else {
                this._print("(\t");
            }
        } else {
            this._print("( ");
        }
        this.genCommonBlock(alternativeBlock);
        if (alternativeBlock.alternatives.size() > 1) {
            this._println("");
            this.print(")" + string + " ");
            if (!(alternativeBlock.next instanceof BlockEndElement)) {
                this._println("");
                this.print("");
            }
        } else {
            this._print(")" + string + " ");
        }
    }

    protected void genHeader() {
        this.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        this.println("<HTML>");
        this.println("<HEAD>");
        this.println("<TITLE>Grammar " + this.antlrTool.grammarFile + "</TITLE>");
        this.println("</HEAD>");
        this.println("<BODY>");
        this.println("<table summary=\"\" border=\"1\" cellpadding=\"5\">");
        this.println("<tr>");
        this.println("<td>");
        this.println("<font size=\"+2\">Grammar " + this.grammar.getClassName() + "</font><br>");
        this.println("<a href=\"http://www.ANTLR.org\">ANTLR</a>-generated HTML file from " + this.antlrTool.grammarFile);
        this.println("<p>");
        this.println("Terence Parr, <a href=\"http://www.magelang.com\">MageLang Institute</a>");
        this.println("<br>ANTLR Version " + Tool.version + "; 1989-2005");
        this.println("</td>");
        this.println("</tr>");
        this.println("</table>");
        this.println("<PRE>");
    }

    protected void genLookaheadSetForAlt(Alternative alternative) {
        if (this.doingLexRules && alternative.cache[1].containsEpsilon()) {
            this.println("MATCHES ALL");
            return;
        }
        int n15 = alternative.lookaheadDepth;
        if (n15 == Integer.MAX_VALUE) {
            n15 = this.grammar.maxk;
        }
        for (int i15 = 1; i15 <= n15; ++i15) {
            Lookahead lookahead = alternative.cache[i15];
            this.printSet(n15, i15, lookahead);
        }
    }

    public void genLookaheadSetForBlock(AlternativeBlock alternativeBlock) {
        Object object;
        int n15;
        int n16 = 0;
        for (n15 = 0; n15 < alternativeBlock.alternatives.size(); ++n15) {
            object = alternativeBlock.getAlternativeAt(n15);
            if (((Alternative)object).lookaheadDepth == Integer.MAX_VALUE) {
                n16 = this.grammar.maxk;
                break;
            }
            if (n16 >= ((Alternative)object).lookaheadDepth) continue;
            n16 = ((Alternative)object).lookaheadDepth;
        }
        for (n15 = 1; n15 <= n16; ++n15) {
            object = this.grammar.theLLkAnalyzer.look(n15, alternativeBlock);
            this.printSet(n16, n15, (Lookahead)object);
        }
    }

    public void genNextToken() {
        this.println("");
        this.println("/** Lexer nextToken rule:");
        this.println(" *  The lexer nextToken rule is synthesized from all of the user-defined");
        this.println(" *  lexer rules.  It logically consists of one big alternative block with");
        this.println(" *  each user-defined rule being an alternative.");
        this.println(" */");
        RuleBlock ruleBlock = MakeGrammar.createNextTokenRule(this.grammar, this.grammar.rules, "nextToken");
        RuleSymbol ruleSymbol = new RuleSymbol("mnextToken");
        ruleSymbol.setDefined();
        ruleSymbol.setBlock(ruleBlock);
        ruleSymbol.access = "private";
        this.grammar.define(ruleSymbol);
        this.genCommonBlock(ruleBlock);
    }

    public void genRule(RuleSymbol ruleSymbol) {
        if (ruleSymbol == null || !ruleSymbol.isDefined()) {
            return;
        }
        this.println("");
        if (ruleSymbol.comment != null) {
            this._println(HTMLCodeGenerator.HTMLEncode(ruleSymbol.comment));
        }
        if (ruleSymbol.access.length() != 0 && !ruleSymbol.access.equals("public")) {
            this._print(ruleSymbol.access + " ");
        }
        this._print("<a name=\"" + ruleSymbol.getId() + "\">");
        this._print(ruleSymbol.getId());
        this._print("</a>");
        RuleBlock ruleBlock = ruleSymbol.getBlock();
        this._println("");
        ++this.tabs;
        this.print(":\t");
        this.genCommonBlock(ruleBlock);
        this._println("");
        this.println(";");
        --this.tabs;
    }

    protected void genSynPred(SynPredBlock synPredBlock) {
        ++this.syntacticPredLevel;
        this.genGenericBlock(synPredBlock, " =>");
        --this.syntacticPredLevel;
    }

    public void genTail() {
        this.println("</PRE>");
        this.println("</BODY>");
        this.println("</HTML>");
    }

    protected void genTokenTypes(TokenManager tokenManager) throws IOException {
        this.antlrTool.reportProgress("Generating " + tokenManager.getName() + TokenTypesFileSuffix + TokenTypesFileExt);
        this.currentOutput = this.antlrTool.openOutputFile(tokenManager.getName() + TokenTypesFileSuffix + TokenTypesFileExt);
        this.tabs = 0;
        this.genHeader();
        this.println("");
        this.println("*** Tokens used by the parser");
        this.println("This is a list of the token numeric values and the corresponding");
        this.println("token identifiers.  Some tokens are literals, and because of that");
        this.println("they have no identifiers.  Literals are double-quoted.");
        ++this.tabs;
        Vector vector = tokenManager.getVocabulary();
        for (int i15 = 4; i15 < vector.size(); ++i15) {
            String string = (String)vector.elementAt(i15);
            if (string == null) continue;
            this.println(string + " = " + i15);
        }
        --this.tabs;
        this.println("*** End of tokens used by the parser");
        this.currentOutput.close();
        this.currentOutput = null;
    }

    public String getASTCreateString(Vector vector) {
        return null;
    }

    public String getASTCreateString(GrammarAtom grammarAtom, String string) {
        return null;
    }

    public String mapTreeId(String string, ActionTransInfo actionTransInfo) {
        return string;
    }

    protected String processActionForSpecialSymbols(String string, int n15, RuleBlock ruleBlock, ActionTransInfo actionTransInfo) {
        return string;
    }

    public void printSet(int n15, int n16, Lookahead lookahead) {
        int n17 = 5;
        int[] nArray = lookahead.fset.toArray();
        if (n15 != 1) {
            this.print("k==" + n16 + ": {");
        } else {
            this.print("{ ");
        }
        if (nArray.length > n17) {
            this._println("");
            ++this.tabs;
            this.print("");
        }
        int n18 = 0;
        for (int i15 = 0; i15 < nArray.length; ++i15) {
            if (++n18 > n17) {
                this._println("");
                this.print("");
                n18 = 0;
            }
            if (this.doingLexRules) {
                this._print(this.charFormatter.literalChar(nArray[i15]));
            } else {
                this._print((String)this.grammar.tokenManager.getVocabulary().elementAt(nArray[i15]));
            }
            if (i15 == nArray.length - 1) continue;
            this._print(", ");
        }
        if (nArray.length > n17) {
            this._println("");
            --this.tabs;
            this.print("");
        }
        this._println(" }");
    }
}

