/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import org.gradle.api.internal.artifacts.ivyservice.modulecache.MissingModuleCacheEntry;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCacheEntry;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

class ModuleMetadataCacheEntrySerializer
extends AbstractSerializer<ModuleMetadataCacheEntry> {
    ModuleMetadataCacheEntrySerializer() {
    }

    public void write(Encoder encoder, ModuleMetadataCacheEntry value) throws Exception {
        encoder.writeByte(value.type);
        switch (value.type) {
            case 0: {
                encoder.writeLong(value.createTimestamp);
                break;
            }
            case 1: {
                encoder.writeBoolean(value.isChanging);
                encoder.writeLong(value.createTimestamp);
                break;
            }
            default: {
                throw new IllegalArgumentException("Don't know how to serialize meta-data entry: " + value);
            }
        }
    }

    public ModuleMetadataCacheEntry read(Decoder decoder) throws Exception {
        byte type = decoder.readByte();
        switch (type) {
            case 0: {
                long createTimestamp = decoder.readLong();
                return new MissingModuleCacheEntry(createTimestamp);
            }
            case 1: {
                boolean isChanging = decoder.readBoolean();
                long createTimestamp = decoder.readLong();
                return new ModuleMetadataCacheEntry(1, isChanging, createTimestamp);
            }
        }
        throw new IllegalArgumentException("Don't know how to deserialize meta-data entry of type " + type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

