/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import java.util.Map;
import org.gradle.internal.execution.history.changes.ChangeVisitor;
import org.gradle.internal.execution.history.changes.CompareStrategy;

public class TrivialChangeDetector<S>
implements CompareStrategy.ChangeDetector<S> {
    private final ItemComparator<S> itemComparator;
    private final CompareStrategy.ChangeFactory<S> changeFactory;
    private final CompareStrategy.ChangeDetector<S> delegate;

    public TrivialChangeDetector(ItemComparator<S> itemComparator, CompareStrategy.ChangeFactory<S> changeFactory, CompareStrategy.ChangeDetector<S> delegate) {
        this.itemComparator = itemComparator;
        this.changeFactory = changeFactory;
        this.delegate = delegate;
    }

    @Override
    public boolean visitChangesSince(Map<String, S> previous, Map<String, S> current, String propertyTitle, ChangeVisitor visitor) {
        switch (current.size()) {
            case 0: {
                if (previous.isEmpty()) {
                    return true;
                }
                for (Map.Entry<String, S> entry : previous.entrySet()) {
                    if (visitor.visitChange(this.changeFactory.removed(entry.getKey(), propertyTitle, entry.getValue()))) continue;
                    return false;
                }
                return true;
            }
            case 1: {
                switch (previous.size()) {
                    case 0: {
                        return this.reportAllAdded(visitor, current, propertyTitle);
                    }
                    case 1: {
                        Map.Entry<String, S> previousEntry = previous.entrySet().iterator().next();
                        Map.Entry<String, S> currentEntry = current.entrySet().iterator().next();
                        return this.compareTrivialEntries(visitor, previousEntry, currentEntry, propertyTitle);
                    }
                }
                return this.delegate.visitChangesSince(previous, current, propertyTitle, visitor);
            }
        }
        if (!previous.isEmpty()) {
            return this.delegate.visitChangesSince(previous, current, propertyTitle, visitor);
        }
        return this.reportAllAdded(visitor, current, propertyTitle);
    }

    private boolean reportAllAdded(ChangeVisitor visitor, Map<String, S> current, String propertyTitle) {
        for (Map.Entry<String, S> entry : current.entrySet()) {
            if (visitor.visitChange(this.changeFactory.added(entry.getKey(), propertyTitle, entry.getValue()))) continue;
            return false;
        }
        return true;
    }

    private boolean compareTrivialEntries(ChangeVisitor visitor, Map.Entry<String, S> previousEntry, Map.Entry<String, S> currentEntry, String propertyTitle) {
        S current;
        S previous = previousEntry.getValue();
        if (this.itemComparator.hasSamePath(previous, current = currentEntry.getValue())) {
            if (this.itemComparator.hasSameContent(previous, current)) {
                return true;
            }
            String path = currentEntry.getKey();
            return visitor.visitChange(this.changeFactory.modified(path, propertyTitle, previous, current));
        }
        if (visitor.visitChange(this.changeFactory.removed(previousEntry.getKey(), propertyTitle, previous))) {
            return visitor.visitChange(this.changeFactory.added(currentEntry.getKey(), propertyTitle, current));
        }
        return false;
    }

    public static interface ItemComparator<S> {
        public boolean hasSamePath(S var1, S var2);

        public boolean hasSameContent(S var1, S var2);
    }
}

