/*
 * Decompiled with CFR 0.152.
 */
package ghidra.docking.settings;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;

public class FormatSettingsDefinition
implements EnumSettingsDefinition {
    public static final int HEX = 0;
    public static final int DECIMAL = 1;
    public static final int BINARY = 2;
    public static final int OCTAL = 3;
    public static final int CHAR = 4;
    private static final String[] choices = new String[]{"hex", "decimal", "binary", "octal", "char"};
    private static final String[] valuePostfix = new String[]{"h", "", "b", "o", ""};
    private static final int[] radix = new int[]{16, 10, 2, 8, 0};
    protected static final String FORMAT = "format";
    public static final FormatSettingsDefinition DEF_HEX = new FormatSettingsDefinition(0);
    public static final FormatSettingsDefinition DEF_DECIMAL = new FormatSettingsDefinition(1);
    public static final FormatSettingsDefinition DEF_BINARY = new FormatSettingsDefinition(2);
    public static final FormatSettingsDefinition DEF_OCTAL = new FormatSettingsDefinition(3);
    public static final FormatSettingsDefinition DEF_CHAR = new FormatSettingsDefinition(4);
    public static final FormatSettingsDefinition DEF = DEF_HEX;
    private final int defaultFormat;

    private FormatSettingsDefinition(int defaultFormat) {
        this.defaultFormat = defaultFormat;
    }

    public int getFormat(Settings settings) {
        if (settings == null) {
            return this.defaultFormat;
        }
        Long value = settings.getLong(FORMAT);
        if (value == null) {
            return this.defaultFormat;
        }
        int format = (int)value.longValue();
        if (format < 0 || format > 4) {
            format = 0;
        }
        return format;
    }

    public int getRadix(Settings settings) {
        return radix[this.getFormat(settings)];
    }

    public String getRepresentationPostfix(Settings settings) {
        return valuePostfix[this.getFormat(settings)];
    }

    @Override
    public int getChoice(Settings settings) {
        return this.getFormat(settings);
    }

    @Override
    public String getValueString(Settings settings) {
        return choices[this.getChoice(settings)];
    }

    @Override
    public void setChoice(Settings settings, int value) {
        if (value < 0 || value > 4) {
            settings.clearSetting(FORMAT);
        } else {
            settings.setLong(FORMAT, value);
        }
    }

    @Override
    public String[] getDisplayChoices(Settings settings) {
        return choices;
    }

    @Override
    public String getName() {
        return "Format";
    }

    @Override
    public String getStorageKey() {
        return FORMAT;
    }

    @Override
    public String getDescription() {
        return "Selects the display format";
    }

    @Override
    public String getDisplayChoice(int value, Settings s1) {
        return choices[value];
    }

    @Override
    public void clear(Settings settings) {
        settings.clearSetting(FORMAT);
    }

    @Override
    public void copySetting(Settings settings, Settings destSettings) {
        Long l = settings.getLong(FORMAT);
        if (l == null) {
            destSettings.clearSetting(FORMAT);
        } else {
            destSettings.setLong(FORMAT, l);
        }
    }

    @Override
    public boolean hasValue(Settings setting) {
        return setting.getValue(FORMAT) != null;
    }

    public String getDisplayChoice(Settings settings) {
        return choices[this.getChoice(settings)];
    }

    public void setDisplayChoice(Settings settings, String choice) {
        for (int i = 0; i < choices.length; ++i) {
            if (!choices[i].equals(choice)) continue;
            this.setChoice(settings, i);
            break;
        }
    }
}

