/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BinaryDataBuffer;
import db.BinaryField;
import db.IllegalFieldAccessException;
import ghidra.util.exception.AssertException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class BinaryCodedField
extends BinaryField {
    public static final byte BYTE_ARRAY = 0;
    public static final byte FLOAT = 1;
    public static final byte DOUBLE = 2;
    public static final byte SHORT_ARRAY = 3;
    public static final byte INT_ARRAY = 4;
    public static final byte LONG_ARRAY = 5;
    public static final byte FLOAT_ARRAY = 6;
    public static final byte DOUBLE_ARRAY = 7;
    public static final byte STRING_ARRAY = 8;
    private static final int DATA_TYPE_OFFSET = 0;
    private static final int DATA_OFFSET = 1;
    private static final String STRING_ENCODING = "UTF-8";

    BinaryCodedField() {
    }

    public BinaryCodedField(BinaryField binField) {
        this.data = binField.getBinaryData();
    }

    public BinaryCodedField(double value) {
        BinaryDataBuffer buffer = new BinaryDataBuffer(9);
        buffer.putByte(0, (byte)2);
        buffer.putLong(1, Double.doubleToLongBits(value));
        this.data = buffer.getData();
    }

    public BinaryCodedField(float value) {
        BinaryDataBuffer buffer = new BinaryDataBuffer(5);
        buffer.putByte(0, (byte)1);
        buffer.putInt(1, Float.floatToIntBits(value));
        this.data = buffer.getData();
    }

    public BinaryCodedField(byte[] values) {
        if (values != null) {
            this.data = new byte[values.length + 2];
            this.data[1] = 0;
            System.arraycopy(values, 0, this.data, 2, values.length);
        } else {
            this.data = new byte[2];
            this.data[1] = -1;
        }
        this.data[0] = 0;
    }

    public BinaryCodedField(short[] values) {
        int len = (values != null ? 2 * values.length : 0) + 2;
        BinaryDataBuffer buffer = new BinaryDataBuffer(len);
        buffer.putByte(0, (byte)3);
        if (values != null) {
            int offset = 1;
            buffer.putByte(offset++, (byte)0);
            for (int i = 0; i < values.length; ++i) {
                offset = buffer.putShort(offset, values[i]);
            }
        } else {
            buffer.putByte(1, (byte)-1);
        }
        this.data = buffer.getData();
    }

    public BinaryCodedField(int[] values) {
        int len = (values != null ? 4 * values.length : 0) + 2;
        BinaryDataBuffer buffer = new BinaryDataBuffer(len);
        buffer.putByte(0, (byte)4);
        if (values != null) {
            int offset = 1;
            buffer.putByte(offset++, (byte)0);
            for (int i = 0; i < values.length; ++i) {
                offset = buffer.putInt(offset, values[i]);
            }
        } else {
            buffer.putByte(1, (byte)-1);
        }
        this.data = buffer.getData();
    }

    public BinaryCodedField(long[] values) {
        int len = (values != null ? 8 * values.length : 0) + 2;
        BinaryDataBuffer buffer = new BinaryDataBuffer(len);
        buffer.putByte(0, (byte)5);
        if (values != null) {
            int offset = 1;
            buffer.putByte(offset++, (byte)0);
            for (int i = 0; i < values.length; ++i) {
                offset = buffer.putLong(offset, values[i]);
            }
        } else {
            buffer.putByte(1, (byte)-1);
        }
        this.data = buffer.getData();
    }

    public BinaryCodedField(float[] values) {
        int len = (values != null ? 4 * values.length : 0) + 2;
        BinaryDataBuffer buffer = new BinaryDataBuffer(len);
        buffer.putByte(0, (byte)6);
        if (values != null) {
            int offset = 1;
            buffer.putByte(offset++, (byte)0);
            for (int i = 0; i < values.length; ++i) {
                offset = buffer.putInt(offset, Float.floatToIntBits(values[i]));
            }
        } else {
            buffer.putByte(1, (byte)-1);
        }
        this.data = buffer.getData();
    }

    public BinaryCodedField(double[] values) {
        int len = (values != null ? 8 * values.length : 0) + 2;
        BinaryDataBuffer buffer = new BinaryDataBuffer(len);
        buffer.putByte(0, (byte)7);
        if (values != null) {
            int offset = 1;
            buffer.putByte(offset++, (byte)0);
            for (int i = 0; i < values.length; ++i) {
                offset = buffer.putLong(offset, Double.doubleToLongBits(values[i]));
            }
        } else {
            buffer.putByte(1, (byte)-1);
        }
        this.data = buffer.getData();
    }

    public BinaryCodedField(String[] strings) {
        BinaryDataBuffer buffer = null;
        if (strings != null) {
            int len = 2;
            for (int i = 0; i < strings.length; ++i) {
                len += 4;
                if (strings[i] == null) continue;
                len += strings[i].length();
            }
            buffer = new BinaryDataBuffer(len);
            int offset = 1;
            buffer.putByte(offset++, (byte)0);
            try {
                for (int i = 0; i < strings.length; ++i) {
                    if (strings[i] == null) {
                        offset = buffer.putInt(offset, -1);
                        continue;
                    }
                    byte[] bytes = strings[i].getBytes(STRING_ENCODING);
                    offset = buffer.putInt(offset, bytes.length);
                    offset = buffer.put(offset, bytes);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertException();
            }
        } else {
            buffer = new BinaryDataBuffer(2);
            buffer.putByte(1, (byte)-1);
        }
        buffer.putByte(0, (byte)8);
        this.data = buffer.getData();
    }

    public byte getDataType() {
        return this.data[0];
    }

    public double getDoubleValue() {
        if (2 != this.data[0]) {
            throw new IllegalFieldAccessException();
        }
        BinaryDataBuffer buffer = new BinaryDataBuffer(this.data);
        return Double.longBitsToDouble(buffer.getLong(1));
    }

    public float getFloatValue() {
        if (1 != this.data[0]) {
            throw new IllegalFieldAccessException();
        }
        BinaryDataBuffer buffer = new BinaryDataBuffer(this.data);
        return Float.intBitsToFloat(buffer.getInt(1));
    }

    public byte[] getByteArray() {
        if (0 != this.data[0]) {
            throw new IllegalFieldAccessException();
        }
        if (this.data[1] < 0) {
            return null;
        }
        byte[] values = new byte[this.data.length - 2];
        System.arraycopy(this.data, 2, values, 0, values.length);
        return values;
    }

    public short[] getShortArray() {
        if (3 != this.data[0]) {
            throw new IllegalFieldAccessException();
        }
        if (this.data[1] < 0) {
            return null;
        }
        short[] values = new short[(this.data.length - 2) / 2];
        BinaryDataBuffer buffer = new BinaryDataBuffer(this.data);
        int offset = 2;
        for (int i = 0; i < values.length; ++i) {
            values[i] = buffer.getShort(offset);
            offset += 2;
        }
        return values;
    }

    public int[] getIntArray() {
        if (4 != this.data[0]) {
            throw new IllegalFieldAccessException();
        }
        if (this.data[1] < 0) {
            return null;
        }
        int[] values = new int[(this.data.length - 2) / 4];
        BinaryDataBuffer buffer = new BinaryDataBuffer(this.data);
        int offset = 2;
        for (int i = 0; i < values.length; ++i) {
            values[i] = buffer.getInt(offset);
            offset += 4;
        }
        return values;
    }

    public long[] getLongArray() {
        if (5 != this.data[0]) {
            throw new IllegalFieldAccessException();
        }
        if (this.data[1] < 0) {
            return null;
        }
        long[] values = new long[(this.data.length - 2) / 8];
        BinaryDataBuffer buffer = new BinaryDataBuffer(this.data);
        int offset = 2;
        for (int i = 0; i < values.length; ++i) {
            values[i] = buffer.getLong(offset);
            offset += 8;
        }
        return values;
    }

    public float[] getFloatArray() {
        if (6 != this.data[0]) {
            throw new IllegalFieldAccessException();
        }
        if (this.data[1] < 0) {
            return null;
        }
        float[] values = new float[(this.data.length - 2) / 4];
        BinaryDataBuffer buffer = new BinaryDataBuffer(this.data);
        int offset = 2;
        for (int i = 0; i < values.length; ++i) {
            values[i] = Float.intBitsToFloat(buffer.getInt(offset));
            offset += 4;
        }
        return values;
    }

    public double[] getDoubleArray() {
        if (7 != this.data[0]) {
            throw new IllegalFieldAccessException();
        }
        if (this.data[1] < 0) {
            return null;
        }
        double[] values = new double[(this.data.length - 2) / 8];
        BinaryDataBuffer buffer = new BinaryDataBuffer(this.data);
        int offset = 2;
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.longBitsToDouble(buffer.getLong(offset));
            offset += 8;
        }
        return values;
    }

    public String[] getStringArray() {
        if (8 != this.data[0]) {
            throw new IllegalFieldAccessException();
        }
        if (this.data[1] < 0) {
            return null;
        }
        ArrayList<String> strList = new ArrayList<String>();
        BinaryDataBuffer buffer = new BinaryDataBuffer(this.data);
        try {
            int offset = 2;
            while (offset < this.data.length) {
                int len = buffer.getInt(offset);
                offset += 4;
                if (len >= 0) {
                    byte[] bytes = buffer.get(offset, len);
                    strList.add(new String(bytes, STRING_ENCODING));
                    offset += len;
                    continue;
                }
                strList.add(null);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertException();
        }
        String[] strings = new String[strList.size()];
        strList.toArray(strings);
        return strings;
    }
}

