/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.mdmp.MemoryRange64;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Memory64ListStream
implements StructConverter {
    public static final String NAME = "MINIDUMP_MEMORY_RANGE_64_LIST";
    private int numberOfMemoryRanges;
    private long baseRVA;
    private MemoryRange64[] memoryRanges;
    private DumpFileReader reader;
    private long index;

    Memory64ListStream(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setNumberOfMemoryRanges((int)this.reader.readNextLong());
        this.setBaseRVA(this.reader.readNextLong());
        this.memoryRanges = new MemoryRange64[this.numberOfMemoryRanges];
        for (int i = 0; i < this.numberOfMemoryRanges; ++i) {
            this.setMemoryRange(new MemoryRange64(this.reader, this.reader.getPointerIndex()), i);
        }
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(QWORD, 8, "NumberOfMemoryRanges", null);
        struct.add(POINTER, 8, "BaseRva", null);
        DataType t = this.memoryRanges[0].toDataType();
        ArrayDataType a = new ArrayDataType(t, this.numberOfMemoryRanges, t.getLength());
        struct.add((DataType)a, a.getLength(), "MemoryRanges", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public long getNumberOfMemoryRanges() {
        return this.numberOfMemoryRanges;
    }

    public void setNumberOfMemoryRanges(int numberOfMemoryRanges) {
        this.numberOfMemoryRanges = numberOfMemoryRanges;
    }

    public void setBaseRVA(long baseRVA) {
        this.baseRVA = baseRVA;
    }

    public long getBaseRVA() {
        return this.baseRVA;
    }

    public MemoryRange64 getMemoryRange(int idx) {
        return this.memoryRanges[idx];
    }

    public void setMemoryRange(MemoryRange64 memoryRange, int index) {
        this.memoryRanges[index] = memoryRange;
    }
}

