/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.breakpoint;

import ghidra.app.plugin.core.debug.service.breakpoint.BreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.DeleteEmuBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.DeleteTargetBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.DisableEmuBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.DisableTargetBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.EnableEmuBreakpointActionItem;
import ghidra.app.plugin.core.debug.service.breakpoint.EnableTargetBreakpointActionItem;
import ghidra.async.AsyncFence;
import ghidra.debug.api.target.Target;
import ghidra.trace.model.breakpoint.TraceBreakpointLocation;
import java.util.LinkedHashSet;
import java.util.concurrent.CompletableFuture;

public class BreakpointActionSet
extends LinkedHashSet<BreakpointActionItem> {
    public EnableTargetBreakpointActionItem planEnableTarget(Target target, TraceBreakpointLocation loc) {
        EnableTargetBreakpointActionItem action = new EnableTargetBreakpointActionItem(target, loc);
        this.add(action);
        return action;
    }

    public EnableEmuBreakpointActionItem planEnableEmu(TraceBreakpointLocation loc, long snap) {
        EnableEmuBreakpointActionItem action = new EnableEmuBreakpointActionItem(loc, snap);
        this.add(action);
        return action;
    }

    public DisableTargetBreakpointActionItem planDisableTarget(Target target, TraceBreakpointLocation loc) {
        DisableTargetBreakpointActionItem action = new DisableTargetBreakpointActionItem(target, loc);
        this.add(action);
        return action;
    }

    public DisableEmuBreakpointActionItem planDisableEmu(TraceBreakpointLocation loc, long snap) {
        DisableEmuBreakpointActionItem action = new DisableEmuBreakpointActionItem(loc, snap);
        this.add(action);
        return action;
    }

    public DeleteTargetBreakpointActionItem planDeleteTarget(Target target, TraceBreakpointLocation loc) {
        DeleteTargetBreakpointActionItem action = new DeleteTargetBreakpointActionItem(target, loc);
        this.add(action);
        return action;
    }

    public DeleteEmuBreakpointActionItem planDeleteEmu(TraceBreakpointLocation loc, long snap) {
        DeleteEmuBreakpointActionItem action = new DeleteEmuBreakpointActionItem(loc, snap);
        this.add(action);
        return action;
    }

    public CompletableFuture<Void> execute() {
        AsyncFence fence = new AsyncFence();
        for (BreakpointActionItem item : this) {
            fence.include(item.execute());
        }
        return fence.ready();
    }
}

