/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.timeoverview.timetype;

import docking.widgets.label.GLabel;
import ghidra.app.plugin.core.debug.gui.timeoverview.timetype.TimeType;
import ghidra.app.plugin.core.debug.gui.timeoverview.timetype.TimeTypeOverviewColorService;
import ghidra.util.layout.PairLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JPanel;

public class TimeTypeOverviewLegendPanel
extends JPanel {
    private static Dimension COLOR_SIZE = new Dimension(15, 15);
    private TimeTypeOverviewColorService colorService;

    public TimeTypeOverviewLegendPanel(TimeTypeOverviewColorService colorService) {
        this.colorService = colorService;
        this.setLayout((LayoutManager)new PairLayout(4, 10));
        this.setBorder(BorderFactory.createEmptyBorder(4, 20, 4, 30));
        this.buildLegend();
    }

    public void updateColors() {
        this.repaint();
    }

    private void buildLegend() {
        TimeType[] values;
        this.removeAll();
        for (TimeType timeType : values = TimeType.values()) {
            ColorPanel panel = new ColorPanel(timeType);
            this.add(panel);
            this.add((Component)new GLabel(timeType.getDescription()));
        }
    }

    private class ColorPanel
    extends JPanel {
        private TimeType type;

        ColorPanel(final TimeType type) {
            this.type = type;
            this.setPreferredSize(COLOR_SIZE);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Color newColor = JColorChooser.showDialog(ColorPanel.this, "Select Color", ColorPanel.this.getBackground());
                    TimeTypeOverviewLegendPanel.this.colorService.setColor(type, newColor);
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g) {
            this.setBackground(TimeTypeOverviewLegendPanel.this.colorService.getColor(this.type));
            super.paintComponent(g);
        }
    }
}

