/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import ghidra.app.plugin.core.format.ByteBlock;
import java.math.BigInteger;

public class ByteBlockRange {
    private ByteBlock block;
    private BigInteger startIndex;
    private BigInteger endIndex;

    public ByteBlockRange(ByteBlock block, BigInteger startIndex, BigInteger endIndex) {
        this.block = block;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    public ByteBlock getByteBlock() {
        return this.block;
    }

    public BigInteger getStartIndex() {
        return this.startIndex;
    }

    public BigInteger getEndIndex() {
        return this.endIndex;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteBlockRange r = (ByteBlockRange)obj;
        return this.block == r.block && this.startIndex.equals(r.startIndex) && this.endIndex.equals(r.endIndex);
    }

    public int hashCode() {
        return this.block.hashCode() + this.startIndex.hashCode() + this.endIndex.hashCode();
    }

    public String toString() {
        return "Block at " + this.block.getLocationRepresentation(BigInteger.ZERO) + ", startIndex=> " + String.valueOf(this.startIndex) + ", endIndex => " + String.valueOf(this.endIndex);
    }
}

