/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.lang.ParameterPieces;
import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.StorageClass;
import ghidra.program.model.lang.protorules.AssignAction;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public class ConsumeAs
extends AssignAction {
    private StorageClass resourceType;

    public ConsumeAs(StorageClass store, ParamListStandard res) {
        super(res);
        this.resourceType = store;
    }

    @Override
    public AssignAction clone(ParamListStandard newResource) {
        return new ConsumeAs(this.resourceType, newResource);
    }

    @Override
    public boolean isEquivalent(AssignAction op) {
        if (this.getClass() != op.getClass()) {
            return false;
        }
        ConsumeAs otherAction = (ConsumeAs)op;
        return this.resourceType == otherAction.resourceType;
    }

    @Override
    public int assignAddress(DataType dt, PrototypePieces proto, int pos, DataTypeManager dtManager, int[] status, ParameterPieces res) {
        return this.resource.assignAddressFallback(this.resourceType, dt, true, status, res);
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_CONSUME);
        encoder.writeString(AttributeId.ATTRIB_STORAGE, this.resourceType.toString());
        encoder.closeElement(ElementId.ELEM_CONSUME);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_CONSUME.name()});
        this.resourceType = StorageClass.getClass(elem.getAttribute(AttributeId.ATTRIB_STORAGE.name()));
        parser.end(elem);
    }
}

