/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.util.exception.AssertException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LEB128 {
    public static final int MAX_SUPPORTED_LENGTH = 10;

    public static long unsigned(InputStream is) throws IOException {
        return LEB128.read(is, false);
    }

    public static long signed(InputStream is) throws IOException {
        return LEB128.read(is, true);
    }

    public static long read(InputStream is, boolean isSigned) throws IOException {
        int nextByte = 0;
        int shift = 0;
        long value = 0L;
        do {
            if ((nextByte = is.read()) < 0) {
                throw new EOFException();
            }
            if (shift == 70 || !isSigned && shift == 63 && nextByte > 1) {
                throw new IOException("Unsupported LEB128 value, too large to fit in 64bit java long variable");
            }
            value |= (long)(nextByte & 0x7F) << shift;
            shift += 7;
        } while ((nextByte & 0x80) != 0);
        if (isSigned && shift < 64 && (nextByte & 0x40) != 0) {
            value |= -1L << shift;
        }
        return value;
    }

    public static int getLength(InputStream is) throws IOException {
        int nextByte;
        for (int length = 0; (nextByte = is.read()) >= 0 && length < 10; ++length) {
            if ((nextByte & 0x80) != 0) continue;
            return length;
        }
        return -1;
    }

    public static long decode(byte[] bytes, int offset, boolean isSigned) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes, offset, bytes.length - offset);
        return LEB128.read(is, isSigned);
    }

    public static byte[] encode(long value, boolean isSigned) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(10);
            LEB128.write(value, baos, isSigned);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new AssertException((Throwable)e);
        }
    }

    public static int write(long value, OutputStream os, boolean isSigned) throws IOException {
        return isSigned ? LEB128.writeSigned(value, os) : LEB128.writeUnsigned(value, os);
    }

    public static int writeUnsigned(long value, OutputStream os) throws IOException {
        boolean done;
        int size = 0;
        do {
            int b = (int)(value & 0x7FL);
            boolean bl = done = (value >>>= 7) == 0L;
            if (value != 0L) {
                b |= 0x80;
            }
            os.write(b);
            ++size;
        } while (!done);
        return size;
    }

    public static int writeSigned(long value, OutputStream os) throws IOException {
        boolean more;
        long endingVal = value < 0L ? -1L : 0L;
        int hiBit = value < 0L ? 64 : 0;
        int size = 0;
        do {
            int b = (int)(value & 0x7FL);
            boolean bl = more = (value >>= 7) != endingVal || (b & 0x40) != hiBit;
            if (more) {
                b |= 0x80;
            }
            os.write(b);
            ++size;
        } while (more);
        return size;
    }
}

