/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.correlate;

import ghidra.program.model.correlate.AllBytesHashCalculator;
import ghidra.program.model.correlate.Block;
import ghidra.program.model.correlate.DisambiguateStrategy;
import ghidra.program.model.correlate.Hash;
import ghidra.program.model.correlate.HashStore;
import ghidra.program.model.correlate.InstructHash;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.CancelledException;
import java.util.ArrayList;

public class DisambiguateByBytes
implements DisambiguateStrategy {
    private AllBytesHashCalculator hashCalc = new AllBytesHashCalculator();

    @Override
    public ArrayList<Hash> calcHashes(InstructHash instHash, int matchSize, HashStore store) throws CancelledException, MemoryAccessException {
        ArrayList<Hash> res = new ArrayList<Hash>();
        Block block = instHash.getBlock();
        int val = block.hashGram(matchSize, instHash, this.hashCalc);
        res.add(new Hash(val, 1));
        return res;
    }
}

