/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DividerLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.math.BigInteger;

public class SeparatorFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Separator";
    private static final char sepChar = '.';
    StringBuffer sb = new StringBuffer();

    public SeparatorFieldFactory() {
        super(FIELD_NAME);
    }

    private SeparatorFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        if (!this.enabled) {
            return null;
        }
        int numChars = this.width / this.getMetrics().charWidth('.');
        this.sb.setLength(0);
        for (int i = 0; i < numChars; ++i) {
            this.sb.append('.');
        }
        AttributedString as = new AttributedString(this.sb.toString(), (Color)ListingColors.SEPARATOR, this.getMetrics());
        TextFieldElement text = new TextFieldElement(as, 0, 0);
        return ListingTextField.createSingleLineTextField(this, proxy, (FieldElement)text, this.startX + varWidth, this.width, this.hlProvider);
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (obj instanceof Address) {
            ListingModel layoutModel = bf.getProxy().getListingLayoutModel();
            Program program = layoutModel.getProgram();
            return new DividerLocation(program, (Address)obj, null, col);
        }
        return null;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (programLoc instanceof DividerLocation) {
            return new FieldLocation(index, fieldNum, 0, ((DividerLocation)programLoc).getCharOffset());
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        return category == 0;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new SeparatorFieldFactory(formatModel, provider, (Options)displayOptions, (Options)fieldOptions);
    }
}

