/**
 * FreeRDP: A Remote Desktop Protocol Implementation
 * FreeRDP Server Common
 *
 * Copyright 2018 Armin Novak <armin.novak@thincast.com>
 * Copyright 2018 Thincast Technologies GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef FREERDP_SERVER_COMMON_SERVER_H
#define FREERDP_SERVER_COMMON_SERVER_H

#include <winpr/wtypes.h>
#include <freerdp/api.h>
#include <freerdp/codec/audio.h>

#ifdef __cplusplus
extern "C"
{
#endif

	WINPR_ATTR_NODISCARD
	FREERDP_API size_t server_audin_get_formats(AUDIO_FORMAT** dst_formats);

	WINPR_ATTR_NODISCARD
	FREERDP_API size_t server_rdpsnd_get_formats(AUDIO_FORMAT** dst_formats);

	FREERDP_API void freerdp_server_warn_unmaintained(int argc, char* argv[]);
	FREERDP_API void freerdp_server_warn_experimental(int argc, char* argv[]);
	FREERDP_API void freerdp_server_warn_deprecated(int argc, char* argv[]);

#ifdef __cplusplus
}
#endif

#endif /* FREERDP_SERVER_COMMON_SERVER_H */
