/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.content;

import java.util.Objects;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IconDescription;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.UserIcon;
import org.freeplane.plugin.ai.tools.text.EnglishTextProvider;

public class IconDescriptionResolver {
    private static final String EMOJI_NAME_PREFIX = "emoji-";
    private final EnglishTextProvider englishTextProvider;

    public IconDescriptionResolver(EnglishTextProvider englishTextProvider) {
        this.englishTextProvider = Objects.requireNonNull(englishTextProvider, "englishTextProvider");
    }

    String resolveDescription(NamedIcon icon) {
        String file;
        if (icon == null) {
            return "";
        }
        String emoji = this.decodeEmojiFromName(icon.getName());
        if (!TextUtils.isEmpty((String)emoji)) {
            return emoji;
        }
        if (icon instanceof IconDescription && !TextUtils.isEmpty((String)(file = ((IconDescription)icon).getFile())) && icon instanceof UserIcon) {
            return file;
        }
        String englishDescription = this.resolveEnglishDescription(icon);
        if (!TextUtils.isEmpty((String)englishDescription)) {
            return englishDescription;
        }
        return this.fallbackName(icon.getName());
    }

    public boolean matchesDescription(NamedIcon icon, String description) {
        if (icon == null || TextUtils.isEmpty((String)description)) {
            return false;
        }
        String normalizedDescription = this.normalizeEmojiPresentation(description.trim());
        if (normalizedDescription.equalsIgnoreCase(icon.getName())) {
            return true;
        }
        String resolved = this.resolveDescription(icon);
        String normalizedResolved = this.normalizeEmojiPresentation(resolved);
        if (normalizedDescription.equals(normalizedResolved)) {
            return true;
        }
        return normalizedDescription.equalsIgnoreCase(normalizedResolved);
    }

    private String resolveEnglishDescription(NamedIcon icon) {
        String translationKey;
        if (icon instanceof IconDescription && !TextUtils.isEmpty((String)(translationKey = ((IconDescription)icon).getDescriptionTranslationKey()))) {
            return this.englishTextProvider.getEnglishText(translationKey);
        }
        return null;
    }

    private String fallbackName(String name) {
        if (TextUtils.isEmpty((String)name)) {
            return "";
        }
        String trimmedName = name;
        int index = name.lastIndexOf(47);
        if (index >= 0 && index + 1 < name.length()) {
            trimmedName = name.substring(index + 1);
        }
        return TextUtils.capitalize((String)trimmedName);
    }

    private String decodeEmojiFromName(String name) {
        String codePointsPart;
        if (!TextUtils.isEmpty((String)name) && name.startsWith(EMOJI_NAME_PREFIX) && !TextUtils.isEmpty((String)(codePointsPart = name.substring(EMOJI_NAME_PREFIX.length())))) {
            String[] parts = codePointsPart.split("-");
            int[] codePoints = new int[parts.length];
            for (int index = 0; index < parts.length; ++index) {
                String part = parts[index];
                if (TextUtils.isEmpty((String)part)) {
                    return null;
                }
                try {
                    codePoints[index] = Integer.parseInt(part, 16);
                    continue;
                }
                catch (NumberFormatException exception) {
                    return null;
                }
            }
            return new String(codePoints, 0, codePoints.length);
        }
        return null;
    }

    private String normalizeEmojiPresentation(String value) {
        if (TextUtils.isEmpty((String)value)) {
            return "";
        }
        return value.replace("\ufe0f", "").replace("\ufe0e", "");
    }
}

