/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.chat;

import java.awt.Color;
import java.util.Locale;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.html.ScaledStyleSheet;

public class ChatMessageStyleApplier {
    private static final float CONTEXT_BOUNDARY_FONT_RATIO = 0.8333333f;
    private static final float MESSAGE_VERTICAL_PADDING_RATIO = 0.35f;
    private static final float MESSAGE_EXTERNAL_SPACING_RATIO = 0.35f;
    private static final float MESSAGE_HORIZONTAL_PADDING_RATIO = 0.6f;
    private static final float CONTEXT_BOUNDARY_VERTICAL_PADDING_RATIO = 0.5f;
    private static final float CONTEXT_BOUNDARY_BOTTOM_MARGIN_RATIO = 0.35f;

    public void apply(JEditorPane messageHistoryPane, HTMLEditorKit messageHistoryEditorKit, float baseFontSizePt, int fontScalingPercent) {
        Color baseBackground = UIManager.getColor("TextArea.background");
        Color baseForeground = UIManager.getColor("TextArea.foreground");
        if (baseBackground == null) {
            baseBackground = Color.WHITE;
        }
        if (baseForeground == null) {
            baseForeground = Color.BLACK;
        }
        float effectiveScale = UITools.FONT_SCALE_FACTOR * (float)fontScalingPercent / 100.0f;
        boolean darkTheme = this.isDark(baseBackground);
        Color userBackground = darkTheme ? new Color(69, 69, 69) : new Color(235, 235, 235);
        Color assistantBackground = darkTheme ? new Color(43, 43, 43) : new Color(245, 245, 245);
        Color toolBackground = darkTheme ? new Color(42, 54, 70) : new Color(234, 243, 255);
        Color mcpBackground = darkTheme ? new Color(37, 51, 84) : new Color(234, 243, 255);
        Color systemBackground = darkTheme ? new Color(31, 31, 31) : new Color(240, 240, 240);
        Color profileBackground = darkTheme ? new Color(28, 44, 36) : new Color(232, 246, 236);
        Color errorBackground = darkTheme ? new Color(61, 31, 31) : new Color(255, 235, 235);
        Color userBorderColor = darkTheme ? new Color(106, 106, 106) : new Color(62, 62, 62);
        Color borderColor = darkTheme ? new Color(82, 82, 82) : new Color(215, 215, 215);
        Color toolBorderColor = darkTheme ? new Color(90, 111, 138) : new Color(188, 217, 255);
        Color mcpBorderColor = darkTheme ? new Color(106, 127, 176) : new Color(92, 121, 189);
        Color systemBorderColor = darkTheme ? new Color(58, 58, 58) : new Color(176, 176, 176);
        Color profileBorderColor = darkTheme ? new Color(63, 112, 88) : new Color(77, 154, 114);
        Color errorBorderColor = darkTheme ? new Color(211, 90, 90) : new Color(198, 47, 47);
        messageHistoryPane.setBackground(baseBackground);
        StyleSheet baseStyleSheet = messageHistoryEditorKit.getStyleSheet();
        ScaledStyleSheet styleSheet = new ScaledStyleSheet(effectiveScale);
        styleSheet.addStyleSheet(baseStyleSheet);
        HTMLDocument document = new HTMLDocument((StyleSheet)styleSheet);
        messageHistoryPane.setDocument(document);
        float contextBoundaryFontSizePt = baseFontSizePt * 0.8333333f;
        float effectiveBaseFontSizePt = baseFontSizePt * effectiveScale;
        String messageBoxSpacing = this.messageBoxSpacingCss(effectiveBaseFontSizePt);
        String contextBoundarySpacing = this.contextBoundarySpacingCss(effectiveBaseFontSizePt);
        styleSheet.addRule("body { font-family: Sans-Serif; font-size: " + this.formatPt(baseFontSizePt) + "; margin: 6px; color: " + this.toCssColor(baseForeground) + "; background-color: " + this.toCssColor(baseBackground) + "; }");
        styleSheet.addRule(".message-user { " + messageBoxSpacing + "; background-color: " + this.toCssColor(userBackground) + "; border-left: 4px solid " + this.toCssColor(userBorderColor) + "; }");
        styleSheet.addRule(".message-assistant { " + messageBoxSpacing + "; background-color: " + this.toCssColor(assistantBackground) + "; border-left: 4px solid " + this.toCssColor(borderColor) + "; }");
        styleSheet.addRule(".message-tool { " + messageBoxSpacing + "; background-color: " + this.toCssColor(toolBackground) + "; border-left: 4px solid " + this.toCssColor(toolBorderColor) + "; }");
        styleSheet.addRule(".message-mcp-call { " + messageBoxSpacing + "; background-color: " + this.toCssColor(mcpBackground) + "; border-left: 8px solid " + this.toCssColor(mcpBorderColor) + "; }");
        styleSheet.addRule(".message-system { " + messageBoxSpacing + "; background-color: " + this.toCssColor(systemBackground) + "; border-left: 4px solid " + this.toCssColor(systemBorderColor) + "; }");
        styleSheet.addRule(".message-profile { " + messageBoxSpacing + "; background-color: " + this.toCssColor(profileBackground) + "; border-left: 4px solid " + this.toCssColor(profileBorderColor) + "; }");
        styleSheet.addRule(".message-error { " + messageBoxSpacing + "; background-color: " + this.toCssColor(errorBackground) + "; border-left: 4px solid " + this.toCssColor(errorBorderColor) + "; }");
        styleSheet.addRule(".message-context-boundary { " + contextBoundarySpacing + "; border-top: 2px dashed " + this.toCssColor(systemBorderColor) + "; color: " + this.toCssColor(systemBorderColor) + "; font-size: " + this.formatPt(contextBoundaryFontSizePt) + "; }");
    }

    private boolean isDark(Color color) {
        double luminance = 0.2126 * (double)color.getRed() + 0.7152 * (double)color.getGreen() + 0.0722 * (double)color.getBlue();
        return luminance < 128.0;
    }

    private String toCssColor(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    private String formatPt(float value) {
        if (Math.rint(value) == (double)value) {
            return String.format(Locale.ROOT, "%.0fpt", Float.valueOf(value));
        }
        return String.format(Locale.ROOT, "%.2fpt", Float.valueOf(value));
    }

    String messageBoxSpacingCss(float baseFontSizePt) {
        float verticalPaddingPt = baseFontSizePt * 0.35f;
        float externalSpacingPt = baseFontSizePt * 0.35f;
        float horizontalPaddingPt = baseFontSizePt * 0.6f;
        return "margin-top: 0pt; margin-bottom: " + this.formatPt(externalSpacingPt) + "; padding-top: " + this.formatPt(verticalPaddingPt) + "; padding-right: " + this.formatPt(horizontalPaddingPt) + "; padding-bottom: " + this.formatPt(verticalPaddingPt) + "; padding-left: " + this.formatPt(horizontalPaddingPt);
    }

    String contextBoundarySpacingCss(float baseFontSizePt) {
        float verticalPaddingPt = baseFontSizePt * 0.5f;
        float bottomSpacingPt = baseFontSizePt * 0.35f;
        float horizontalPaddingPt = baseFontSizePt * 0.6f;
        return "margin-top: 0pt; margin-bottom: " + this.formatPt(bottomSpacingPt) + "; padding-top: " + this.formatPt(verticalPaddingPt) + "; padding-right: " + this.formatPt(horizontalPaddingPt) + "; padding-bottom: " + this.formatPt(verticalPaddingPt) + "; padding-left: " + this.formatPt(horizontalPaddingPt);
    }
}

