/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceBundles;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.FreeplaneVersion;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.main.application.ApplicationPropertyStore;
import org.freeplane.main.application.LastOpenedList;

public class ApplicationResourceController
extends ResourceController {
    private static final String USE_SYSTEM_LOCALE_PROPERTY = "useSystemLocale";
    private final ApplicationPropertyStore propertyStore;
    private LastOpenedList lastOpened;
    public static final String FREEPLANE_BASEDIRECTORY_PROPERTY = "org.freeplane.basedirectory";
    public static final String FREEPLANE_GLOBALRESOURCEDIR_PROPERTY = "org.freeplane.globalresourcedir";
    public static final String DEFAULT_FREEPLANE_GLOBALRESOURCEDIR = "resources";
    private final ArrayList<File> resourceDirectories = new ArrayList(2);
    private final Set<ClassLoader> resourceLoaders;
    public static String RESOURCE_BASE_DIRECTORY;
    public static String INSTALLATION_BASE_DIRECTORY;

    public static File getUserPreferencesFile() {
        String freeplaneDirectory = Compat.getApplicationUserDirectory();
        File userPropertiesFolder = new File(freeplaneDirectory);
        File autoPropertiesFile = new File(userPropertiesFolder, "auto.properties");
        return autoPropertiesFile;
    }

    private static File getUserSecretsFile() {
        String freeplaneDirectory = Compat.getApplicationUserDirectory();
        File userPropertiesFolder = new File(freeplaneDirectory);
        File secretsPropertiesFile = new File(userPropertiesFolder, "secrets.properties");
        return secretsPropertiesFile;
    }

    public static void showSysInfo() {
        StringBuilder info = new StringBuilder();
        info.append("freeplane_version = ");
        FreeplaneVersion freeplaneVersion = FreeplaneVersion.getVersion();
        info.append(freeplaneVersion);
        String revision = freeplaneVersion.getRevision();
        info.append("; freeplane_xml_version = ");
        info.append("freeplane 1.12.15");
        if (!revision.equals("")) {
            info.append("\ngit revision = ");
            info.append(revision);
        }
        info.append("\njava_version = ");
        info.append(System.getProperty("java.version"));
        info.append("; os_name = ");
        info.append(System.getProperty("os.name"));
        info.append("; os_version = ");
        info.append(System.getProperty("os.version"));
        LogUtils.info((String)info.toString());
    }

    public ApplicationResourceController() {
        Properties defaultProperties = this.readDefaultPreferences();
        this.propertyStore = new ApplicationPropertyStore(defaultProperties, ApplicationResourceController.getUserPreferencesFile(), ApplicationResourceController.getUserSecretsFile());
        if (!this.propertyStore.hasLoadedAutoProperties() && !this.propertyStore.hasLoadedSecretsProperties()) {
            System.err.println("User properties not found, new file created");
        }
        this.replacePropertyKey("keepSelectedNodeVisibleAfterZoom", "keepSelectedNodeVisible");
        this.replacePropertyKey("foldingsymbolwidth", "foldingsymbolsize");
        File userDir = this.createUserDirectory();
        String resourceBaseDir = this.getResourceBaseDir();
        if (resourceBaseDir != null) {
            try {
                File userResourceDir = new File(userDir, DEFAULT_FREEPLANE_GLOBALRESOURCEDIR);
                userResourceDir.mkdirs();
                this.resourceDirectories.add(userResourceDir);
                File resourceDir = new File(resourceBaseDir);
                this.resourceDirectories.add(resourceDir);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.resourceLoaders = new LinkedHashSet<ClassLoader>();
        if (!this.getBooleanProperty(USE_SYSTEM_LOCALE_PROPERTY)) {
            this.setDefaultLocale(this.getProperty("language"));
        }
        this.addPropertyChangeListener(new IFreeplanePropertyListener(){

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (propertyName.equals("language")) {
                    ApplicationResourceController.this.loadAnotherLanguage();
                }
            }
        });
    }

    private void replacePropertyKey(String oldKey, String newKey) {
        this.propertyStore.replacePropertyKey(oldKey, newKey);
    }

    private File createUserDirectory() {
        File userPropertiesFolder = new File(this.getFreeplaneUserDirectory());
        try {
            if (!userPropertiesFolder.exists()) {
                userPropertiesFolder.mkdirs();
            }
            return userPropertiesFolder;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Cannot create folder for user properties and logging: '" + userPropertiesFolder.getAbsolutePath() + "'");
            return null;
        }
    }

    public String getDefaultProperty(String key) {
        return this.propertyStore.getDefaultProperty(key);
    }

    public String getFreeplaneUserDirectory() {
        return Compat.getApplicationUserDirectory();
    }

    public LastOpenedList getLastOpenedList() {
        return this.lastOpened;
    }

    public Properties getUnsecuredProperties() {
        return this.propertyStore.getUnsecuredProperties();
    }

    public String getProperty(String key) {
        return this.propertyStore.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.propertyStore.getProperty(key, defaultValue);
    }

    public URL getResource(final String resourcePath) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                String relName = ApplicationResourceController.this.removeSlashAtStart(resourcePath);
                for (File directory : ApplicationResourceController.this.resourceDirectories) {
                    File fileResource = new File(directory, relName);
                    if (!fileResource.exists()) continue;
                    try {
                        return Compat.fileToUrl((File)fileResource);
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
                URL resource = ApplicationResourceController.super.getResource(resourcePath);
                if (resource != null) {
                    return resource;
                }
                if ("/lib/freeplaneviewer.jar".equals(resourcePath)) {
                    String rootDir = new File(ApplicationResourceController.this.getResourceBaseDir()).getAbsoluteFile().getParent();
                    try {
                        File try1 = new File(rootDir + "/plugins/org.freeplane.core/lib/freeplaneviewer.jar");
                        if (try1.exists()) {
                            return try1.toURL();
                        }
                        File try2 = new File(rootDir + "/lib/freeplaneviewer.jar");
                        if (try2.exists()) {
                            return try2.toURL();
                        }
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
                for (ClassLoader loader : ApplicationResourceController.this.resourceLoaders) {
                    URL resource2 = loader.getResource(resourcePath);
                    if (resource2 == null) continue;
                    return resource2;
                }
                return null;
            }
        });
    }

    private String removeSlashAtStart(String name) {
        String relName = name.startsWith("/") ? name.substring(1) : name;
        return relName;
    }

    public String getResourceBaseDir() {
        return RESOURCE_BASE_DIRECTORY;
    }

    public String getInstallationBaseDir() {
        return INSTALLATION_BASE_DIRECTORY;
    }

    public void registerResourceLoader(ClassLoader loader) {
        this.resourceLoaders.add(loader);
    }

    public void init() {
        this.lastOpened = new LastOpenedList();
        super.init();
    }

    private Properties readDefaultPreferences() {
        Properties props = new Properties();
        this.readDefaultPreferences(props, "/freeplane.properties");
        String propsLocs = props.getProperty("load_next_properties", "");
        this.readDefaultPreferences(props, propsLocs.split(";"));
        return props;
    }

    private void readDefaultPreferences(Properties props, String[] locArray) {
        for (String loc : locArray) {
            this.readDefaultPreferences(props, loc);
        }
    }

    private void readDefaultPreferences(Properties props, String propsLoc) {
        URL defaultPropsURL = this.getResource(propsLoc);
        ApplicationResourceController.loadProperties((Properties)props, (URL)defaultPropsURL);
    }

    public void saveProperties() {
        MIconController iconController22;
        MModeController modeController = MModeController.getMModeController();
        if (modeController != null && (iconController22 = (MIconController)modeController.getExtension(IconController.class)) != null) {
            iconController22.saveRecentlyUsedActions();
        }
        this.propertyStore.saveProperties(FreeplaneVersion.getVersion().toString());
        try {
            ((ResourceBundles)this.getResources()).saveUserResources();
        }
        catch (Exception iconController22) {
            // empty catch block
        }
        FilterController filterController = FilterController.getCurrentFilterController();
        if (filterController != null) {
            filterController.saveConditions();
        }
    }

    private void setDefaultLocale(String lang) {
        if (lang == null) {
            return;
        }
        Locale localeDef = null;
        switch (lang.length()) {
            case 2: {
                localeDef = new Locale(lang);
                break;
            }
            case 5: {
                localeDef = new Locale(lang.substring(0, 2), lang.substring(3, 5));
                break;
            }
            default: {
                return;
            }
        }
        Locale.setDefault(localeDef);
    }

    public void setDefaultProperty(String key, String value) {
        this.propertyStore.setDefaultProperty(key, value);
    }

    public void setProperty(String key, String value) {
        String oldValue = this.getProperty(key);
        if (oldValue == value) {
            return;
        }
        if (oldValue != null && oldValue.equals(value)) {
            return;
        }
        this.propertyStore.setProperty(key, value);
        this.firePropertyChanged(key, value, oldValue);
    }

    public Properties getSecuredProperties() {
        return this.propertyStore.getSecuredProperties();
    }

    public void securePropertyForModification(String key) {
        this.propertyStore.securePropertyForModification(key);
    }

    public void securePropertyForReadingAndModification(String key) {
        this.propertyStore.securePropertyForReadingAndModification(key);
    }

    public void persistPropertyInSecretsFile(String key) {
        this.propertyStore.persistPropertyInSecretsFile(key);
    }

    public boolean isPropertySetByUser(String key) {
        return this.propertyStore.isPropertySetByUser(key);
    }

    static {
        try {
            RESOURCE_BASE_DIRECTORY = new File(System.getProperty(FREEPLANE_GLOBALRESOURCEDIR_PROPERTY, DEFAULT_FREEPLANE_GLOBALRESOURCEDIR)).getCanonicalPath();
            INSTALLATION_BASE_DIRECTORY = new File(System.getProperty(FREEPLANE_BASEDIRECTORY_PROPERTY, RESOURCE_BASE_DIRECTORY + "/..")).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

