/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.mindmapmode;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FilterableJTree
extends JTree {
    private static final long serialVersionUID = 1L;

    public FilterableJTree(TreeModel model) {
        super(FilterableJTree.wrapModel(model));
    }

    @Override
    public void setModel(TreeModel model) {
        super.setModel(FilterableJTree.wrapModel(model));
    }

    private static TreeModel wrapModel(TreeModel model) {
        return new FilterableTreeModel(model);
    }

    public void setFilter(Predicate<Object> filter) {
        TreeModel m = this.getModel();
        if (!(m instanceof FilterableTreeModel)) {
            return;
        }
        FilterableTreeModel model = (FilterableTreeModel)m;
        TreePath[] oldSelection = this.getSelectionPaths();
        TreePath rootPath = new TreePath(model.getRoot());
        ArrayList<TreePath> expandedPaths = new ArrayList<TreePath>();
        Enumeration<TreePath> en = this.getExpandedDescendants(rootPath);
        if (en != null) {
            while (en.hasMoreElements()) {
                expandedPaths.add(en.nextElement());
            }
        }
        model.setFilter(filter);
        this.updateUI();
        for (TreePath path : expandedPaths) {
            if (this.getRowForPath(path) == -1) continue;
            this.expandPath(path);
        }
        if (oldSelection != null && oldSelection.length > 0) {
            ArrayList<TreePath> newSelection = new ArrayList<TreePath>();
            for (TreePath sel : oldSelection) {
                TreePath visible = this.findClosestVisiblePath(sel);
                if (visible == null) continue;
                newSelection.add(visible);
            }
            if (!newSelection.isEmpty()) {
                this.setSelectionPaths(newSelection.toArray(new TreePath[0]));
            } else {
                this.setSelectionPath(rootPath);
            }
        }
    }

    private TreePath findClosestVisiblePath(TreePath path) {
        while (path != null && this.getRowForPath(path) == -1) {
            path = path.getParentPath();
        }
        return path;
    }

    private static class FilterableTreeModel
    implements TreeModel,
    TreeModelListener {
        private final TreeModel delegate;
        private Predicate<Object> filter = null;
        private final Map<Object, List<Object>> filteredCache = new WeakHashMap<Object, List<Object>>();

        public FilterableTreeModel(TreeModel delegate) {
            this.delegate = delegate;
            delegate.addTreeModelListener(this);
        }

        public void setFilter(Predicate<Object> filter) {
            this.filter = filter;
            this.filteredCache.clear();
        }

        @Override
        public Object getRoot() {
            return this.delegate.getRoot();
        }

        @Override
        public Object getChild(Object parent, int index) {
            return this.isFiltering() ? this.getFilteredChildren(parent).get(index) : this.delegate.getChild(parent, index);
        }

        @Override
        public int getChildCount(Object parent) {
            return this.isFiltering() ? this.getFilteredChildren(parent).size() : this.delegate.getChildCount(parent);
        }

        @Override
        public boolean isLeaf(Object node) {
            if (this.delegate.isLeaf(node)) {
                return true;
            }
            return this.isFiltering() && this.getFilteredChildren(node).isEmpty();
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            return this.isFiltering() ? this.getFilteredChildren(parent).indexOf(child) : this.delegate.getIndexOfChild(parent, child);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.delegate.addTreeModelListener(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.delegate.removeTreeModelListener(l);
        }

        private boolean isFiltering() {
            return this.filter != null;
        }

        private List<Object> getFilteredChildren(Object node) {
            return this.filteredCache.computeIfAbsent(node, n -> {
                ArrayList<Object> visible = new ArrayList<Object>();
                int count = this.delegate.getChildCount(n);
                for (int i = 0; i < count; ++i) {
                    Object child = this.delegate.getChild(n, i);
                    List<Object> childVisible = this.getFilteredChildren(child);
                    if (!this.filter.test(child) && childVisible.isEmpty()) continue;
                    visible.add(child);
                }
                return visible;
            });
        }

        private void invalidateCache(Object[] nodes) {
            if (nodes != null) {
                for (Object node : nodes) {
                    this.filteredCache.remove(node);
                }
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            if (this.isFiltering()) {
                this.invalidateCache(e.getPath());
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            if (this.isFiltering()) {
                this.invalidateCache(e.getPath());
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            if (this.isFiltering()) {
                this.invalidateCache(e.getPath());
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            if (this.isFiltering()) {
                this.filteredCache.clear();
            }
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
            this.delegate.valueForPathChanged(path, newValue);
            if (this.isFiltering()) {
                this.invalidateCache(path.getPath());
            }
        }
    }
}

