/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.navigator;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.utils.CommonUtils;

class DashboardCreateWizardPage
extends WizardPage {
    @Nullable
    private DBPProject project;
    private String dashboardId;
    private String dashboardName;
    private boolean initDefCharts;

    protected DashboardCreateWizardPage(@Nullable DBPProject project, DBPDataSourceContainer dataSourceContainer) {
        super("New dashboard");
        this.setTitle("Create new dashboard" + (String)(dataSourceContainer == null ? "" : " for '" + dataSourceContainer.getName() + "'"));
        this.setDescription("Specify dashboard properties");
        this.project = project;
    }

    public String getDashboardId() {
        return this.dashboardId;
    }

    public String getDashboardName() {
        return this.dashboardName;
    }

    public boolean isInitDefCharts() {
        return this.initDefCharts;
    }

    public boolean isPageComplete() {
        if (this.project == null || !this.project.hasRealmPermission("project-resource-edit")) {
            this.setErrorMessage("The user needs more permissions to create a new diagram.");
            return false;
        }
        this.setErrorMessage(null);
        if (CommonUtils.isEmpty((String)this.dashboardId)) {
            this.setErrorMessage("Set dashboard ID");
        }
        if (CommonUtils.isEmpty((String)this.dashboardName)) {
            this.setErrorMessage("Set dashboard name");
        }
        return this.getErrorMessage() == null;
    }

    public void createControl(Composite parent) {
        Composite configGroup = UIUtils.createTitledComposite((Composite)parent, (String)"Settings", (int)2, (int)1808);
        Text dashboardNameText = UIUtils.createLabelText((Composite)configGroup, (String)"Name", null);
        Text dashboardIdText = UIUtils.createLabelText((Composite)configGroup, (String)"ID", null);
        dashboardNameText.addModifyListener(e -> {
            String oldId = CommonUtils.notEmpty((String)CommonUtils.escapeIdentifier((String)this.dashboardName)).toLowerCase();
            this.dashboardName = dashboardNameText.getText();
            if (oldId.equals(dashboardIdText.getText())) {
                dashboardIdText.setText(CommonUtils.notEmpty((String)CommonUtils.escapeIdentifier((String)this.dashboardName)).toLowerCase());
            }
            this.updateState();
        });
        dashboardIdText.addModifyListener(e -> {
            this.dashboardId = dashboardIdText.getText();
            this.updateState();
        });
        final Button initDefChartsCheck = UIUtils.createCheckbox((Composite)configGroup, (String)UIDashboardMessages.dialog_dashboard_view_config_group_viewcfg_checkbox_init_default, (String)UIDashboardMessages.dialog_dashboard_view_config_group_viewcfg_checkbox_init_default_tooltip, (boolean)true, (int)2);
        initDefChartsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ DashboardCreateWizardPage this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                this.this$0.initDefCharts = initDefChartsCheck.getSelection();
            }
        });
        this.setControl((Control)configGroup);
    }

    private void updateState() {
        this.getContainer().updateButtons();
    }
}

