/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser.tokens.predicates;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.TokenPredicateFactory;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;

class SQLTokenPredicateFactory
extends TokenPredicateFactory {
    private static final Log log = Log.getLog(SQLTokenPredicateFactory.class);
    private final TPRule[] allRules;

    public SQLTokenPredicateFactory(@NotNull SQLRuleManager ruleManager) {
        this.allRules = ruleManager.getAllRules();
    }

    @Override
    @Nullable
    protected SQLTokenType classifyToken(@NotNull String string) {
        StringScanner scanner = new StringScanner(string);
        for (TPRule rule : this.allRules) {
            try {
                scanner.reset();
                TPToken token = rule.evaluate(scanner);
                if (token.isUndefined()) continue;
                SQLTokenType tokenType = token instanceof TPTokenDefault ? (SQLTokenType)((TPTokenDefault)token).getData() : SQLTokenType.T_OTHER;
                return tokenType;
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
        return null;
    }

    private static class StringScanner
    implements TPCharacterScanner {
        private final String string;
        private int pos = 0;
        public static final char[][] DELIMITERS = new char[][]{{'\r'}, {'\n'}, {'\r', '\n'}};

        public StringScanner(@NotNull String string) {
            this.string = string;
        }

        @Override
        public char[][] getLegalLineDelimiters() {
            return DELIMITERS;
        }

        @Override
        public int getColumn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public int read() {
            return this.pos >= 0 && this.pos < this.string.length() ? (int)this.string.charAt(this.pos++) : -1;
        }

        @Override
        public void unread() {
            --this.pos;
        }

        public void reset() {
            this.pos = 0;
        }
    }
}

