/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreCreateSchemaDialog
extends BaseDialog {
    private final PostgreSchema schema;
    private List<PostgreRole> allUsers;
    private String name;
    private PostgreRole owner;

    public PostgreCreateSchemaDialog(Shell parentShell, PostgreSchema schema) {
        super(parentShell, PostgreMessages.dialog_create_schema_title, null);
        this.schema = schema;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite group = new Composite(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(1808));
        final Text nameText = UIUtils.createLabelText((Composite)group, (String)PostgreMessages.dialog_create_schema_name, (String)"");
        nameText.addModifyListener(new ModifyListener(){
            final /* synthetic */ PostgreCreateSchemaDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void modifyText(ModifyEvent e) {
                this.this$0.name = nameText.getText().trim();
                this.this$0.getButton(0).setEnabled(!this.this$0.name.isEmpty());
            }
        });
        Text databaseText = UIUtils.createLabelText((Composite)group, (String)"Database", (String)this.schema.getDatabase().getName(), (int)2056);
        final Combo userCombo = UIUtils.createLabelCombo((Composite)group, (String)PostgreMessages.dialog_create_schema_owner, (int)2060);
        userCombo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ PostgreCreateSchemaDialog this$0;
            {
                this.this$0 = this$0;
            }

            public void widgetSelected(SelectionEvent e) {
                this.this$0.owner = this.this$0.allUsers.get(userCombo.getSelectionIndex());
            }
        });
        new AbstractJob(this, "Load users"){
            final /* synthetic */ PostgreCreateSchemaDialog this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                try {
                    ArrayList userNames = new ArrayList();
                    this.this$0.allUsers = new ArrayList<PostgreRole>(this.this$0.schema.getDatabase().getUsers(monitor));
                    String currentUserName = this.this$0.schema.getDatabase().getDataSource().getContainer().getConnectionConfiguration().getUserName();
                    String defUserName = CommonUtils.isEmpty((String)currentUserName) ? "" : currentUserName;
                    UIUtils.syncExec(() -> {
                        for (PostgreRole authId : this.this$0.allUsers) {
                            String name = authId.getName();
                            userCombo.add(name);
                            if (!name.equals(defUserName)) continue;
                            this.this$0.owner = authId;
                        }
                        userCombo.setText(defUserName);
                    });
                }
                catch (DBException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return composite;
    }

    public String getName() {
        return this.name;
    }

    public PostgreRole getOwner() {
        return this.owner;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }
}

