/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.widgets.Display;

public class NativeImageLoader {
    private static final int PNG_INTERLACE_METHOD_OFFSET = 28;

    public static List<DPIUtil.ElementAtZoom<ImageData>> load(DPIUtil.ElementAtZoom<InputStream> streamAtZoom, ImageLoader imageLoader, int targetZoom) {
        boolean isStatic;
        ByteArrayInputStream stream2;
        byte[] data_buffer;
        InputStream stream = streamAtZoom.element();
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try {
                try {
                    data_buffer = stream.readAllBytes();
                }
                finally {
                    if (stream != null) {
                        stream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            SWT.error(39);
            return null;
        }
        if (data_buffer.length == 0) {
            SWT.error(42);
        }
        if (FileFormat.isDynamicallySizableFormat(stream2 = new ByteArrayInputStream(data_buffer))) {
            try {
                ((InputStream)stream2).reset();
            }
            catch (IOException e) {
                SWT.error(39);
            }
            return FileFormat.load(new DPIUtil.ElementAtZoom<InputStream>(stream2, streamAtZoom.zoom()), imageLoader, targetZoom);
        }
        ArrayList<ImageData> imgDataList = new ArrayList<ImageData>();
        long loader = GDK.gdk_pixbuf_loader_new();
        long buffer_ptr = OS.g_malloc(data_buffer.length);
        C.memmove(buffer_ptr, data_buffer, (long)data_buffer.length);
        long[] error = new long[1];
        GDK.gdk_pixbuf_loader_write(loader, buffer_ptr, data_buffer.length, error);
        if (error[0] != 0L) {
            if (OS.g_error_matches(error[0], OS.g_file_error_quark(), 21)) {
                SWT.error(39, null, Display.extractFreeGError(error[0]));
            } else {
                OS.g_error_free(error[0]);
            }
        }
        GDK.gdk_pixbuf_loader_close(loader, null);
        long pixbuf_animation = GDK.gdk_pixbuf_loader_get_animation(loader);
        if (pixbuf_animation == 0L) {
            SWT.error(40);
        }
        if (isStatic = GDK.gdk_pixbuf_animation_is_static_image(pixbuf_animation)) {
            long pixbuf = GDK.gdk_pixbuf_animation_get_static_image(pixbuf_animation);
            ImageData imgData = NativeImageLoader.pixbufToImageData(pixbuf);
            imgData.type = NativeImageLoader.getImageFormat(loader);
            imgDataList.add(imgData);
        } else {
            long start_time = OS.g_malloc(8L);
            OS.g_get_current_time(start_time);
            long animation_iter = GDK.gdk_pixbuf_animation_get_iter(pixbuf_animation, start_time);
            int delay_time = 0;
            int time_offset = 0;
            int num_frames = 32;
            int i = 0;
            while (i < num_frames) {
                delay_time = GDK.gdk_pixbuf_animation_iter_get_delay_time(animation_iter);
                OS.g_time_val_add(start_time, (time_offset += delay_time) * 1000);
                boolean update = GDK.gdk_pixbuf_animation_iter_advance(animation_iter, start_time);
                if (!update) break;
                long curr_pixbuf = GDK.gdk_pixbuf_animation_iter_get_pixbuf(animation_iter);
                long pixbuf_copy = GDK.gdk_pixbuf_copy(curr_pixbuf);
                ImageData imgData = NativeImageLoader.pixbufToImageData(pixbuf_copy);
                if (imageLoader.logicalScreenHeight == 0 && imageLoader.logicalScreenWidth == 0) {
                    imageLoader.logicalScreenHeight = imgData.height;
                    imageLoader.logicalScreenWidth = imgData.width;
                }
                OS.g_object_unref(pixbuf_copy);
                imgData.type = NativeImageLoader.getImageFormat(loader);
                imgData.delayTime = delay_time;
                imgDataList.add(imgData);
                ++i;
            }
        }
        ImageData[] imgDataArray = new ImageData[imgDataList.size()];
        int i = 0;
        while (i < imgDataList.size()) {
            imgDataArray[i] = (ImageData)imgDataList.get(i);
            ImageData data2 = (ImageData)imgDataArray[i].clone();
            if (imageLoader.hasListeners() && imgDataArray != null) {
                if (data2.type == 5 && NativeImageLoader.isInterlacedPNG(data_buffer)) {
                    imageLoader.notifyListeners(new ImageLoaderEvent(imageLoader, data2, i, true));
                } else if (data2.type != 5) {
                    imageLoader.notifyListeners(new ImageLoaderEvent(imageLoader, data2, i, true));
                }
            }
            ++i;
        }
        OS.g_free(buffer_ptr);
        OS.g_object_unref(loader);
        return Arrays.stream(imgDataArray).map(data -> new DPIUtil.ElementAtZoom<ImageData>((ImageData)data, streamAtZoom.zoom())).toList();
    }

    public static ImageData load(InputStream streamAtZoom, ImageLoader imageLoader, int width, int height) {
        return FileFormat.load(streamAtZoom, imageLoader, width, height);
    }

    private static boolean isInterlacedPNG(byte[] imageAsByteArray) {
        return imageAsByteArray.length > 28 && imageAsByteArray[28] != 0;
    }

    private static int getImageFormat(long loader) {
        long format = GDK.gdk_pixbuf_loader_get_format(loader);
        long name = GDK.gdk_pixbuf_format_get_name(format);
        String nameStr = Converter.cCharPtrToJavaString(name, false);
        OS.g_free(name);
        return switch (nameStr) {
            case "bmp" -> 0;
            case "gif" -> 2;
            case "ico" -> 3;
            case "jpeg" -> 4;
            case "png" -> 5;
            case "tiff" -> 6;
            case "svg" -> 8;
            default -> -1;
        };
    }

    private static ImageData pixbufToImageData(long pixbuf) {
        boolean hasAlpha = GDK.gdk_pixbuf_get_has_alpha(pixbuf);
        int width = GDK.gdk_pixbuf_get_width(pixbuf);
        int height = GDK.gdk_pixbuf_get_height(pixbuf);
        int stride = GDK.gdk_pixbuf_get_rowstride(pixbuf);
        int n_channels = GDK.gdk_pixbuf_get_n_channels(pixbuf);
        int bits_per_sample = GDK.gdk_pixbuf_get_bits_per_sample(pixbuf);
        long pixels = GDK.gdk_pixbuf_get_pixels(pixbuf);
        int lastRowWidth = width * ((n_channels * bits_per_sample + 7) / 8);
        byte[] srcData = new byte[stride * height];
        C.memmove(srcData, pixels, (long)(stride * (height - 1) + lastRowWidth));
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        ImageData imgData = new ImageData(width, height, bits_per_sample * n_channels, palette, stride, srcData);
        if (hasAlpha) {
            imgData.alphaData = new byte[width * height];
            byte[] alphaData = imgData.alphaData;
            int y = 0;
            int offset = 0;
            int alphaOffset = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    byte r = srcData[offset + 0];
                    byte g = srcData[offset + 1];
                    byte b = srcData[offset + 2];
                    byte a = srcData[offset + 3];
                    srcData[offset + 0] = 0;
                    alphaData[alphaOffset++] = a;
                    if (a != 0) {
                        srcData[offset + 1] = r;
                        srcData[offset + 2] = g;
                        srcData[offset + 3] = b;
                    }
                    ++x;
                    offset += n_channels;
                }
                ++y;
            }
        } else {
            int y = 0;
            int offset = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    byte r = srcData[offset + 0];
                    byte g = srcData[offset + 1];
                    byte b = srcData[offset + 2];
                    srcData[offset + 0] = r;
                    srcData[offset + 1] = g;
                    srcData[offset + 2] = b;
                    ++x;
                    offset += n_channels;
                }
                ++y;
            }
        }
        return imgData;
    }

    public static void save(OutputStream stream, int format, ImageLoader imageLoader) {
        int alpha_offset;
        if (format == -1) {
            SWT.error(42);
        }
        if (imageLoader.data == null) {
            SWT.error(4);
        }
        ImageData imgData = imageLoader.data[0];
        int colorspace = 0;
        boolean alpha_supported = format == 6 || format == 5 || format == 3;
        boolean has_alpha = imgData.alphaData != null && alpha_supported;
        int width = imgData.width;
        int height = imgData.height;
        int n_channels = imgData.bytesPerLine / width;
        if (!imgData.palette.isDirect || n_channels < 3 || n_channels > 4) {
            FileFormat.save(stream, format, imageLoader);
            return;
        }
        int da = 3;
        int dr = 0;
        int dg = 1;
        int db = 2;
        int or = 0;
        int og = 1;
        int ob = 2;
        PaletteData palette = imgData.palette;
        if (palette.isDirect && palette.blueShift < 0) {
            or = 2;
            og = 1;
            ob = 0;
        }
        int bytes_per_pixel = 4;
        byte[] srcData = new byte[width * height * bytes_per_pixel];
        int n = alpha_offset = n_channels == 4 ? 1 : 0;
        if (has_alpha) {
            y = 0;
            int offset = 0;
            new_offset = 0;
            int alphaIndex = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    byte b;
                    byte a = imgData.alphaData[alphaIndex++];
                    byte r = imgData.data[offset + alpha_offset + or];
                    byte g = imgData.data[offset + alpha_offset + og];
                    srcData[new_offset + db] = b = imgData.data[offset + alpha_offset + ob];
                    srcData[new_offset + dg] = g;
                    srcData[new_offset + dr] = r;
                    srcData[new_offset + da] = a;
                    ++x;
                    offset += n_channels;
                    new_offset += bytes_per_pixel;
                }
                ++y;
            }
        } else {
            y = 0;
            int offset = 0;
            new_offset = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    byte r = imgData.data[offset + alpha_offset + or];
                    byte g = imgData.data[offset + alpha_offset + og];
                    byte b = imgData.data[offset + alpha_offset + ob];
                    int a = -1;
                    srcData[new_offset + db] = b;
                    srcData[new_offset + dg] = g;
                    srcData[new_offset + dr] = r;
                    srcData[new_offset + da] = a;
                    ++x;
                    offset += n_channels;
                    new_offset += bytes_per_pixel;
                }
                ++y;
            }
        }
        long buffer_ptr = OS.g_malloc(srcData.length);
        C.memmove(buffer_ptr, srcData, (long)srcData.length);
        int rowstride = srcData.length / height;
        long pixbuf = GDK.gdk_pixbuf_new_from_data(buffer_ptr, colorspace, true, 8, width, height, rowstride, 0L, 0L);
        if (pixbuf == 0L) {
            OS.g_free(buffer_ptr);
            SWT.error(4);
        }
        String typeStr = switch (format) {
            case 1 -> "bmp";
            case 0 -> "bmp";
            case 2 -> "gif";
            case 3 -> "ico";
            case 4 -> "jpeg";
            case 5 -> "png";
            case 6 -> "tiff";
            case 8 -> "svg";
            default -> "";
        };
        byte[] type = Converter.wcsToMbcs(typeStr, true);
        long[] buffer = new long[1];
        if (type == null || typeStr == "") {
            OS.g_free(buffer_ptr);
            SWT.error(42);
        }
        long[] len = new long[1];
        GDK.gdk_pixbuf_save_to_bufferv(pixbuf, buffer, len, type, null, null, null);
        byte[] byteArray = new byte[(int)len[0]];
        C.memmove(byteArray, buffer[0], (long)byteArray.length);
        try {
            stream.write(byteArray);
        }
        catch (IOException e) {
            OS.g_free(buffer_ptr);
            SWT.error(39);
        }
        OS.g_free(buffer_ptr);
    }
}

