/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator.java;

import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFileAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ConstantPool;
import org.eclipse.equinox.p2.internal.repository.comparator.java.ConstantPoolEntry;

public class SourceFileAttribute
extends ClassFileAttribute {
    private final int sourceFileIndex;
    private final char[] sourceFileName;

    public SourceFileAttribute(byte[] classFileBytes, ConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        this.sourceFileIndex = this.u2At(classFileBytes, 6, offset);
        ConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.sourceFileIndex);
        if (constantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.sourceFileName = constantPoolEntry.getUtf8Value();
    }

    public int getSourceFileIndex() {
        return this.sourceFileIndex;
    }

    public char[] getSourceFileName() {
        return this.sourceFileName;
    }
}

