/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model.plan;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.ext.altibase.model.plan.AltibaseExecutionPlan;
import org.jkiss.dbeaver.ext.altibase.model.plan.AltibasePlanNode;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerSerialInfo;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanSerializer;
import org.jkiss.dbeaver.model.impl.plan.ExecutionPlanDeserializer;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IntKeyMap;

public class AltibaseQueryPlanner
extends AbstractExecutionPlanSerializer
implements DBCQueryPlanner {
    private static final String FORMAT_VERSION = "1";
    private final AltibaseDataSource dataSource;

    public AltibaseQueryPlanner(AltibaseDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public AltibaseDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query, @NotNull DBCQueryPlannerConfiguration configuration) throws DBException {
        AltibaseExecutionPlan plan = new AltibaseExecutionPlan(this.dataSource, (JDBCSession)session, query);
        plan.explain();
        return plan;
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return DBCPlanStyle.PLAN;
    }

    private JsonObject createAttr(String key, String value) {
        JsonObject attr = new JsonObject();
        attr.add(key, (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)value)));
        return attr;
    }

    private JsonObject createAttr(String key, int value) {
        JsonObject attr = new JsonObject();
        attr.add(key, (JsonElement)new JsonPrimitive((Number)value));
        return attr;
    }

    public void serialize(Writer planData, DBCPlan plan) throws IOException {
        this.serializeJson(planData, plan, this.dataSource.getInfo().getDriverName(), new DBCQueryPlannerSerialInfo(){

            public String version() {
                return AltibaseQueryPlanner.FORMAT_VERSION;
            }

            public void addNodeProperties(DBCPlanNode node, JsonObject nodeJson) {
                JsonArray attributes = new JsonArray();
                if (node instanceof AltibasePlanNode) {
                    AltibasePlanNode altiNode = (AltibasePlanNode)node;
                    attributes.add((JsonElement)AltibaseQueryPlanner.this.createAttr("id", altiNode.getId()));
                    attributes.add((JsonElement)AltibaseQueryPlanner.this.createAttr("parent_id", altiNode.getParentId()));
                    attributes.add((JsonElement)AltibaseQueryPlanner.this.createAttr("depth", altiNode.getDepth()));
                    attributes.add((JsonElement)AltibaseQueryPlanner.this.createAttr("plan", altiNode.getPlan()));
                }
                nodeJson.add("attributes", (JsonElement)attributes);
            }
        });
    }

    public DBCPlan deserialize(@NotNull Reader planData) throws IOException, InvocationTargetException {
        try {
            JsonObject jo = new JsonParser().parse(planData).getAsJsonObject();
            String query = this.getQuery(jo);
            ExecutionPlanDeserializer loader = new ExecutionPlanDeserializer();
            IntKeyMap allNodes = new IntKeyMap();
            List rootNodes = loader.loadRoot((DBPDataSource)this.dataSource, jo, (datasource, node, parent) -> {
                AltibasePlanNode altiNode = new AltibasePlanNode(this.dataSource, (IntKeyMap<AltibasePlanNode>)allNodes, this.getNodeAttributes(node));
                allNodes.put(altiNode.getId(), (Object)altiNode);
                return altiNode;
            });
            return new AltibaseExecutionPlan(query, rootNodes);
        }
        catch (Throwable e) {
            throw new InvocationTargetException(e);
        }
    }
}

