/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.EditorAssociationOverrideDescriptor;
import org.eclipse.ui.internal.ide.model.WorkbenchFile;

public class ContentTypeDecorator
implements ILightweightLabelDecorator {
    private boolean fHasEditorAssociationOverridesComputed = false;
    private boolean fHasEditorAssociationOverrides;

    public void decorate(Object element, IDecoration decoration) {
        if (!(element instanceof IFile)) {
            return;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench.isClosing()) {
            return;
        }
        IFile file = (IFile)element;
        ImageDescriptor image = null;
        if (this.hasEditorAssociationOverrides()) {
            IEditorDescriptor d = IDE.getDefaultEditor(file);
            if (d != null) {
                image = d.getImageDescriptor();
            }
        } else {
            IEditorRegistry editorRegistry;
            IContentType contentType;
            IContentDescription contentDescription;
            block15: {
                contentDescription = null;
                try {
                    try {
                        Job.getJobManager().beginRule((ISchedulingRule)file, null);
                        contentDescription = file.getContentDescription();
                    }
                    catch (CoreException coreException) {
                        Job.getJobManager().endRule((ISchedulingRule)file);
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    Job.getJobManager().endRule((ISchedulingRule)file);
                    throw throwable;
                }
                Job.getJobManager().endRule((ISchedulingRule)file);
            }
            if (contentDescription != null && (contentType = contentDescription.getContentType()) != null && (editorRegistry = workbench.getEditorRegistry()) != null) {
                image = editorRegistry.getImageDescriptor(file.getName(), contentType);
            }
        }
        try {
            if (file.getSessionProperty(WorkbenchFile.IMAGE_CACHE_KEY) != image) {
                file.setSessionProperty(WorkbenchFile.IMAGE_CACHE_KEY, (Object)image);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (image != null) {
            decoration.addOverlay(image);
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private boolean hasEditorAssociationOverrides() {
        if (!this.fHasEditorAssociationOverridesComputed) {
            this.fHasEditorAssociationOverrides = EditorAssociationOverrideDescriptor.getContributedEditorAssociationOverrides().length > 0;
            this.fHasEditorAssociationOverridesComputed = true;
        }
        return this.fHasEditorAssociationOverrides;
    }
}

