/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import java.sql.ResultSet;
import java.util.Date;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.vertica.model.VerticaDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class VerticaNode
implements DBSObject {
    private final VerticaDataSource dataSource;
    private String name;
    private String nodeState;
    private String nodeAddress;
    private String nodeAddressFamily;
    private String exportAddress;
    private String exportAddressFamily;
    private String catalogPath;
    private String nodeType;
    private boolean isEphemeral;
    private String standingInFor;
    private Date lastMsgFromNodeAt;
    private Date nodeDownSince;

    protected VerticaNode(VerticaDataSource dataSource, JDBCResultSet dbResult) {
        this.dataSource = dataSource;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"node_name");
        this.nodeState = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"node_state");
        this.nodeAddress = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"node_address");
        this.nodeAddressFamily = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"node_address_family");
        this.exportAddress = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"export_address");
        this.exportAddressFamily = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"export_address_family");
        this.catalogPath = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"catalog_path");
        this.nodeType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"node_type");
        this.isEphemeral = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"is_ephemeral");
        this.standingInFor = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"standing_in_for");
        this.lastMsgFromNodeAt = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"last_msg_from_node_at");
        this.nodeDownSince = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"node_down_since");
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource;
    }

    public boolean isPersisted() {
        return true;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=4)
    public String getNodeState() {
        return this.nodeState;
    }

    @Property(viewable=true, order=2)
    public String getNodeAddress() {
        return this.nodeAddress;
    }

    @Property(order=5)
    public String getNodeAddressFamily() {
        return this.nodeAddressFamily;
    }

    @Property(viewable=true, order=3)
    public String getExportAddress() {
        return this.exportAddress;
    }

    @Property(order=6)
    public String getExportAddressFamily() {
        return this.exportAddressFamily;
    }

    @Property(order=7)
    public String getCatalogPath() {
        return this.catalogPath;
    }

    @Property(order=8)
    public String getNodeType() {
        return this.nodeType;
    }

    @Property(order=9)
    public boolean isEphemeral() {
        return this.isEphemeral;
    }

    @Property(order=20)
    public String getStandingInFor() {
        return this.standingInFor;
    }

    @Property(order=21)
    public Date getLastMsgFromNodeAt() {
        return this.lastMsgFromNodeAt;
    }

    @Property(order=22)
    public Date getNodeDownSince() {
        return this.nodeDownSince;
    }
}

