/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oceanbase.model.plan;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanCostNode;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanNode;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

class OceanbasePlanNodeJSON
extends AbstractExecutionPlanNode
implements DBCPlanCostNode,
DBPPropertySource {
    private final OceanbasePlanNodeJSON parent;
    private final Map<String, String> nodeProps = new LinkedHashMap<String, String>();
    private final List<OceanbasePlanNodeJSON> nested = new ArrayList<OceanbasePlanNodeJSON>();
    private String name;
    private JsonObject object;

    OceanbasePlanNodeJSON(OceanbasePlanNodeJSON parent, String name, JsonObject object) {
        this.parent = parent;
        this.name = name;
        this.object = object;
        this.parseObject(name, object);
    }

    OceanbasePlanNodeJSON(OceanbasePlanNodeJSON parent, Map<String, String> attributes) {
        this.parent = parent;
        this.nodeProps.putAll(attributes);
    }

    Map<String, String> getNodeProps() {
        return Collections.unmodifiableMap(this.nodeProps);
    }

    Object getProperty(String name) {
        return this.nodeProps.get(name);
    }

    private void parseObject(String objName, JsonObject object) {
        for (Map.Entry prop : object.entrySet()) {
            String propName = (String)prop.getKey();
            JsonElement value = (JsonElement)prop.getValue();
            if (value instanceof JsonObject) {
                if ("cost_info".equals(propName)) {
                    this.parseObject(propName, (JsonObject)value);
                    continue;
                }
                if ("query_block".equals(propName)) {
                    this.name = "query_block";
                    this.parseObject(propName, (JsonObject)value);
                    continue;
                }
                if ("table".equals(propName) && "query_block".equals(objName)) {
                    this.name = "table";
                    this.parseObject(propName, (JsonObject)value);
                    continue;
                }
                this.addNested(propName, (JsonObject)value);
                continue;
            }
            if (value instanceof JsonArray) {
                boolean isProp = false;
                int itemIndex = 0;
                for (JsonElement item : (JsonArray)value) {
                    if (item instanceof JsonObject) {
                        this.addNested(propName + "#" + ++itemIndex, (JsonObject)item);
                        continue;
                    }
                    isProp = true;
                    break;
                }
                if (!isProp) continue;
                this.nodeProps.put(propName, value.toString());
                continue;
            }
            this.nodeProps.put(propName, value.getAsString());
        }
    }

    private void addNested(String name, JsonObject value) {
        this.nested.add(new OceanbasePlanNodeJSON(this, name, value));
    }

    @Property(order=0, viewable=true)
    public String getNodeType() {
        return this.name;
    }

    @Property(order=1, viewable=true)
    public String getNodeName() {
        String accessType;
        String nodeName = this.nodeProps.get("table_name");
        if (nodeName != null && (accessType = this.nodeProps.get("access_type")) != null) {
            return String.valueOf(nodeName) + " (" + String.valueOf(accessType) + ")";
        }
        return nodeName == null ? null : String.valueOf(nodeName);
    }

    @Property(order=10, viewable=true)
    public Number getNodeCost() {
        String readCost = this.nodeProps.get("COST");
        if (readCost == null) {
            if (this.nested != null) {
                long totalCost = 0L;
                for (OceanbasePlanNodeJSON child : this.nested) {
                    Number childCost = child.getNodeCost();
                    if (childCost == null) continue;
                    totalCost += childCost.longValue();
                }
                return totalCost;
            }
            return null;
        }
        return CommonUtils.toDouble((Object)readCost);
    }

    public Number getNodePercent() {
        return null;
    }

    public Number getNodeDuration() {
        return null;
    }

    @Property(order=11, viewable=true)
    public Number getNodeRowCount() {
        String rowCount = this.nodeProps.get("EST.ROWS");
        if (rowCount == null && this.nested != null) {
            long totalRC = 0L;
            for (OceanbasePlanNodeJSON child : this.nested) {
                Number childRC = child.getNodeRowCount();
                if (childRC == null) continue;
                totalRC += childRC.longValue();
            }
            return totalRC;
        }
        return rowCount == null ? null : Long.valueOf(CommonUtils.toLong((Object)rowCount));
    }

    public OceanbasePlanNodeJSON getParent() {
        return this.parent;
    }

    public Collection<OceanbasePlanNodeJSON> getNested() {
        return this.nested;
    }

    public String toString() {
        return this.object == null ? this.nodeProps.toString() : this.object.toString();
    }

    @NotNull
    public Object getEditableValue() {
        return this;
    }

    @NotNull
    public DBPPropertyDescriptor[] getProperties() {
        DBPPropertyDescriptor[] props = new DBPPropertyDescriptor[this.nodeProps.size()];
        int index = 0;
        for (Map.Entry<String, String> attr : this.nodeProps.entrySet()) {
            props[index++] = new PropertyDescriptor("Details", attr.getKey(), attr.getKey(), null, String.class, false, null, null, false);
        }
        return props;
    }

    @Nullable
    public Object getPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id) {
        return this.nodeProps.get(id);
    }

    public boolean isPropertySet(@NotNull String id) {
        return false;
    }

    public boolean isPropertyResettable(@NotNull String id) {
        return false;
    }

    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id) {
    }

    public void resetPropertyValueToDefault(@NotNull String id) {
    }

    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String id, @Nullable Object value) {
    }
}

