/***************************************************************************
                          kwebget.cpp  -  description
                             -------------------
    begin                : Son Jan 16 14:32:43 CET 2000
    copyright            : (C) 2000 by Frank von Daak
    email                : frank.fun@skydsl.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kwebget.h"
#include "../pics/bg.xpm"
#include "../pics/bg2.xpm"
#include "../pics/welcome.xpm"
#include "../pics/wizard.xpm"

// I've stolen this from kfind, to handle stdout and stderr of the wget-process :-)
#define BUFSIZE 16384

enum scheduleIt { hourly, daily, weekly, monthly };

KWebGet::KWebGet()
{
	wgetBin = 0;
	writeLog = false;
	recBool = false;
	term = "\n";
	scrollIt = true;
	wizOnStartup = false;
	emailUse = "";
	scheduleCount = 0;
	schedNums = 0;
	cnt = 0;
	scheduling = false;
	wget = new KShellProcess("/bin/sh");

	kapp->getConfig()->setGroup("KWebGet");
	wgetBin = kapp->getConfig()->readEntry("Wget-Path","");
	
	email = kapp->getConfig()->readEntry("Email", "");

	defhpr = kapp->getConfig()->readBoolEntry("HttpProxy", false);
	if ( defhpr ) {
		defHttpProxyAdr = kapp->getConfig()->readEntry("HttpProxyAdress","");
		defHttpProxyPrt = kapp->getConfig()->readEntry("HttpProxyPort","");
		htprlog = kapp->getConfig()->readBoolEntry("HttpProxyLogin", false);
		if ( htprlog ) {
			defHttpProxyUsr = kapp->getConfig()->readEntry("HttpProxyUser","");
			defHttpProxyPss = kapp->getConfig()->readEntry("HttpProxyPass","");
		} else {
			defHttpProxyUsr = "";
			defHttpProxyPss = "";
		}
	} else {
		defHttpProxyAdr = "";
		defHttpProxyPrt = "";
		defHttpProxyUsr = "";
		defHttpProxyPss = "";
	}

	deffpr = kapp->getConfig()->readBoolEntry("FtpProxy", false);
	if ( deffpr ) {
		defFtpProxyAdr = kapp->getConfig()->readEntry("FtpProxyAdress","");
		defFtpProxyPrt = kapp->getConfig()->readEntry("FtpProxyPort","");
	} else {
		defFtpProxyAdr = "";
		defFtpProxyPrt = "";
	}

	iBuffer = new char[BUFSIZE];
	iBuffer[0] = 0;
	home = QDir::homeDirPath();
	saveName = "";
	numself = 0;
}

KWebGet::~KWebGet()
{
	if ( wget->isRunning() ) {
//		wget->kill(SIGTERM);
		wget->kill(SIGKILL);
	}
}

void KWebGet::closeEvent(QCloseEvent *ce)
{
	quitApp();
}

// Called by main()
void KWebGet::startApp()
{
	this->setCaption("KWebGet");
	welPic = QPixmap ((const char **)welcome); // Startscreen-Pixmap
	bgPic = QPixmap((const char **)bg);			// Background - Pixmap
	bg2Pic = QPixmap((const char **)bg2);		// Toolbar - Pixmap
	initMenuBar();
	initToolBar();
}

// Creates the startscreen, and calls the timer ... ( 1 second)
void KWebGet::startView()
{
	start = 0;
	startShow = new QWidget(0,"Welcome", WStyle_Customize | WStyle_NoBorder); // | WStyle_Tool
	startShow->setFixedSize(400,200);
	startShow->setBackgroundPixmap(welPic);

	startShow->show();

	QTimer *timer = new QTimer(this);
	connect(timer , SIGNAL(timeout()), this ,SLOT(timerStoped()));
	timer->start(1000, TRUE);
}

void KWebGet::timerStoped()
{
	initView();
	killTimers(); // Kills the timer after one second
	// Now I have to check, if the user want's to see the Wizard-Question
	bool stwiz = kapp->getConfig()->readBoolEntry("WizQuest", false);
	if ( !stwiz ) {
		// If he wants to see, or this is the first startup - show the Question
		wizStartQuest();
	} else {
		// If he don't want the question, start with the last choose
	bool startWiz = kapp->getConfig()->readBoolEntry("StartWiz", true );
		if ( startWiz ) {
			wizOnStartup = true;
			startWizard();
		} else {
			this->show();
		}
	}
}

// This function destroys the startscreen, and calls the Main-View ...
void KWebGet::initView()
{
	startShow->hide();
	this->setBackgroundPixmap(bgPic);
	initMainView();
	if (!start) {
		this->setCaption(i18n("KWebGet - New_Project"));
		start = 1;
	}
}

void KWebGet::wizStartQuest()
{
	wizQuest = new MyDialog(this,0,true);
	wizQuest->setFixedSize(300,155);
	wizQuest->setCaption(i18n("Welcome to KWebGet !"));
	wizQuest->yesBut->setFocus();
	connect( wizQuest->showAgain, SIGNAL(clicked()), this, SLOT(showWizQuestSave()));
	connect( wizQuest->noBut, SIGNAL(clicked()), this, SLOT(showWizQuestCancel()));
	connect( wizQuest->yesBut, SIGNAL(clicked()), this, SLOT(showWizQuestApply()));
	wizQuest->setFocusPolicy(QWidget::StrongFocus);
	wizQuest->show();
}

void KWebGet::showWizQuestSave()
{
	kapp->getConfig()->writeEntry("WizQuest", wizQuest->showAgain->isChecked() );
	kapp->getConfig()->sync();
}

void KWebGet::showWizQuestApply()
{
	if ( wizQuest->showAgain->isChecked() ) {
		kapp->getConfig()->writeEntry("WizQuest", wizQuest->showAgain->isChecked() );
		kapp->getConfig()->writeEntry("StartWiz", wizQuest->yesBut->isChecked() );
		kapp->getConfig()->sync();
	}
	disconnect( wizQuest->showAgain, SIGNAL(clicked()), this, SLOT(showWizQuestSave()));
	disconnect( wizQuest->noBut, SIGNAL(clicked()), this, SLOT(showWizQuestCancel()));
	disconnect( wizQuest->yesBut, SIGNAL(clicked()), this, SLOT(showWizQuestApply()));
	delete(wizQuest);
	wizOnStartup = true;
	startWizard();
}

void KWebGet::showWizQuestCancel()
{
	kapp->getConfig()->writeEntry("WizQuest", wizQuest->showAgain->isChecked() );
	if ( wizQuest->showAgain->isChecked() ) {
		kapp->getConfig()->writeEntry("StartWiz", wizQuest->yesBut->isChecked() );
		kapp->getConfig()->sync();
	}
	disconnect( wizQuest->showAgain, SIGNAL(clicked()), this, SLOT(showWizQuestSave()));
	disconnect( wizQuest->noBut, SIGNAL(clicked()), this, SLOT(showWizQuestCancel()));
	disconnect( wizQuest->yesBut, SIGNAL(clicked()), this, SLOT(showWizQuestApply()));
	delete(wizQuest);
	this->show();
}

void KWebGet::initMenuBar()
{
  ///////////////////////////////////////////////////////////////////
  // MENUBAR
  ///////////////////////////////////////////////////////////////////
  file_menu = new QPopupMenu();
  ID_NEW = file_menu->insertItem(Icon("filenew.xpm"), i18n("&New..."));
  file_menu->connectItem(ID_NEW, this, SLOT (newProject()));
  ID_OPEN = file_menu->insertItem(Icon("fileopen.xpm"), i18n("&Open..."));
  file_menu->connectItem(ID_OPEN, this, SLOT (openFile()));
  ID_CLOSE = file_menu->insertItem(i18n("Close Project"));
  file_menu->connectItem(ID_CLOSE, this, SLOT (closeProject()));
  file_menu->insertSeparator();
  ID_FILE_SAVE = file_menu->insertItem(Icon("filefloppy.xpm") ,i18n("&Save"));
  file_menu->connectItem(ID_FILE_SAVE, this, SLOT (testConf()));
  ID_FILE_SAVE_AS  = file_menu->insertItem(Icon("filefloppy.xpm") ,i18n("Save &As"));
  file_menu->connectItem(ID_FILE_SAVE_AS, this, SLOT (saveFileAs()));
  file_menu->insertSeparator();
  ID_FILE_QUIT = file_menu->insertItem(i18n("E&xit") );
  file_menu->connectItem(ID_FILE_QUIT, this, SLOT (quitApp()));

  wiz_menu = new QPopupMenu();
  ID_WIZARD = wiz_menu->insertItem( QPixmap((const char **)wizard_xpm) , i18n("&Run Wizard") );
  wiz_menu->connectItem(ID_WIZARD, this, SLOT(startWizard()));

  ///////////////////////////////////////////////////////////////////
  // menuBar entry edit_menu
  options_menu = new QPopupMenu();
  ID_PREF = options_menu->insertItem(Icon("prev.xpm"), i18n("P&references"));
  options_menu->connectItem(ID_PREF, this, SLOT (prefMenu()));
  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  QString aboutstring=kapp->appName()+" "+VERSION+"\n(C)2000 by Frank von Daak\nfrank.fun@skydsl.de";

  help_menu = new QPopupMenu();
  help_menu = kapp->getHelpMenu(true, aboutstring );

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  menuBar()->insertItem(i18n("&Project"), file_menu);
  menuBar()->insertItem(i18n("&Wizard"), wiz_menu);
  menuBar()->insertItem(i18n("&Settings"), options_menu);

  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), help_menu);
}

void KWebGet::initToolBar()
{
	QFrame *toolFrame = new QFrame(this);
	toolFrame->setFrameStyle( QFrame::Panel | QFrame::Raised );
	toolFrame->setGeometry(0,25,600,40);
	toolFrame->setBackgroundPixmap(bg2Pic);
	
	newBut = new QPushButton(toolFrame);
	newBut->setPixmap(Icon("filenew.xpm"));
	newBut->setBackgroundPixmap(bg2Pic);
	newBut->setGeometry(10,5,30,30);
	connect( newBut, SIGNAL(clicked()), this, SLOT(newProject()));
	QToolTip::add( newBut,i18n("Create a new Project ..."));

	openBut = new QPushButton(toolFrame);
	openBut->setPixmap(Icon("fileopen.xpm"));
	openBut->setGeometry(50,5,30,30);
	connect(openBut, SIGNAL(clicked()), this, SLOT(openFile()));
	QToolTip::add( openBut,i18n("Open an existing project..."));
	
	saveBut = new QPushButton(toolFrame);
	saveBut->setPixmap(Icon("filefloppy.xpm"));
	saveBut->setBackgroundPixmap(bg2Pic);
	saveBut->setGeometry(90,5,30,30);
	connect(saveBut, SIGNAL(clicked()), this, SLOT(testConf()));
	QToolTip::add( saveBut,i18n("Save the current project..."));

	prevBut = new QPushButton(toolFrame);
	prevBut->setPixmap(Icon("prev.xpm"));
	prevBut->setBackgroundPixmap(bg2Pic);
	prevBut->setGeometry(130,5,30,30);
	connect(prevBut, SIGNAL(clicked()), this, SLOT(prefMenu()));
	QToolTip::add( prevBut,i18n("Preferences..."));

	wizBut = new QPushButton(toolFrame);
	wizBut->setPixmap(QPixmap((const char **)wizard_xpm));
	wizBut->setBackgroundPixmap(bg2Pic);
	wizBut->setGeometry(180,5,30,30);
	connect(wizBut, SIGNAL(clicked()), this, SLOT(startWizard()));
	QToolTip::add( wizBut,i18n("Start Wizard..."));
}

void KWebGet::startWizard()
{
	if ( !wizOnStartup ) {
		if ( closeProject() ) {
			newProject();
			wizard = new KWGWizard(this,0,true);
			wizard->setFixedSize(600,280);
			wizard->setCaption(i18n("Project Wiazrd"));
			connect(wizard->cancelBut, SIGNAL(clicked()), this, SLOT(quitWizard()));
			connect(wizard, SIGNAL(finished()), this, SLOT(getWizSet()));
			wizard->show();
		}
	} else {
		wizard = new KWGWizard(this,0,true);
		wizard->setFixedSize(600,280);
		wizard->setCaption(i18n("Project Wiazrd"));
		connect(wizard->cancelBut, SIGNAL(clicked()), this, SLOT(quitWizard()));
		connect(wizard, SIGNAL(finished()), this, SLOT(getWizSet()));
		wizard->show();
	}
}

void KWebGet::getWizSet()
{
	QString tmp, tmp2;
	bool tmpBool;
	int tmpInt;
	// The name of the project
		tmp = wizard->wizPage1->pnameLine->text();
		mainFrame->pnameLine->setText(tmp);
		tmp2 = "KWebGet - ";
		tmp2 += tmp;
		this->setCaption(tmp2);
	// The ProjectFolder
		tmp = wizard->wizPage1->projFolder;
		mainFrame->outLine->setText(tmp);
	// The User-Agent
		tmpInt = wizard->wizPage2->agentCombo->currentItem();
		switch ( tmpInt ) {
			case 0:
				mainFrame->wgetBut->setChecked(true);
				break;
			case 1:
				mainFrame->mozilla47But->setChecked(true);
				break;
			case 2:
				mainFrame->mozilla50But->setChecked(true);
				break;
			case 3:
				mainFrame->msieBut->setChecked(true);
				break;
			case 4:
				mainFrame->konqBut->setChecked(true);
				break;
			case 5:
				mainFrame->lynxBut->setChecked(true);
				break;
			case 6:
				mainFrame->otherBut->setChecked(true);
				mainFrame->otherLine->setEnabled(true);
				tmp = wizard->wizPage2->agentLine->text();
				mainFrame->otherLine->setText(tmp);
				break;
		}
	// The kind of project
		tmpBool = wizard->wizPage2->mirrorBut->isChecked();
		  if (tmpBool) {
		  	mainFrame->htmlBut->setChecked(true);
		  	mainFrame->activateHtmlLine();
		  	tmp = wizard->wizPage3->urlLine[0]->text();
		  	mainFrame->htmlLine->setText(tmp);
		  	mainFrame->protBox->setCurrentItem( wizard->wizPage3->protBox[0]->currentItem() );
		  	enableFileTypes();
		  // Username and Password ?
		  	tmpBool = wizard->wizPage3->loginBut[0]->isChecked();
		  	tmpInt = wizard->wizPage3->protBox[0]->currentItem();
		  	if (( tmpBool )&&( tmpInt == 0 )) {
			  	passFrame->httploginBox->setChecked(true);
			  	passFrame->httpusrLine->setText(wizard->wizPage3->userLine[0]->text());
			  	passFrame->httppassLine->setText(wizard->wizPage3->passLine[0]->text());
				passFrame->ftpanonBox->setChecked(false);
				setFtpAnon();
			}
			if (( tmpBool )&& ( tmpInt == 1 )) {
				if ( wizard->wizPage3->anonBut[0]->isChecked() )
					passFrame->ftpanonBox->setChecked(true);
				else {
					passFrame->ftpanonBox->setChecked(false);
					setFtpAnon();
				}
			  	passFrame->ftpusrLine->setText(wizard->wizPage3->userLine[0]->text());
			  	passFrame->ftppassLine->setText(wizard->wizPage3->passLine[0]->text());
			}
		  }
		tmpBool = wizard->wizPage2->singleBut->isChecked();
		  if (tmpBool) {
		  	mainFrame->fileBut->setChecked(true);
		  	mainFrame->activateFileLine();
		  	tmp = wizard->wizPage3->urlLine[1]->text();
		  	mainFrame->htmlLine->setText(tmp);
		  	tmp = wizard->wizPage3->fileLine[1]->text();
		  	mainFrame->urlLine->setText(tmp);
		  	mainFrame->protBox->setCurrentItem( wizard->wizPage3->protBox[0]->currentItem() );
		  	disableFileTypes();
		  	tmpBool = wizard->wizPage3->loginBut[1]->isChecked();
		  	tmpInt = wizard->wizPage3->protBox[1]->currentItem();
		  	if (( tmpBool )&&( tmpInt == 0 )) {
			  	passFrame->httploginBox->setChecked(true);
			  	passFrame->httpusrLine->setText(wizard->wizPage3->userLine[1]->text());
			  	passFrame->httppassLine->setText(wizard->wizPage3->passLine[1]->text());
				passFrame->ftpanonBox->setChecked(false);
				setFtpAnon();
			}
			if (( tmpBool )&& ( tmpInt == 1 )) {
				if ( wizard->wizPage3->anonBut[1]->isChecked() )
					passFrame->ftpanonBox->setChecked(true);
				else {
					passFrame->ftpanonBox->setChecked(false);
					setFtpAnon();
				}
			  	passFrame->ftpusrLine->setText(wizard->wizPage3->userLine[1]->text());
			  	passFrame->ftppassLine->setText(wizard->wizPage3->passLine[1]->text());
			}
		  }
		tmpBool = wizard->wizPage2->moresitesBut->isChecked();
		  if (tmpBool) {
		  	mainFrame->urllistBut->setChecked(true);
			mainFrame->openListEnter2();
			tmpInt = wizard->wizPage3->listWidg->addNum;
			mainFrame->listWidg->createLines(tmpInt);
			for ( int i=0; i <= tmpInt ; i++ ) {
				tmp = wizard->wizPage3->listWidg->protChoose[i]->currentText();
					if ( tmp != "http://" ) {
						mainFrame->listWidg->ftpBox[i]->show();
						mainFrame->listWidg->protChoose[i]->setCurrentItem(1);
						if ( wizard->wizPage3->listWidg->ftpBox[i]->isChecked() ) {
							mainFrame->listWidg->ftpBox[i]->setChecked(true);
						} else {
							mainFrame->listWidg->ftpBox[i]->setChecked(false);
						}
					}
						mainFrame->listWidg->siteLine[i]->setText(wizard->wizPage3->listWidg->siteLine[i]->text());
				}
			}
	// The Options
	  if (( wizard->wizPage2->moresitesBut->isChecked() )||
	  	( wizard->wizPage2->mirrorBut->isChecked() ) ) {
	// 	The number of levels
		if ( wizard->wizPage4->levBut->isChecked() ) {
			optFrame->recursiveBox->setChecked(true);
			optFrame->activateRecursive();
			optFrame->levSpBox->setValue( wizard->wizPage4->levBox->value() );
		} else {
			optFrame->recursiveBox->setChecked(true);
			optFrame->activateRecursive();
			optFrame->levSpBox->setValue(0);
		}
	// 	The number of files
		if ( wizard->wizPage4->quotaBut->isChecked() ) {
			optFrame->quotaBox->setChecked(true);
			optFrame->setQuota();
			optFrame->quotaSpBox->setValue( wizard->wizPage4->quotaBox->value() );
		}
	  }
	// The retry's
		if ( wizard->wizPage5->retryBut->isChecked() ) {
			optFrame->retryBox->setChecked(true);
			optFrame->setRetrys();
			optFrame->numRetryBox->setValue(wizard->wizPage5->retryBox->value() );
			optFrame->waitRetryBox->setValue(wizard->wizPage5->waitBox->value() );
		}
	// The Output-Messages
		if ( wizard->wizPage5->outputBut->isChecked() ) {
			optFrame->nooutputBox->setChecked(true);
			optFrame->noOutput();
		} else {
			optFrame->nooutputBox->setChecked(false);
			optFrame->noOutput();
		}
	// Ok, now I should have everything. Time to start the project...
	if ( wizard->wizPage6->startNow->isChecked() ) {
		switch (QMessageBox::warning(this, i18n("Save Project ?"),
				i18n("Would you like to save the Project ?"),
				i18n("Yes"), i18n("No"),0,0,1) ) {
			case 0:
				testConf();
				break;
			case 1:
				break;
		}
		startWGet();
	} else if ( wizard->wizPage6->doConfig->isChecked() ) {
		disconnect(wizard->cancelBut, SIGNAL(clicked()), this, SLOT(quitWizard()));
		disconnect(wizard, SIGNAL(finished()), this, SLOT(getWizSet()));
		delete(wizard);
		wizOnStartup = false;
		this->show();
	} else {
		testConf();
		exit(0);
	}
}

void KWebGet::quitWizard()
{
  if ( wizOnStartup ) {
	switch ( QMessageBox::warning( this, i18n("Are you sure ?"),
			i18n("Dou you really want to quit KWebGet ?"),
			i18n("Yes"), i18n("No"),i18n("Advanced"),0,2))
	{
		case 0:
			exit(0);
			break;
		case 1:
			return;
			break;
		case 2:
			disconnect(wizard->cancelBut, SIGNAL(clicked()), this, SLOT(quitWizard()));
			delete(wizard);
			this->show();
			wizOnStartup = false;
			break;
	}
  } else {
	switch ( QMessageBox::warning( this, i18n("Are you sure ?"),
			i18n("Dou you really want to quit the wizard ?"),
			i18n("Yes"), i18n("No"),0,0,1))
	{
		case 0:
			disconnect(wizard->cancelBut, SIGNAL(clicked()), this, SLOT(quitWizard()));
			delete(wizard);
			this->show();
			wizOnStartup = false;
			break;
		case 1:
			return;
			break;
	}
  }
}

void KWebGet::prefMenu()
{
	prefDialog = new PrefDialog(this, "Preferences", true,0);
	prefDialog->setFixedSize(440,360);
	prefDialog->setCaption(i18n("Preferences"));
	connect(prefDialog->prefTab, SIGNAL(cancelButtonPressed()), this, SLOT(prefCancel()));
	connect(prefDialog->prefTab, SIGNAL(defaultButtonPressed()), this, SLOT(prefOk()));
	connect(prefDialog->prefTab, SIGNAL(applyButtonPressed()), this, SLOT(prefOkApply()));
	if ( !wgetBin.isEmpty() ) {
		prefDialog->wgetBinLine->setText(wgetBin);
	}
	if ( !email.isEmpty() )
		prefDialog->emailLine->setText(email);

	bool tmpBool = kapp->getConfig()->readBoolEntry("WizQuest", true );
	if ( !tmpBool ) {
		prefDialog->selBut->setChecked(true);
	} else {
		tmpBool = kapp->getConfig()->readBoolEntry("StartWiz", true );
		if ( tmpBool )
			prefDialog->wizBut->setChecked(true);
		else
			prefDialog->advBut->setChecked(true);
	}
	if ( defhpr ) {
		prefDialog->httpProxyBox->setChecked(true);
		prefDialog->enableHttpProxy();
		if ( !defHttpProxyAdr.isEmpty() )
			prefDialog->httpProxyAdressLine->setText(defHttpProxyAdr);
		if ( !defHttpProxyPrt.isEmpty() )
			prefDialog->httpProxyPortLine->setText(defHttpProxyPrt);
		if ( htprlog ) {
			if ( !defHttpProxyUsr.isEmpty() ) {
				prefDialog->httpProxyloginBox->setChecked(true);
				prefDialog->getHttpProxyLogin();
				prefDialog->httpProxyusrLine->setText(defHttpProxyUsr);
			}
			if ( !defHttpProxyPss.isEmpty() )
				prefDialog->httpProxypassLine->setText(defHttpProxyPss);
		}
	}

	if ( deffpr ) {
		prefDialog->ftpProxyBox->setChecked(true);
		prefDialog->enableFtpProxy();
		if ( !defFtpProxyAdr.isEmpty() )
			prefDialog->ftpProxyAdressLine->setText(defFtpProxyAdr);
		if ( !defFtpProxyPrt.isEmpty() )
			prefDialog->ftpProxyPortLine->setText(defFtpProxyPrt);
	}
	
	prefDialog->show();
}

void KWebGet::prefOkApply()
{
	QString wgettmp, ftptmp;
	wgettmp = prefDialog->wgetBinLine->text();  // The given wget-path
	// First I have to check, if the Path to wget is correct ....
	if ( !wgettmp.isEmpty() ) {
		QFileInfo fitmp (wgettmp);
		if ( !fitmp.exists() ) {
			QMessageBox::warning(this, i18n("Wrong path !"),
				i18n("Please check the path !\n"
				"Can't find the file you've entered !"));
			return;
		}
		if ( !fitmp.isExecutable() ) {
			QMessageBox::warning(this, i18n("Wrong permissions !"),
				i18n("It seems, that you've no rights,\n"
				"to execute the file !\n\n"
				"Please contact your sysadmin !"));
			return;
		}
	wgetBin = wgettmp;		// Submit the wget-Path to the used variable
	}
	// How to start KWebGet ?
	kapp->getConfig()->setGroup("KWebGet");
	if ( prefDialog->wizBut->isChecked() ) {
		kapp->getConfig()->writeEntry("StartWiz", true );
		kapp->getConfig()->writeEntry("WizQuest", true );
	} else if ( prefDialog->advBut->isChecked() ) {
		kapp->getConfig()->writeEntry("StartWiz", false );
		kapp->getConfig()->writeEntry("WizQuest", true );
	} else if ( prefDialog->selBut->isChecked() )
		kapp->getConfig()->writeEntry("WizQuest", false );
		
	// Email-Adress in use for anonymous ftp ?
	QString tmp;
	tmp = prefDialog->emailLine->text();
	if ( !tmp.isEmpty() ) {
		kapp->getConfig()->writeEntry("Email", tmp);
		kapp->getConfig()->sync();
		if ( mainTab->isVisibleToTLW() ) {
			if ( passFrame->ftpanonBox->isChecked() ) {
				QString tmp2;
				tmp2 = passFrame->ftppassLine->text();
				if (( tmp2.isEmpty() )||( tmp != email ))
					passFrame->ftppassLine->setText(tmp);
			}
		}
		email = tmp;
	}
	
	// Default Proxy ?
	kapp->getConfig()->writeEntry("HttpProxy", prefDialog->httpProxyBox->isChecked());
	defhpr = prefDialog->httpProxyBox->isChecked();
	if ( defhpr ) {
		defHttpProxyAdr = prefDialog->httpProxyAdressLine->text();
		defHttpProxyPrt = prefDialog->httpProxyPortLine->text();
		defHttpProxyUsr = prefDialog->httpProxyusrLine->text();
		kapp->getConfig()->writeEntry("HttpProxyAdress", defHttpProxyAdr);
		kapp->getConfig()->writeEntry("HttpProxyPort", defHttpProxyPrt);
		htprlog = prefDialog->httpProxyloginBox->isChecked();
		kapp->getConfig()->writeEntry("HttpProxyLogin", htprlog);
		if (htprlog) {
			kapp->getConfig()->writeEntry("HttpProxyUser", defHttpProxyUsr);
			if ( prefDialog->storePassBut->isChecked() ) {
				defHttpProxyPss = prefDialog->httpProxypassLine->text();
				kapp->getConfig()->writeEntry("HttpProxyPass", defHttpProxyPss);
			} else {
				kapp->getConfig()->writeEntry("HttpProxyPass", "");
				defHttpProxyPss = prefDialog->httpProxypassLine->text();
			}
		}
	}
	kapp->getConfig()->writeEntry("FtpProxy", prefDialog->ftpProxyBox->isChecked());
	deffpr = prefDialog->ftpProxyBox->isChecked();
	if ( deffpr ) {
		defFtpProxyAdr = prefDialog->ftpProxyAdressLine->text();
		defFtpProxyPrt = prefDialog->ftpProxyPortLine->text();
		kapp->getConfig()->writeEntry("FtpProxyAdress", defFtpProxyAdr);
		kapp->getConfig()->writeEntry("FtpProxyPort", defFtpProxyPrt);
	}
	kapp->getConfig()->sync();

	if ( mainTab->isVisibleToTLW() ) {
		if ( prefDialog->httpProxyBox->isChecked() ) {
			proxyFrame->httpProxyBox->setChecked(true);
			proxyFrame->enableHttpProxy();
			if ( !defHttpProxyAdr.isEmpty() )
				proxyFrame->httpProxyAdressLine->setText(defHttpProxyAdr);
			if ( !defHttpProxyPrt.isEmpty() )
				proxyFrame->httpProxyPortLine->setText(defHttpProxyPrt);
			if ( prefDialog->httpProxyloginBox->isChecked() ) {
				if ( !defHttpProxyUsr.isEmpty() ) {
					proxyFrame->httpProxyloginBox->setChecked(true);
					proxyFrame->getHttpProxyLogin();
					proxyFrame->httpProxyusrLine->setText(defHttpProxyUsr);
				}
				if ( !defHttpProxyPss.isEmpty() )
					proxyFrame->httpProxypassLine->setText(defHttpProxyPss);
			} else {
				proxyFrame->httpProxyloginBox->setChecked(false);
				proxyFrame->getHttpProxyLogin();
			}
		} else {
			proxyFrame->httpProxyBox->setChecked(false);
			proxyFrame->enableHttpProxy();
		}

		if ( prefDialog->ftpProxyBox->isChecked() ) {
			proxyFrame->ftpProxyBox->setChecked(true);
			proxyFrame->enableFtpProxy();
			if ( !defFtpProxyAdr.isEmpty() )
				proxyFrame->ftpProxyAdressLine->setText(defFtpProxyAdr);
			if ( !defFtpProxyPrt.isEmpty() )
				proxyFrame->ftpProxyPortLine->setText(defFtpProxyPrt);
		} else {
			proxyFrame->ftpProxyBox->setChecked(false);
			proxyFrame->enableFtpProxy();
		}
	}
	return;
}

void KWebGet::prefOk()
{
	prefOkApply();
	delete(prefDialog);
}

void KWebGet::prefCancel()
{
	delete(prefDialog);
	return;
}
void KWebGet::newProject()
{
	if ( closeProject() ) {
		initView();
		this->setCaption("KWebGet - New_Project");
	}
}

int KWebGet::closeProject()
{
	if ( !mainTab->isVisibleToTLW() )
	{
	} else {
	  if ( appChanged() ) {
		switch (QMessageBox::information( this, i18n("Question"),
				i18n("Would you like to save the current\n"
				"Project ?"),i18n("Yes"), i18n("No"), i18n("Cancel"),0,2) )
		{
		case 0:
			if ( testConf() ) {
			  delete(mainTab);
			  file_menu->setItemEnabled(ID_FILE_SAVE, false);
			  file_menu->setItemEnabled(ID_FILE_SAVE_AS, false);
			  file_menu->setItemEnabled(ID_CLOSE, false);
			}
			break;
		case 1:
			delete(mainTab);
			  file_menu->setItemEnabled(ID_FILE_SAVE, false);
			  file_menu->setItemEnabled(ID_FILE_SAVE_AS, false);
			  file_menu->setItemEnabled(ID_CLOSE, false);
			break;
		case 2:
			return 0;
			break;
		}
	  } else {
		delete(mainTab);
		file_menu->setItemEnabled(ID_FILE_SAVE, false);
		file_menu->setItemEnabled(ID_FILE_SAVE_AS, false);
		file_menu->setItemEnabled(ID_CLOSE, false);
	  }
	}
	this->setCaption("KWebGet");
	saveName = "";
	return 1;
}

void KWebGet::quitApp()
{
	if ( !appChanged() ) {
		kapp->getConfig()->setGroup("KWebGet");
		kapp->getConfig()->writeEntry("Wget-Path", wgetBin);
		kapp->getConfig()->sync();
		exit(1);
	} else {
		if (closeProject())
		kapp->getConfig()->setGroup("KWebGet");
		kapp->getConfig()->writeEntry("Wget-Path", wgetBin);
		kapp->getConfig()->sync();
		exit(1);
	}
}

int KWebGet::appChanged()
{
	QString tmp, tmp2;
	tmp = mainFrame->pnameLine->text();
	if ( tmp != i18n("New_Project") )
		return 1;
	tmp = mainFrame->outLine->text();
	tmp2.sprintf("%s/KWebGetProjects/", (const char*)home);
	if ( tmp != tmp2 )
		return 1;
	tmp = mainFrame->htmlLine->text();
	if (( !mainFrame->htmlBut->isChecked() )||( !tmp.isEmpty() ))
		return 1;
	tmp = mainFrame->protBox->currentText();
	if ( tmp != "http://" )
		return 1;
	if ( !mainFrame->wgetBut->isChecked())
		return 1;
	if ( optFrame->nooutputBox->isChecked() )
		return 1;
	if ( optFrame->retryBox->isChecked() )
		return 1;
	if ( optFrame->recursiveBox->isChecked() )
		return 1;
	if ( optFrame->timeoutBox->isChecked() )
		return 1;
	if ( optFrame->quotaBox->isChecked() )
		return 1;
	if ( optFrame->logBox->isChecked() )
		return 1;
	if ( optFrame->noclubBox->isChecked() )
		return 1;
	if ( optFrame->timestampBox->isChecked() )
		return 1;
	if ( optFrame->folderBox->isChecked() )
		return 1;
	if ( optFrame->nohostBox->isChecked() )
		return 1;
	if ( optFrame->forcedirBox->isChecked() )
		return 1;
	if ( optFrame->serveranswerBox->isChecked() )
		return 1;
	if ( optFrame->nodnsBox->isChecked() )
		return 1;
	if ( optFrame->cacheBox->isChecked() )
		return 1;
	if ( optFrame->followftpBox->isChecked() )
		return 1;
	if ( optFrame->spiderBox->isChecked() )
		return 1;
	if ( optFrame->convlinkBox->isChecked() )
		return 1;
	if ( optFrame->passFtpBox->isChecked() )
		return 1;
	if ( !getAllTypes->isChecked())
		return 1;
	if ( passFrame->httploginBox->isChecked() )
		return 1;
	if ( !passFrame->ftpanonBox->isChecked() )
		return 1;
	tmp = passFrame->ftppassLine->text();
	if ( tmp != email )
		return 1;

	bool tmpBool;
	tmpBool = proxyFrame->httpProxyBox->isChecked();
	if ( tmpBool != defhpr) {
		return 1;
	}
	tmp = proxyFrame->httpProxyAdressLine->text();
	if ( tmp != defHttpProxyAdr )
		return 1;
	tmp = proxyFrame->httpProxyPortLine->text();
	if ( tmp != defHttpProxyPrt )
		return 1;
	tmpBool = proxyFrame->httpProxyloginBox->isChecked();
	if ( tmpBool != htprlog )
		return 1;
	tmp = proxyFrame->httpProxyusrLine->text();
	if ( tmp != defHttpProxyUsr )
		return 1;
	tmp = proxyFrame->httpProxypassLine->text();
	if ( tmp != defHttpProxyPss )
		return 1;
	
	tmpBool = proxyFrame->ftpProxyBox->isChecked();
	if ( tmpBool != deffpr )
		return 1;
	tmp = proxyFrame->ftpProxyAdressLine->text();
	if ( tmp != defFtpProxyAdr )
		return 1;
	tmp = proxyFrame->ftpProxyPortLine->text();
	if ( tmp != defFtpProxyPrt )
		return 1;
	tmpBool = scheduleFrame->schedBox->isChecked();
	if ( tmpBool )
		return 1;
	if ( !getAllDomains->isChecked() )
		return 1;
	
	return 0;		// If nothing is changed, no need to save anything -> quitApp
}

void KWebGet::initMainView()
{
	file_menu->setItemEnabled(ID_FILE_SAVE, true);
	file_menu->setItemEnabled(ID_FILE_SAVE_AS, true);
	file_menu->setItemEnabled(ID_CLOSE, true);
	
	mainTab = new QTabDialog(this);
	mainTab->setCaption(i18n("KWebGet"));
	
	mainConf = new QWidget(0, "mainConf");
	mainConf->setFixedSize(570,250);
	
	optConf = new QWidget(0, "optConf");
	optConf->setFixedSize(570,250);

	fileConf = new QWidget(0, "fileConf");
	fileConf->setFixedSize(570,250);
	
	domainConf = new QWidget(0, "domainConf");
	domainConf->setFixedSize(570,250);

	passConf = new QWidget(0, "passConf");
	passConf->setFixedSize(570,250);

	proxyConf = new QWidget(0, "proxyConf");
	proxyConf->setFixedSize(570,250);

	scheduleConf = new QWidget(0, "scheduleConf");
	scheduleConf->setFixedSize(570,250);

	setMainConf();
	setOptConf();
	setFileConf();
	setDomainConf();
	setPassConf();
	setProxyConf();
	setScheduleConf();

	mainTab->addTab (mainConf, i18n("General"));
	mainTab->addTab (optConf, i18n("Options"));
	mainTab->addTab (fileConf, i18n("FileTypes"));
	mainTab->addTab (domainConf, i18n("Domains"));
	mainTab->addTab (passConf, i18n("Password"));
	mainTab->addTab (proxyConf, i18n("Proxy"));
	mainTab->addTab (scheduleConf, i18n("Scheduler"));
	mainTab->setDefaultButton(i18n("Start"));
	mainTab->setApplyButton(i18n("Cancel"));
    mainTab->setCancelButton(0);
    mainTab->setOkButton(0);
    mainTab->setGeometry(5,70,590,270);
	mainTab->show();

	connect(mainTab, SIGNAL(applyButtonPressed()), this, SLOT(closeProject()));
	connect(mainTab, SIGNAL(defaultButtonPressed()), this, SLOT(startWGet()));

	QAccel *a = new QAccel(this);
	a->connectItem( a->insertItem(Key_Return),this, SLOT(startWGet()) );
}

void KWebGet::setMainConf()
{
	mainFrame = new MainConf(mainConf);
	mainFrame->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	mainFrame->setGeometry(2,2,567,245);

	connect(mainFrame->pnameLine, SIGNAL(textChanged(const char*)), this, SLOT(setCaptionText(const char*)));
	connect(mainFrame->protBox, SIGNAL(activated(int)), this ,SLOT(getProt(int)));
	connect(mainFrame->htmlBut, SIGNAL(clicked()), this, SLOT(enableFileTypes()));
	connect(mainFrame->fileBut, SIGNAL(clicked()), this, SLOT(disableFileTypes()));
}

void KWebGet::disableFileTypes()
{
	mainTab->setTabEnabled("fileConf", false );
	if ( optFrame->recursiveBox->isChecked() ) {
		recBool = true;
		optFrame->recursiveBox->setChecked(false);
	}
	optFrame->recursiveBox->setEnabled(false);
}

void KWebGet::enableFileTypes()
{
	mainTab->setTabEnabled("fileConf", true );
	if ( recBool ) {
		recBool = false;
		optFrame->recursiveBox->setChecked(true);
	}
	optFrame->recursiveBox->setEnabled(true);
}

void KWebGet::setOptConf()
{
	optFrame = new OptConf(optConf);
	optFrame->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	optFrame->setGeometry(2,2,567,245);
}

void KWebGet::setDomainConf()
{
	domainFrame = new DomainConf(domainConf);
	domainFrame->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	domainFrame->setGeometry(2,2,567,245);
	domainFrame->hide();

	domainBox = new QButtonGroup(domainConf);
	domainBox->setGeometry(5,2,558,22);

	QFont fnt("helvetica",12, QFont::Bold);

	getAllDomains = new QRadioButton(i18n("Get files from all Domains"), domainBox);
	getAllDomains->setGeometry(5,2,220,18);
	getAllDomains->setFont(fnt);
	getAllDomains->setChecked(true);
	connect(getAllDomains, SIGNAL(clicked()), this, SLOT(getALLDomains()));
	QToolTip::add( getAllDomains,i18n("Click here to download files from all domains"));

	getSelDomains = new QRadioButton(i18n("Select Domains"), domainBox);
	getSelDomains->setGeometry(230,2,180,18);
	getSelDomains->setFont(fnt);
	connect(getSelDomains, SIGNAL(clicked()), this, SLOT(getALLDomains()));
	QToolTip::add( getSelTypes,i18n("Click here to choose the domains, you want\n"
			"KWebGet to download files from, or not !"));
}

void KWebGet::setFileConf()
{
	fileFrame = new FileConf(fileConf);
	fileFrame->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	fileFrame->setGeometry(2,2,567,245);

	fileBox = new QButtonGroup(fileConf);
	fileBox->setGeometry(5,2,558,22);

	QFont fnt("helvetica",12, QFont::Bold);

	getAllTypes = new QRadioButton(i18n("Download all filetypes"), fileBox);
	getAllTypes->setGeometry(5,2,170,18);
	getAllTypes->setFont(fnt);
	getAllTypes->setChecked(true);
	connect(getAllTypes, SIGNAL(clicked()), this, SLOT(getAllFileTypes()));
	QToolTip::add( getAllTypes,i18n("Click here, to download all filetypes"));

	getSelTypes = new QRadioButton(i18n("Select filetypes to get/reject"), fileBox);
	getSelTypes->setGeometry(180,2,220,18);
	getSelTypes->setFont(fnt);
	connect(getSelTypes, SIGNAL(clicked()), this, SLOT(getAllFileTypes()));
	QToolTip::add( getSelTypes,i18n("Click here, to select the filetypes,\n"
				"KWebGet should only get/not get !"));
}

void KWebGet::getAllFileTypes()
{
	if ( getAllTypes->isChecked() ){
		fileFrame->getBut->hide();
		fileFrame->rejBut->hide();
		fileFrame->imgFrame->hideItems();
		fileFrame->txtFrame->hideItems();
		fileFrame->audFrame->hideItems();
		fileFrame->vidFrame->hideItems();
		fileFrame->othFrame->hideItems();
	} else {
		fileFrame->getBut->show();
		fileFrame->rejBut->show();
		fileFrame->imgFrame->showItems();
		fileFrame->txtFrame->showItems();
		fileFrame->audFrame->showItems();
		fileFrame->vidFrame->showItems();
		fileFrame->othFrame->showItems();
	}
}

void KWebGet::getALLDomains()
{
	if ( getAllDomains->isChecked() ){
		domainFrame->hide();
	} else {
		domainFrame->show();
	}
}


void KWebGet::setPassConf()
{
	passFrame = new PassConf(passConf);
	passFrame->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	passFrame->setGeometry(2,2,567,245);
	
	if ( !email.isEmpty() )
		passFrame->ftppassLine->setText(email);

	connect(passFrame->ftpanonBox, SIGNAL(clicked()), this, SLOT(setFtpAnon()));
}

void KWebGet::setProxyConf()
{
	proxyFrame = new ProxyConf(proxyConf);
	proxyFrame->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	proxyFrame->setGeometry(2,2,567,245);

	if ( defhpr ) {
		proxyFrame->httpProxyBox->setChecked(true);
		proxyFrame->enableHttpProxy();
		if ( !defHttpProxyAdr.isEmpty() )
			proxyFrame->httpProxyAdressLine->setText(defHttpProxyAdr);
		if ( !defHttpProxyPrt.isEmpty() )
			proxyFrame->httpProxyPortLine->setText(defHttpProxyPrt);
		if ( htprlog ) {
			if ( !defHttpProxyUsr.isEmpty() ) {
				proxyFrame->httpProxyloginBox->setChecked(true);
				proxyFrame->getHttpProxyLogin();
				proxyFrame->httpProxyusrLine->setText(defHttpProxyUsr);
			}
			if ( !defHttpProxyPss.isEmpty() )
				proxyFrame->httpProxypassLine->setText(defHttpProxyPss);
		}
	}

	if ( deffpr ) {
		proxyFrame->ftpProxyBox->setChecked(true);
		proxyFrame->enableFtpProxy();
		if ( !defFtpProxyAdr.isEmpty() )
			proxyFrame->ftpProxyAdressLine->setText(defFtpProxyAdr);
		if ( !defFtpProxyPrt.isEmpty() )
			proxyFrame->ftpProxyPortLine->setText(defFtpProxyPrt);
	}

}

void KWebGet::setScheduleConf()
{
	scheduleFrame = new ScheduleConf(scheduleConf);
	scheduleFrame->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	scheduleFrame->setGeometry(2,2,567,245);
}

void KWebGet::getProt(int index)
{
	prot.sprintf("%s", (const char*)mainFrame->protBox->currentText());
}

void KWebGet::setFtpAnon()
{
	if ( passFrame->ftpanonBox->isChecked() ) {
		passFrame->ftppassLine->setEchoMode(QLineEdit::Normal);
		passFrame->ftpusrLine->setText("anonymous");
		if ( email.isEmpty() )
			passFrame->ftppassLine->setText("");
		else if ( !emailUse.isEmpty() )
			passFrame->ftppassLine->setText(emailUse);
		else
			passFrame->ftppassLine->setText(email);
		passFrame->ftpusrLine->setEnabled(false);
		passFrame->ftppassLine->setEnabled(true);
	} else {
		QString tmp;
		tmp = passFrame->ftppassLine->text();
		if ( tmp != email )
			emailUse = tmp;
		else
			emailUse = email;
		passFrame->ftppassLine->setEchoMode(QLineEdit::Password);
		passFrame->ftpusrLine->setText("");
		passFrame->ftppassLine->setText("");
		passFrame->ftpusrLine->setEnabled(true);
		passFrame->ftppassLine->setEnabled(true);
	}
}

void KWebGet::setCaptionText(const char *txt)
{
	QString capt;
	capt.sprintf("KWebGet - %s", txt);
	this->setCaption(capt);
}

void KWebGet::saveFileAs()
{
	QString buffer;
	buffer = saveName;
	saveName = "";
	if ( !testConf() ) {
		saveName = buffer;
	}
}

int KWebGet::testConf()
{
	projName = mainFrame->pnameLine->text();
	if ( projName.isEmpty() ) {
		QMessageBox::warning( this, i18n("No Project Name"),
					i18n("Please give the project a name !"));
		return 0;
	}
	if ( saveName.isEmpty() ) {
		saveName = saveDialog->getSaveFileName(home,"*.kwmprj", this);	// Where should I save the project ?
		if ( saveName.isEmpty() ) 					// If cancel is clicked, don't close the project !
			return 0;
		QFile saveFile(saveName);
		QFileInfo saveFileInfo(saveName);
			QString rght = saveName.right(1);
			if ( rght == "/" ) {
				QMessageBox::warning(this, i18n("No Filename"),
					i18n("Please enter a filename !"));
					return 0;
			} else if ((saveFile.exists())&&( !saveFileInfo.isWritable() )) {
				QMessageBox::warning(this, i18n("No Permissions"),
						i18n("It seems, that you have no permissions\n"
						"to overwrite the file !"));
				saveName = "";
				return 0;
		}
		rght = saveName.right(7);
		if (( saveFile.exists() )&&( rght == ".kwmprj" )) {
			switch (QMessageBox::warning(this, i18n("Overwrite existing file ?"),
						i18n("Should I overwrite the File ?"),
						i18n("Yes"), i18n("No"),0,0,1) )
			{
			case 0:
				writeConfig();
				return 1;
				break;
			case 1:
				saveName = "";
				return 0;
			}
		} else if (( saveFile.exists() )&&( rght != ".kwmprj" )) {
			QMessageBox::warning(this, i18n("Wrong Filename"),
						i18n("This is not a KWebGet-Config-File !"));
			return 0;
		}
	}
	QString rght;
	rght = saveName.right(7);
	if ( rght != ".kwmprj" )
		saveName += ".kwmprj";
	QFile saveFile(saveName);
	writeConfig();
	return 1;
}

int KWebGet::startMirror()
{
	QString prFld = mainFrame->outLine->text();
	if ( prFld.isEmpty() ) {
		QMessageBox::warning( this, i18n("No Project Folder"),
					i18n("Please enter a project Folder"));
		return 0;
	}
	return 1;
}

void KWebGet::writeConfig()
{
	QString checkFileEnd;
	checkFileEnd = saveName.right(7);
	if ( checkFileEnd == ".kwmprj" ) {
	} else {
		saveName += ".kwmprj";
	}
	QString prFld = mainFrame->outLine->text();

	QFile confFile(saveName);
	if ( confFile.exists() )
		confFile.remove();

	config = new KSimpleConfig(saveName);
	config->setGroup("KWebGet");

	config->writeEntry("ProjectName",projName);
	config->writeEntry("ProjectFolder",prFld);
	
	config->setGroup("MainFrame");

	config->writeEntry("GetSite", mainFrame->htmlBut->isChecked());
	if ( mainFrame->urllistBut->isChecked() ) {
		config->writeEntry("GetSiteList", mainFrame->urllistBut->isChecked());
		config->writeEntry("NumSites", mainFrame->listWidg->addNum );
		QString prot, site, anon;
		for ( int i=0; i <= mainFrame->listWidg->addNum; i++ ) {
			prot.sprintf("Prot%d",i);
			config->writeEntry(prot, mainFrame->listWidg->protChoose[i]->currentText());
			site.sprintf("Site%d",i);
			config->writeEntry(site, mainFrame->listWidg->siteLine[i]->text());
			anon.sprintf("Anon%d",i);
			config->writeEntry(anon, mainFrame->listWidg->ftpBox[i]->isChecked());
			}
	}
	config->writeEntry("Protocol",mainFrame->protBox->currentText());
	config->writeEntry("Url", mainFrame->htmlLine->text());
	config->writeEntry("Filename", mainFrame->urlLine->text());
	QString agent;
	if ( mainFrame->wgetBut->isChecked())
		agent = "Wget";
	else if ( mainFrame->mozilla47But->isChecked())
		agent = "Mozilla47";
	else if ( mainFrame->mozilla50But->isChecked())
		agent = "Mozilla50";
	else if ( mainFrame->msieBut->isChecked())
		agent = "MSIE";
	else if ( mainFrame->konqBut->isChecked())
		agent = "Konqueror";
	else if ( mainFrame->lynxBut->isChecked())
		agent = "Lynx";
	else if ( mainFrame->otherBut->isChecked())
		agent = mainFrame->otherLine->text();
	config->writeEntry("Agent", agent);

	config->setGroup("OptFrame");
	
	config->writeEntry("Output", optFrame->output);
	config->writeEntry("RetryDL", optFrame->retryBox->isChecked());
	config->writeEntry("NumRretrys", optFrame->numRetryBox->text());
	config->writeEntry("WaitRetry", optFrame->waitRetryBox->text());
	config->writeEntry("Recursive", optFrame->recursiveBox->isChecked());
	config->writeEntry("Levels", optFrame->levSpBox->text());
	config->writeEntry("SetTimeout", optFrame->timeoutBox->isChecked());
	config->writeEntry("Timeout", optFrame->timeoutSpBox->text());
	config->writeEntry("SetQuota", optFrame->quotaBox->isChecked());
	config->writeEntry("Quota", optFrame->quotaSpBox->text());
	config->writeEntry("Logging", optFrame->logBox->isChecked());
	config->writeEntry("NoClub", optFrame->noclubBox->isChecked());
	config->writeEntry("Timestamp", optFrame->timestampBox->isChecked());
	config->writeEntry("Folders", optFrame->folderBox->isChecked());
	config->writeEntry("NoHosts", optFrame->nohostBox->isChecked());
	config->writeEntry("ForceDirs", optFrame->forcedirBox->isChecked());
	config->writeEntry("Serveranswers", optFrame->serveranswerBox->isChecked());
	config->writeEntry("NoDNS", optFrame->nodnsBox->isChecked());
	config->writeEntry("Cache", optFrame->cacheBox->isChecked());
	config->writeEntry("FollowFTP", optFrame->followftpBox->isChecked());
	config->writeEntry("Spider", optFrame->spiderBox->isChecked());
	config->writeEntry("ConvLinks", optFrame->convlinkBox->isChecked());
	config->writeEntry("PassiveFtp", optFrame->passFtpBox->isChecked());

	config->setGroup("PassFrame");

	config->writeEntry("Http-Login", passFrame->httploginBox->isChecked());
	config->writeEntry("Ftp-Anon", passFrame->ftpanonBox->isChecked());
	if ( passFrame->ftpanonBox->isChecked())
		config->writeEntry("Ftp-Anon-Mail", passFrame->ftppassLine->text());

	config->writeEntry("Use-HTTP-Proxy", proxyFrame->httpProxyBox->isChecked());
	config->writeEntry("HttpProxyAdress", proxyFrame->httpProxyAdressLine->text());
	config->writeEntry("HttpProxyPort", proxyFrame->httpProxyPortLine->text());
	config->writeEntry("UseHttpProxyLogin", proxyFrame->httpProxyloginBox->isChecked());
	config->writeEntry("HttpProxy-Username", proxyFrame->httpProxyusrLine->text());
	config->writeEntry("HttpProxy-Password", proxyFrame->httpProxypassLine->text());

	config->writeEntry("Use-FTP-Proxy", proxyFrame->ftpProxyBox->isChecked());
	config->writeEntry("FtpProxyAdress", proxyFrame->ftpProxyAdressLine->text());
	config->writeEntry("FtpProxyPort", proxyFrame->ftpProxyPortLine->text());

	config->writeEntry("Http-Username", passFrame->httpusrLine->text());
	config->writeEntry("Ftp-Username", passFrame->ftpusrLine->text());

	config->setGroup("DomainFrame");

	QString tmp1;
	if ( !getAllDomains->isChecked() ) {
	  config->writeEntry("IncludeDomains",domainFrame->includeBut->isChecked() );
	  if ( domainFrame->includeBut->isChecked() ) {
		for ( int i=1; i <= 16; i++) {
				tmp1.sprintf("incDomain%d", i);
				config->writeEntry(tmp1,domainFrame->iMulti[i]->text());
		}
	  } else {
		for ( int i=1; i <= 16; i++) {
				tmp1.sprintf("excDomain%d", i);
				config->writeEntry(tmp1,domainFrame->iMulti[i]->text());
		}
	  }
	}
	config->writeEntry("GetAllDomains", getAllDomains->isChecked() );

	config->setGroup("FileFrame");
	
	if ( !getAllTypes->isChecked() ) {
	  config->writeEntry("GetTypes", fileFrame->getBut->isChecked() );
		config->writeEntry("jpg", fileFrame->imgFrame->jpgBox->isChecked() );
		config->writeEntry("jpeg", fileFrame->imgFrame->jpegBox->isChecked());
		config->writeEntry("gif", fileFrame->imgFrame->gifBox->isChecked());
		config->writeEntry("bmp", fileFrame->imgFrame->bmpBox->isChecked());
		config->writeEntry("png", fileFrame->imgFrame->pngBox->isChecked());
		config->writeEntry("xpm", fileFrame->imgFrame->xpmBox->isChecked());
		config->writeEntry("pnm", fileFrame->imgFrame->pnmBox->isChecked());
		
		config->writeEntry("wav", fileFrame->audFrame->wavBox->isChecked());
		config->writeEntry("mid", fileFrame->audFrame->midBox->isChecked());
		config->writeEntry("snd", fileFrame->audFrame->sndBox->isChecked());
		config->writeEntry("mp2", fileFrame->audFrame->mp2Box->isChecked());
		config->writeEntry("mp3", fileFrame->audFrame->mp3Box->isChecked());
		config->writeEntry("aiff", fileFrame->audFrame->aiffBox->isChecked());
		config->writeEntry("ram", fileFrame->audFrame->ramBox->isChecked());
		
		config->writeEntry("mov", fileFrame->vidFrame->movBox->isChecked());
		config->writeEntry("mpg", fileFrame->vidFrame->mpgBox->isChecked());
		config->writeEntry("mpeg", fileFrame->vidFrame->mpegBox->isChecked());
		config->writeEntry("rm", fileFrame->vidFrame->rmBox->isChecked());
		config->writeEntry("avi", fileFrame->vidFrame->aviBox->isChecked());
		config->writeEntry("qt", fileFrame->vidFrame->qtBox->isChecked());
		
		config->writeEntry("txt", fileFrame->txtFrame->txtBox->isChecked());
		config->writeEntry("doc", fileFrame->txtFrame->docBox->isChecked());
		config->writeEntry("html", fileFrame->txtFrame->htmlBox->isChecked());
		config->writeEntry("htm", fileFrame->txtFrame->htmBox->isChecked());
		config->writeEntry("shtml", fileFrame->txtFrame->shtmlBox->isChecked());
		config->writeEntry("asp", fileFrame->txtFrame->aspBox->isChecked());
		config->writeEntry("pdf", fileFrame->txtFrame->pdfBox->isChecked());
		
		config->writeEntry("zip", fileFrame->othFrame->zipBox->isChecked());
		config->writeEntry("bz2", fileFrame->othFrame->bz2Box->isChecked());
		config->writeEntry("exe", fileFrame->othFrame->exeBox->isChecked());
		config->writeEntry("gz", fileFrame->othFrame->gzBox->isChecked());
		config->writeEntry("rpm", fileFrame->othFrame->rpmBox->isChecked());
		config->writeEntry("rar", fileFrame->othFrame->rarBox->isChecked());
		config->writeEntry("tar", fileFrame->othFrame->tarBox->isChecked());
		config->writeEntry("deb", fileFrame->othFrame->debBox->isChecked());
		config->writeEntry("ace", fileFrame->othFrame->aceBox->isChecked());
		
		for ( int i=1; i <= 18; i++) {
				QString self, selfBox;
				self.sprintf("self%d", i);
				selfBox.sprintf("selfBox%d", i);
				config->writeEntry(selfBox, fileFrame->othFrame->newftBox[i]->isChecked());
				config->writeEntry(self,fileFrame->othFrame->newftLine[i]->text());
		}
	}
	config->writeEntry("GetAllFiles", getAllTypes->isChecked() );

	config->setGroup("ScheduleFrame");

		config->writeEntry("Schedule", scheduleFrame->schedBox->isChecked() );
		if ( scheduleFrame->schedBox->isChecked() ) {
			config->writeEntry("ShowIt", scheduleFrame->schedOutputBox->isChecked() );
			config->writeEntry("Hourly", scheduleFrame->hourlyBut->isChecked() );
			config->writeEntry("Daily", scheduleFrame->dailyBut->isChecked() );
			config->writeEntry("Weekly", scheduleFrame->weeklyBut->isChecked() );
			config->writeEntry("Monthly", scheduleFrame->monthlyBut->isChecked() );
			config->writeEntry("AfterHour", scheduleFrame->afterHourSpBox->value() );
			config->writeEntry("StartTimeH", scheduleFrame->hourSpBox->value() );
			config->writeEntry("StartTimeM", scheduleFrame->minSpBox->value() );
			config->writeEntry("AM", scheduleFrame->amBut->isChecked() );
			config->writeEntry("PM", scheduleFrame->pmBut->isChecked() );
			config->writeEntry("Mon", scheduleFrame->monBut->isChecked() );
			config->writeEntry("Tue", scheduleFrame->tueBut->isChecked() );
			config->writeEntry("Wed", scheduleFrame->wedBut->isChecked() );
			config->writeEntry("Thu", scheduleFrame->thuBut->isChecked() );
			config->writeEntry("Fri", scheduleFrame->friBut->isChecked() );
			config->writeEntry("Sat", scheduleFrame->satBut->isChecked() );
			config->writeEntry("Sun", scheduleFrame->sunBut->isChecked() );
			config->writeEntry("DayOfMonth", scheduleFrame->monthSpBox->value() );
			config->writeEntry("SchedCount", scheduleFrame->schedCountBox->isChecked() );
			config->writeEntry("SchedNum", scheduleFrame->schedCountSpBox->value() );
		}
	config->sync();
}

void KWebGet::openFile()
{
	QString openProj;
	openProj = openDialog->getOpenFileName(home,"*.kwmprj", this);	// What should I load ?
	if ( openProj.isEmpty() ) {
		return;
	} else if ( !closeProject() ) {
		return;
	} else {
		QFile openFile(openProj);
		QFileInfo openFileInfo(openProj);
		if ( !openFile.exists() ) {
			QMessageBox::warning(this, i18n("Error while loading"),
						i18n("This file doesn't exist !"));
			return;
		} else if (( !openFileInfo.isWritable() )||( !openFileInfo.isReadable() )) {
			QMessageBox::warning(this, i18n("Error while loading"),
						i18n("You have no permissions,\n"
						"to access this file !"));
			return;
		}
		config = new KSimpleConfig(openProj);
		saveName = openProj;
		initMainView();
		QString tmpStr;
		bool tmpBool;
		int tmpInt;

		config->setGroup("KWebGet");

		tmpStr = config->readEntry("ProjectName", "");
		mainFrame->pnameLine->setText(tmpStr);
		tmpStr.insert(0, "KWebGet - ");
		this->setCaption(tmpStr);

		tmpStr = config->readEntry("ProjectFolder", "");
		mainFrame->outLine->setText(tmpStr);
		
		config->setGroup("MainFrame");

		tmpBool = config->readBoolEntry("GetSite", true);
		if ( !tmpBool ) {
			tmpBool = config->readBoolEntry("GetSiteList", true);
			if ( !tmpBool ) {
				mainFrame->fileBut->setChecked(true);
				mainFrame->urlLine->show();
				mainFrame->fnameLab->show();
				mainTab->setTabEnabled("fileConf", false );
			} else {
				mainFrame->urllistBut->setChecked(true);
				mainFrame->htmlLine->hide();
				mainFrame->protBox->hide();
				mainFrame->urlLab->hide();
				mainFrame->openListEnter2();
				int sites = config->readNumEntry("NumSites",0);
				mainFrame->listWidg->createLines(sites);
				QString tmp;
				for ( int i=0; i <= sites ; i++ ) {
					tmp.sprintf("Prot%d",i);
					tmpStr = config->readEntry(tmp,"http://");
					if ( tmpStr != "http://" ) {
						mainFrame->listWidg->ftpBox[i]->show();
						tmp.sprintf("Anon%d",i);
						mainFrame->listWidg->protChoose[i]->setCurrentItem(1);
						tmpBool = config->readBoolEntry(tmp,true);
						if ( tmpBool ) {
							mainFrame->listWidg->ftpBox[i]->setChecked(true);
						} else {
							mainFrame->listWidg->ftpBox[i]->setChecked(false);
						}
					}
					tmp.sprintf("Site%d",i);
					tmpStr = config->readEntry(tmp,"");
						mainFrame->listWidg->siteLine[i]->setText((const char*)tmpStr);
				}
			}
		}
		tmpStr = config->readEntry("Protocol", "http://");
		if ( tmpStr == "http://")
			mainFrame->protBox->setCurrentItem(0);
		else
			mainFrame->protBox->setCurrentItem(1);
		
		tmpStr = config->readEntry("Url", "");
		mainFrame->htmlLine->setText(tmpStr);
		
		tmpStr = config->readEntry("Filename", "");
		mainFrame->urlLine->setText(tmpStr);

		tmpStr = config->readEntry("Agent", "Wget");
		if ( tmpStr == "WGet" )
			mainFrame->wgetBut->setChecked(true);
		else if ( tmpStr == "Mozilla47" )
			mainFrame->mozilla47But->setChecked(true);
		else if ( tmpStr == "Mozilla50" )
			mainFrame->mozilla50But->setChecked(true);
		else if ( tmpStr == "MSIE" )
			mainFrame->msieBut->setChecked(true);
		else if ( tmpStr == "Konqueror" )
			mainFrame->konqBut->setChecked(true);
		else if ( tmpStr == "Lynx" )
			mainFrame->lynxBut->setChecked(true);
		else {
			mainFrame->otherBut->setChecked(true);
			mainFrame->otherLine->setText(tmpStr);
			mainFrame->otherLine->setEnabled(true);
		}
		
		config->setGroup("OptFrame");
		
		tmpBool = config->readBoolEntry("Output", true);
			if ( tmpBool ) {
				optFrame->output = true;
				optFrame->nooutputBox->setChecked(false);
			} else {
				optFrame->output = false;
				optFrame->nooutputBox->setChecked(true);
			}
		tmpBool = config->readBoolEntry("RetryDL", false);
			if ( tmpBool ) {
				optFrame->retryBox->setChecked(true);
				optFrame->numRetryBox->setEnabled(true);
				optFrame->waitRetryBox->setEnabled(true);
			}
		tmpInt = config->readNumEntry("NumRretrys", 0);
			if ( tmpBool )
				optFrame->numRetryBox->setValue(tmpInt);
		tmpInt = config->readNumEntry("WaitRetry", 0);
			optFrame->waitRetryBox->setValue(tmpInt);
		tmpBool = config->readBoolEntry("Recursive", false);
			if ( tmpBool ) {
				optFrame->recursiveBox->setChecked(true);
				optFrame->levSpBox->setEnabled(true);
			}
		tmpInt = config->readNumEntry("Levels", 0);
			optFrame->levSpBox->setValue(tmpInt);
		tmpBool = config->readBoolEntry("SetTimeout", false);
			if ( tmpBool ) {
				optFrame->timeoutBox->setChecked(true);
				optFrame->timeoutSpBox->setEnabled(true);
			}
		tmpInt = config->readNumEntry("Timeout", 0);
				optFrame->timeoutSpBox->setValue(tmpInt);
		tmpBool = config->readBoolEntry("SetQuota", false);
			if ( tmpBool ) {
				optFrame->quotaBox->setChecked(true);
				optFrame->quotaSpBox->setEnabled(true);
			}
		tmpInt = config->readNumEntry("Quota", 0);
				optFrame->quotaSpBox->setValue(tmpInt);
		tmpBool = config->readBoolEntry("Logging", false);
			if ( tmpBool )
				optFrame->logBox->setChecked(true);
		tmpBool = config->readBoolEntry("NoClub", false);
			if ( tmpBool )
				optFrame->noclubBox->setChecked(true);
		tmpBool = config->readBoolEntry("Timestamp", false);
			if ( tmpBool )
				optFrame->timestampBox->setChecked(true);
		tmpBool = config->readBoolEntry("Folders", false);
			if ( tmpBool )
				optFrame->folderBox->setChecked(true);
		tmpBool = config->readBoolEntry("NoHosts", false);
			if ( tmpBool )
				optFrame->nohostBox->setChecked(true);
		tmpBool = config->readBoolEntry("ForceDirs", false);
			if ( tmpBool )
				optFrame->forcedirBox->setChecked(true);
		tmpBool = config->readBoolEntry("Serveranswers", false);
			if ( tmpBool )
				optFrame->serveranswerBox->setChecked(true);
		tmpBool = config->readBoolEntry("NoDNS", false);
			if ( tmpBool )
				optFrame->nodnsBox->setChecked(true);
		tmpBool = config->readBoolEntry("Cache", false);
			if ( tmpBool )
				optFrame->cacheBox->setChecked(true);
		tmpBool = config->readBoolEntry("FollowFTP", false);
			if ( tmpBool ) {
				optFrame->followftpBox->setChecked(true);
			}
		tmpBool = config->readBoolEntry("Spider", false);
			if ( tmpBool )
				optFrame->spiderBox->setChecked(true);
		tmpBool = config->readBoolEntry("ConvLinks", false);
			if ( tmpBool )
				optFrame->convlinkBox->setChecked(true);
		tmpBool = config->readBoolEntry("PassiveFtp", false);
			if ( tmpBool )
				optFrame->passFtpBox->setChecked(true);
		
		config->setGroup("PassFrame");
		
		tmpBool = config->readBoolEntry("Http-Login", false);
			if ( tmpBool ) {
				passFrame->httploginBox->setChecked(true);
				passFrame->httpusrLine->setEnabled(true);
				passFrame->httppassLine->setEnabled(true);
			}
		tmpBool = config->readBoolEntry("Ftp-Anon", false);
			if ( tmpBool ) {
				passFrame->ftpanonBox->setChecked(true);
				passFrame->ftpusrLine->setText("");
				tmpStr = config->readEntry("Ftp-Anon-Mail", "");
				passFrame->ftppassLine->setText(tmpStr);
				passFrame->ftpusrLine->setEnabled(false);
				emailUse = tmpStr;
			}
		
		tmpBool = config->readBoolEntry("Use-HTTP-Proxy", false);
			if ( tmpBool ) {
				proxyFrame->httpProxyBox->setChecked(true);
				proxyFrame->enableHttpProxy();
				tmpStr = config->readEntry("HttpProxyAdress","");
				proxyFrame->httpProxyAdressLine->setText(tmpStr);
				tmpStr = config->readEntry("HttpProxyPort","0");
				proxyFrame->httpProxyPortLine->setText(tmpStr);
			tmpBool = config->readBoolEntry("UseHttpProxyLogin", false);
				if ( tmpBool ) {
					proxyFrame->httpProxyloginBox->setChecked(true);
					proxyFrame->getHttpProxyLogin();
					tmpStr = config->readEntry("HttpProxy-Username","");
					proxyFrame->httpProxyusrLine->setText(tmpStr);
					tmpStr = config->readEntry("HttpProxy-Password","");
					proxyFrame->httpProxypassLine->setText(tmpStr);
				}
			}
		tmpBool = config->readBoolEntry("Use-FTP-Proxy", false);
			if ( tmpBool ) {
				proxyFrame->ftpProxyBox->setChecked(true);
				proxyFrame->enableFtpProxy();
				tmpStr = config->readEntry("FtpProxyAdress","");
				proxyFrame->ftpProxyAdressLine->setText(tmpStr);
				tmpStr = config->readEntry("FtpProxyPort","0");
				proxyFrame->ftpProxyPortLine->setText(tmpStr);
			}
		tmpStr = config->readEntry("Http-Username", "");
			passFrame->httpusrLine->setText(tmpStr);
		tmpStr = config->readEntry("Ftp-Username", "");
			passFrame->ftpusrLine->setText(tmpStr);

		config->setGroup("DomainFrame");

		QString tmp1;
		tmpBool = config->readBoolEntry("GetAllDomains", true);
		if (tmpBool) {
			getAllDomains->setChecked(true);
		} else {
		  getSelDomains->setChecked(true);
		  domainFrame->show();
		  tmpBool = config->readBoolEntry("IncludeDomains",true );
		  if ( tmpBool ) {
			domainFrame->includeBut->setChecked(true);
			for ( int i=1; i <= 16; i++) {
				tmp1.sprintf("incDomain%d", i);
				tmpStr = config->readEntry(tmp1,"");
				if ( !tmpStr.isEmpty() ) {
					domainFrame->iMulti[i]->setText(tmpStr);
				}
			}
		  } else {
			domainFrame->excludeBut->setChecked(true);
			for ( int i=1; i <= 16; i++) {
				tmp1.sprintf("excDomain%d", i);
				tmpStr = config->readEntry(tmp1,"");
				if ( !tmpStr.isEmpty() ) {
					domainFrame->iMulti[i]->setText(tmpStr);
				}
			}
		  }
		}

	config->setGroup("ScheduleFrame");

		tmpBool = config->readBoolEntry("Schedule", false );
		if ( tmpBool ) {
			scheduleFrame->schedBox->setChecked(true);
			tmpInt = config->readNumEntry("AfterHour", 0 );
				scheduleFrame->afterHourSpBox->setValue(tmpInt);
			tmpBool = config->readBoolEntry("ShowIt", false );
			if ( tmpBool ) {
				scheduleFrame->schedOutputBox->setChecked(true);
			}
			tmpBool = config->readBoolEntry("Hourly", false );
			if ( tmpBool ) {
				scheduleFrame->hourlyBut->setChecked(true);
				scheduleFrame->setHourlyOptions();
			}
			tmpBool = config->readBoolEntry("Daily", false );
			if ( tmpBool ) {
				scheduleFrame->dailyBut->setChecked(true);
				scheduleFrame->setDailyOptions();
			}
			tmpBool = config->readBoolEntry("Weekly", false );
			if ( tmpBool ) {
				scheduleFrame->weeklyBut->setChecked(true);
				scheduleFrame->setWeeklyOptions();
			}
			tmpBool = config->readBoolEntry("Monthly", false );
			if ( tmpBool ) {
				scheduleFrame->monthlyBut->setChecked(true);
				scheduleFrame->setMonthlyOptions();
			}
			tmpInt = config->readNumEntry("StartTimeH", 12 );
				scheduleFrame->hourSpBox->setValue(tmpInt);
			tmpInt = config->readNumEntry("StartTimeM", 12 );
				scheduleFrame->minSpBox->setValue(tmpInt);
			
			tmpBool = config->readBoolEntry("AM", true );
			if ( tmpBool )
				scheduleFrame->amBut->setChecked(true);
			tmpBool = config->readBoolEntry("PM", false );
			if ( tmpBool )
				scheduleFrame->pmBut->setChecked(true);
			tmpBool = config->readBoolEntry("Mon", false );
			if ( tmpBool )
				scheduleFrame->monBut->setChecked(true);
			tmpBool = config->readBoolEntry("Tue", false );
			if ( tmpBool )
				scheduleFrame->tueBut->setChecked(true);
			tmpBool = config->readBoolEntry("Wed", false );
			if ( tmpBool )
				scheduleFrame->wedBut->setChecked(true);
			tmpBool = config->readBoolEntry("Thu", false );
			if ( tmpBool )
				scheduleFrame->thuBut->setChecked(true);
			tmpBool = config->readBoolEntry("Fri", false );
			if ( tmpBool )
				scheduleFrame->friBut->setChecked(true);
			tmpBool = config->readBoolEntry("Sat", false );
			if ( tmpBool )
				scheduleFrame->satBut->setChecked(true);
			tmpBool = config->readBoolEntry("Sun", false );
			if ( tmpBool )
				scheduleFrame->sunBut->setChecked(true);
			tmpInt = config->readNumEntry("DayOfMonth", 0 );
				scheduleFrame->monthSpBox->setValue(tmpInt);
			tmpBool = config->readBoolEntry("SchedCount", false );
			if ( tmpBool )
				scheduleFrame->schedCountBox->setChecked(true);
			tmpInt = config->readNumEntry("SchedNum", 1 );
				scheduleFrame->schedCountSpBox->setValue(tmpInt);
			scheduleFrame->enableSched();
			scheduleFrame->enableCount();
		}
		
		config->setGroup("FileFrame");
		
		tmpBool = config->readBoolEntry("GetAllFiles", true);
		if ( tmpBool ) {
			getAllTypes->setChecked(true);
		} else {
			getSelTypes->setChecked(true);
			getAllFileTypes();
			tmpBool = config->readBoolEntry("GetTypes", true);
				if ( tmpBool ) {
					fileFrame->getBut->setChecked(true);
					fileFrame->rejBut->setChecked(false);
				} else {
					fileFrame->rejBut->setChecked(true);
					fileFrame->getBut->setChecked(false);
				}
			tmpBool = config->readBoolEntry("jpg", false);
				if ( tmpBool )
					fileFrame->imgFrame->jpgBox->setChecked(true);
			tmpBool = config->readBoolEntry("jpeg", false);
				if ( tmpBool )
					fileFrame->imgFrame->jpegBox->setChecked(true);
			tmpBool = config->readBoolEntry("gif", false);
				if ( tmpBool )
					fileFrame->imgFrame->gifBox->setChecked(true);
			tmpBool = config->readBoolEntry("bmp", false);
				if ( tmpBool )
					fileFrame->imgFrame->bmpBox->setChecked(true);
			tmpBool = config->readBoolEntry("png", false);
				if ( tmpBool )
					fileFrame->imgFrame->pngBox->setChecked(true);
			tmpBool = config->readBoolEntry("xpm", false);
				if ( tmpBool )
					fileFrame->imgFrame->xpmBox->setChecked(true);
			tmpBool = config->readBoolEntry("pnm", false);
				if ( tmpBool )
					fileFrame->imgFrame->pnmBox->setChecked(true);
					
			tmpBool = config->readBoolEntry("wav", false);
				if ( tmpBool )
					fileFrame->audFrame->wavBox->setChecked(true);
			tmpBool = config->readBoolEntry("mid", false);
				if ( tmpBool )
					fileFrame->audFrame->midBox->setChecked(true);
			tmpBool = config->readBoolEntry("snd", false);
				if ( tmpBool )
					fileFrame->audFrame->sndBox->setChecked(true);
			tmpBool = config->readBoolEntry("mp2", false);
				if ( tmpBool )
					fileFrame->audFrame->mp2Box->setChecked(true);
			tmpBool = config->readBoolEntry("mp3", false);
				if ( tmpBool )
					fileFrame->audFrame->mp3Box->setChecked(true);
			tmpBool = config->readBoolEntry("aiff", false);
				if ( tmpBool )
					fileFrame->audFrame->aiffBox->setChecked(true);
			tmpBool = config->readBoolEntry("ram", false);
				if ( tmpBool )
					fileFrame->audFrame->ramBox->setChecked(true);

			tmpBool = config->readBoolEntry("mov", false);
				if ( tmpBool )
					fileFrame->vidFrame->movBox->setChecked(true);
			tmpBool = config->readBoolEntry("mpg", false);
				if ( tmpBool )
					fileFrame->vidFrame->mpgBox->setChecked(true);
			tmpBool = config->readBoolEntry("mpeg", false);
				if ( tmpBool )
					fileFrame->vidFrame->mpegBox->setChecked(true);
			tmpBool = config->readBoolEntry("rm", false);
				if ( tmpBool )
					fileFrame->vidFrame->rmBox->setChecked(true);
			tmpBool = config->readBoolEntry("avi", false);
				if ( tmpBool )
					fileFrame->vidFrame->aviBox->setChecked(true);
			tmpBool = config->readBoolEntry("qt", false);
				if ( tmpBool )
					fileFrame->vidFrame->qtBox->setChecked(true);
		
			tmpBool = config->readBoolEntry("txt", false);
				if ( tmpBool )
					fileFrame->txtFrame->txtBox->setChecked(true);
			tmpBool = config->readBoolEntry("doc", false);
				if ( tmpBool )
					fileFrame->txtFrame->docBox->setChecked(true);
			tmpBool = config->readBoolEntry("html", false);
				if ( tmpBool )
					fileFrame->txtFrame->htmlBox->setChecked(true);
			tmpBool = config->readBoolEntry("htm", false);
				if ( tmpBool )
					fileFrame->txtFrame->htmBox->setChecked(true);
			tmpBool = config->readBoolEntry("shtml", false);
				if ( tmpBool )
					fileFrame->txtFrame->shtmlBox->setChecked(true);
			tmpBool = config->readBoolEntry("asp", false);
				if ( tmpBool )
					fileFrame->txtFrame->aspBox->setChecked(true);
			tmpBool = config->readBoolEntry("pdf", false);
				if ( tmpBool )
					fileFrame->txtFrame->pdfBox->setChecked(true);

			tmpBool = config->readBoolEntry("zip", false);
				if ( tmpBool )
					fileFrame->othFrame->zipBox->setChecked(true);
			tmpBool = config->readBoolEntry("bz2", false);
				if ( tmpBool )
					fileFrame->othFrame->bz2Box->setChecked(true);
			tmpBool = config->readBoolEntry("exe", false);
				if ( tmpBool )
					fileFrame->othFrame->exeBox->setChecked(true);
			tmpBool = config->readBoolEntry("gz", false);
				if ( tmpBool )
					fileFrame->othFrame->gzBox->setChecked(true);
			tmpBool = config->readBoolEntry("rpm", false);
				if ( tmpBool )
					fileFrame->othFrame->rpmBox->setChecked(true);
			tmpBool = config->readBoolEntry("rar", false);
				if ( tmpBool )
					fileFrame->othFrame->rarBox->setChecked(true);
			tmpBool = config->readBoolEntry("tar", false);
				if ( tmpBool )
					fileFrame->othFrame->tarBox->setChecked(true);
			tmpBool = config->readBoolEntry("ace", false);
				if ( tmpBool )
					fileFrame->othFrame->aceBox->setChecked(true);
			tmpBool = config->readBoolEntry("deb", false);
				if ( tmpBool )
					fileFrame->othFrame->debBox->setChecked(true);

			QString self, selfBox;
			for ( int i=1; i <= 18; i++) {
				self.sprintf("self%d", i);
				selfBox.sprintf("selfBox%d", i);
				tmpStr = config->readEntry(self, "");
					if ( !tmpStr.isEmpty() ) {
						fileFrame->othFrame->newftLine[i]->setText(tmpStr);
					}
				tmpBool = config->readBoolEntry(selfBox, false);
					if ( tmpBool )
						fileFrame->othFrame->newftBox[i]->setChecked(true);
					else
						fileFrame->othFrame->newftBox[i]->setChecked(false);
			}
		}
	}
}

void KWebGet::startWGet()
{
	QString tmp, tmp2, tmp3, rtrn;
	tmp = mainFrame->outLine->text();
	if ( tmp.isEmpty() )
	{
		QMessageBox::warning(this, i18n("Missing folder"),
					i18n("You have not entered a projectfolder !"));
		return;
	}
	projDir = tmp;
	projDir.convertToAbs();
	if ( !projDir.exists() ) {
		switch (QMessageBox::warning(this, i18n("Wrong folder"),
					i18n("The projectfolder you have entered\n"
					"doesn't exist !\n"
					"Should I try to create it now ?"),
					i18n("Yes"), i18n("No"),0,0,1) )
		{
			case 0:
				projDir.mkdir(tmp);
				if ( !projDir.exists() ) {
					QMessageBox::warning(this, i18n("Error"),
							i18n("It seems, that you have no permissions,\n"
							"to create the projectfolder, or the path, you've given\n"
							"is wrong !\n"
							"Please try again !"));
					return;
				}
				break;
			case 1:
				return;
		}
	}
	
	if ( scheduleFrame->weeklyBut->isChecked() ) {
		if ( ( !scheduleFrame->monBut->isChecked() )&&
			 ( !scheduleFrame->tueBut->isChecked() )&&
			 ( !scheduleFrame->wedBut->isChecked() )&&
			 ( !scheduleFrame->thuBut->isChecked() )&&
			 ( !scheduleFrame->friBut->isChecked() )&&
			 ( !scheduleFrame->satBut->isChecked() )&&
			 ( !scheduleFrame->sunBut->isChecked() ) ) {
		 	QMessageBox::warning(this, i18n("Scheduler-Error"),
		 		i18n("You have to select at leats one day,\n"
		 		"to run the scheduler weekly !"));
		 	return;
		}
	}

	killed = false;		// Nobody has killed wget, at this point

	wgetopt = getWgetOptions();
	if ( wgetopt == "NO URL" ) {
		QMessageBox::warning( this, i18n("Missing URL !"),
			i18n("You have not entered a URL !"));
			return;
	} else if ( wgetopt == "NO FILENAME" ) {
		QMessageBox::warning( this, i18n("Missing Filename !"),
			i18n("You have choosen to get only one file,\n"
			"but you have not entered the name of the file !"));
			return;
	}

	if ( scheduleFrame->schedBox->isChecked() ) {
		switch(QMessageBox::warning(this, i18n("Start Scheduler ?"),
			i18n("Should I start the Scheduler, now ?"),
			i18n("Yes"), i18n("No"), 0,0,1) ) {
			case 0:
				prepareScheduler();
				break;
			case 1:
				return;
				break;
		}
	} else {
		letItRoll();
	}
}

QString KWebGet::getWgetOptions()
{
	QString tmp, tmp2;
	QString list = 0;

// Set wget-Path
	if ( wgetBin.isEmpty() )
		list += " wget -c";
	else {
		list += wgetBin;
		list += " -c";
	}
// Set the User-Agent
		list += " -U ";
	if ( mainFrame->wgetBut->isChecked() )
		list += "Wget";
	else if ( mainFrame->mozilla47But->isChecked() )
		list += "Mozilla/4.7";
	else if ( mainFrame->mozilla50But->isChecked() )
		list += "Mozilla/5.0";
	else if ( mainFrame->msieBut->isChecked() )
		list += "MSIE/5.0";
	else if ( mainFrame->konqBut->isChecked() )
		list += "Konqueror/1.1.1";
	else if ( mainFrame->lynxBut->isChecked() )
		list += "Lynx/TextBrowser";
	else if ( mainFrame->otherBut->isChecked() )
		list += mainFrame->otherLine->text();
// Set Retry-options
	if ( optFrame->retryBox->isChecked() ) {
		list += " -t ";
		list += optFrame->numRetryBox->text();
		list += " -w ";
		list += optFrame->waitRetryBox->text();
	}
// Set Recursive-Options
	if ( optFrame->recursiveBox->isChecked() ) {
		list += " -r -l ";
		list += optFrame->levSpBox->text();
	}
// Set timeout-Options
	tmp = mainFrame->protBox->currentText();
	if (( optFrame->timeoutBox->isChecked() )&&( tmp != "ftp://" )) {
		list += " -T ";
		list += optFrame->timeoutSpBox->text();
	}
// Set Quota-Options
	if ( optFrame->quotaBox->isChecked() ) {
		list += " -Q ";
		int qtmp = optFrame->quotaSpBox->value();
		qtmp = (( qtmp *1024 )*1024);
		tmp.sprintf("%d", qtmp);
		list += tmp;
	}
// Set Logfile-Option
	if ( optFrame->logBox->isChecked() ) {
		writeLog = true;
//		list += " -o kwebget.log";
	}
// Set NoClubber-Option
	if ( optFrame->noclubBox->isChecked() )
		list += " -nc";
// Set TimeStamp-Option
	if ( optFrame->timestampBox->isChecked() )
		list += " -N";
// Set Folder-Option
	if ( optFrame->folderBox->isChecked() )
		list += " -nd";
// Set NoHostDirectory-Option	
	if ( optFrame->nohostBox->isChecked() )
		list += " -nH";
// Set force-Directory-Option
	if ( optFrame->forcedirBox->isChecked() )
		list += " -x";
// Set ServerAnswer-options
	if ( optFrame->serveranswerBox->isChecked() )
		list += " -S";
// Set NoDNS-Option
	if ( optFrame->nodnsBox->isChecked() )
		list += " -nh";
// Set Cache-Option
	if ( !optFrame->cacheBox->isChecked() )
		list += " --cache=off";
// Set follow Ftp-option
	if ( optFrame->followftpBox->isChecked() )
		list += " --follow-ftp";
// Set Spider-Option
	if ( optFrame->spiderBox->isChecked() )
		list += " --spider";
// Set Link-Conversion-option
	if ( optFrame->convlinkBox->isChecked() )
		list += " -k";
// Set Passive-Ftp-option
	if ( optFrame->passFtpBox->isChecked() )
		list += " -e passive_ftp=on";
	else
		list += " -e passive_ftp=off";
// Set Http-Login and Password
	if ( passFrame->httploginBox->isChecked() ) {
		list += " --http-user=";
		list += passFrame->httpusrLine->text();
		list += " --http-passwd=";
		list += passFrame->httppassLine->text();
	}
// Set Proxy-Option
	
	if (( proxyFrame->httpProxyBox->isChecked() )||(proxyFrame->ftpProxyBox->isChecked() ))
		list += " --proxy=on";
	else
		list += " --proxy=off";
	
	if ( proxyFrame->httpProxyBox->isChecked() ) {
		list += " -e http_proxy=";
		list += proxyFrame->httpProxyAdressLine->text();
		list += ":";
		list += proxyFrame->httpProxyPortLine->text();
	}

	if ( proxyFrame->ftpProxyBox->isChecked() ) {
		list += " -e ftp_proxy=";
		list += proxyFrame->ftpProxyAdressLine->text();
		list += ":";
		list += proxyFrame->ftpProxyPortLine->text();
	}
// Set email-adress as password for anonymous ftp
	tmp = mainFrame->protBox->currentText();
	if ((( tmp == "ftp://" )&&( passFrame->ftpanonBox->isChecked() ) )||
		( mainFrame->urllistBut->isChecked() )) {
		list += " -e passwd=";
		list += passFrame->ftppassLine->text();
	}
//Set Proxy-Username and Password
	if ( proxyFrame->httpProxyloginBox->isChecked() ) {
		list += " --proxy-user=";
		list += proxyFrame->httpProxyusrLine->text();
		list += " --proxy-passwd=";
		list += proxyFrame->httpProxypassLine->text();
	}

// And now I need to know, if the user wants to get all files, or just some filetypes ...
	if ( (!getAllTypes->isChecked() )&&( !mainFrame->fileBut->isChecked() )) {
	  if ( fileFrame->getBut->isChecked() ) {
		tmp = fileFrame->whatToGet();
		list += " --accept=";
		list += tmp;
	  } else {
		tmp = fileFrame->whatToGet();
		list += " --reject=";
		list += tmp;
	  }
	}

// And the last thing to get for now, is the list of in- or excluded domains
	if ( !getAllDomains->isChecked() ) {
		if ( domainFrame->includeBut->isChecked() ) {
			tmp = domainFrame->whatToInExclude();
			if ( !tmp.isEmpty() ) {
			  list += " --domains=";
			  list += tmp;
			}
		} else {
			tmp = domainFrame->whatToInExclude();
			if ( !tmp.isEmpty() ) {
			  list += " --exclude-domains=";
			  list += tmp;
			}
		}
	 }

	if ( mainFrame->urllistBut->isChecked() ) {
		list += " -i ";
		writeListFile();
		tmp = "/tmp/~urllist";
		list += tmp;
	} else {
// Set protocol
	list += " ";
	list += mainFrame->protBox->currentText();

// Set FTP-Login
	tmp = mainFrame->protBox->currentText();
	 if (( tmp == "ftp://" )&&( !passFrame->ftpanonBox->isChecked() )){
		tmp2 = passFrame->ftppassLine->text();
		tmp2.replace( QRegExp("@"), "_" );
		tmp = passFrame->ftpusrLine->text();
		if ( ( !tmp.isEmpty() )||( !tmp2.isEmpty() ) ) {
			list += passFrame->ftpusrLine->text();
			list += ":";
			list += tmp2;
			list += "@";
		}
	}
// Set URL
	tmp = mainFrame->htmlLine->text();
	if ( tmp.isEmpty() ) {
		list = "NO URL";
		return list;
	} else {
		tmp2 = tmp.right(1);
		if ( tmp2 != "/" )
			tmp += "/";
		list += tmp;
	}
// Set Filename ( if get just one File is choosen!)
	if ( !mainFrame->htmlBut->isChecked() ) {
		tmp = mainFrame->urlLine->text();
		if ( tmp.isEmpty() ) {
			list = "NO FILENAME";
			return list;
		} else {
			list += tmp;
		}
	}
	}
	return list;   // Give Back the whole Options-String :-)
}

void KWebGet::giveBackStdoutErr(KProcess *proc, char *buffer, int buflen)
{
  if ( killed ) {
  	killed = false;
  	return;
  }
  // copy data to I/O buffer
  int len = strlen(iBuffer);
  memcpy(iBuffer + len, buffer, buflen);
  iBuffer[len + buflen] = 0;

  // split buffer: too expensive, improve
  char *p;
  while(( p = strchr(iBuffer, '\n')) != 0) {
    *p = 0;

    // Write buffer to the outputscreen if optframe->output = 1
    if ( optFrame->output ) {
		outputWidget->outScreen->insertLine(iBuffer, -1);
		if ( scrollIt )
			outputWidget->outScreen->setCursorPosition(outputWidget->outScreen->numLines(),0,0);
	}
	if ( writeLog ) {
		if ( !logFile.open( IO_WriteOnly | IO_Append )){
			writeLog = false;
			QMessageBox::warning(this, i18n("Log-File-Error "),
				i18n("An error occured while trying\n"
				"to write the Log-File !\n"
				"Logging is disabled now, sorry"));
		}
		logFile.writeBlock(iBuffer, strlen(iBuffer));
		logFile.writeBlock(term, strlen(term));
		logFile.close();
	}
    memmove(iBuffer, p+1, strlen(p + 1)+1);
  }
}

void KWebGet::cancelWget()
{
	if ( wget->isRunning() ) {
		disconnect(wget, SIGNAL(receivedStdout(KProcess *, char *, int)),
			this, SLOT(giveBackStdoutErr(KProcess *, char *, int)));
		disconnect(wget, SIGNAL(receivedStderr(KProcess *, char *, int)),
			this, SLOT(giveBackStdoutErr(KProcess *, char *, int)));
	}
	switch ( QMessageBox::warning( this, i18n("Cancel ?"),
				i18n("Do you really want to stop the process ?"),
				i18n("Yes"), i18n("No"),0,0,1) )
	{
		case 0:
			if ( wget->isRunning() ) {
					if ( scheduling ) {
						if (QMessageBox::warning(outputWidget, i18n("Stop scheduler ?"),
						i18n("Do you want to exit the schduler ?"),
						i18n("Yes"), i18n("No"), 0,0,1 ) == 0 )
						{
							killTimers();
							scheduling = false;
							delete(schedIcon);
//							wget->kill(SIGTERM);
							wget->kill(SIGKILL);
							killed = true;
							this->show();
						} else {
//							wget->kill(SIGTERM);
							wget->kill(SIGKILL);
							killed = true;
						}
					} else {
//						wget->kill(SIGTERM);
						wget->kill(SIGKILL);
						killed = true;		// Now it's done
					}
				} else {
					QMessageBox::information(this, i18n("Project completed !"),
						i18n("The Project is completed !"));
				}
			connect(wget, SIGNAL(receivedStdout(KProcess *, char *, int)),
					this, SLOT(giveBackStdoutErr(KProcess *, char *, int)));
			connect(wget, SIGNAL(receivedStderr(KProcess *, char *, int)),
				this, SLOT(giveBackStdoutErr(KProcess *, char *, int)));
					outputWidget->outCancel->hide();
					outputWidget->outDismiss->show();
					outputWidget->repaint();
				break;
		case 1:
			connect(wget, SIGNAL(receivedStdout(KProcess *, char *, int)),
					this, SLOT(giveBackStdoutErr(KProcess *, char *, int)));
			connect(wget, SIGNAL(receivedStderr(KProcess *, char *, int)),
				this, SLOT(giveBackStdoutErr(KProcess *, char *, int)));
			return;
			break;
	}
}

void KWebGet::dismissWget()
{
	if ( wizOnStartup ) {
		switch ( QMessageBox::warning(this, i18n("Exit KWebGet ?"),
			i18n("Do you want to exit KWebGet, now ?"),
			i18n("Yes"), i18n("Run Wizard again"), i18n("Start Advanced"),0,1))
		{
			case 0:
				exit(0);
				break;
			case 1:
				delete(wizard);
				delete(outputWidget);
				startWizard();
				break;
			case 2:
				delete(wizard);
				delete(outputWidget);
				wizOnStartup = false;
				this->show();
				break;
		}
	} else {
		delete(outputWidget);
	}
}

void KWebGet::wgetReady(KProcess *proc)
{
	if (( !scheduling )&&( killed )) {
		QFile urllist ("/tmp/~urllist");
		if ( urllist.exists() )
			urllist.remove();
	}
	outputWidget->killTimers();
	outputWidget->statPixLab->setPixmap(outputWidget->stopPix);
	outputWidget->outCancel->hide();
	outputWidget->outDismiss->show();
	outputWidget->repaint();
	acc = new QAccel(outputWidget);
	acc->connectItem( acc->insertItem(Key_Return),this, SLOT(dismissWget()) );

	kapp->beep();
	if ( !killed ) {
		outputWidget->outScreen->insertLine(i18n("\nKWebGet - Project completed"
				" successfully !!!"), -1);
		outputWidget->outScreen->setCursorPosition(outputWidget->outScreen->numLines(),0,0);
	} else {
		outputWidget->outScreen->insertLine(i18n("\nKWebGet - Project canceled"
				" by user !!!"), -1);
		outputWidget->outScreen->setCursorPosition(outputWidget->outScreen->numLines(),0,0);
	}
	killed = false; 		// Nothing can happen now - wget is ready to go further
	outputWidget->setCaption(i18n("KWebGet-0.5"));
	if ( scheduling ) {
		disconnect(wget, SIGNAL(receivedStdout(KProcess *, char *, int)),
			this, SLOT(giveBackStdoutErr(KProcess *, char *, int)));
		disconnect(wget, SIGNAL(receivedStderr(KProcess *, char *, int)),
			this, SLOT(giveBackStdoutErr(KProcess *, char *, int)));
		disconnect(wget, SIGNAL(processExited(KProcess *)), this, SLOT(wgetReady(KProcess *)));
		delete(acc);
		delete(outputWidget);
		schedIcon->setActive(false);
		schedIcon->schedPop->setItemEnabled(schedIcon->menupunkt[2], false);
		
		// If the number of schedule-job's is reached, stop it imediatly
		if ( scheduleFrame->schedCountBox->isChecked() ) {
			if ( scheduleCount >= schedNums ) {
				scheduling = false;
				this->show();
				killTimers();
				schedIcon->schedPop->disconnectItem(schedIcon->menupunkt[0], this, SLOT(cancelScheduler()));
				schedIcon->schedPop->disconnectItem(schedIcon->menupunkt[1], this, SLOT(showSchedInfo()));
				schedIcon->schedPop->disconnectItem(schedIcon->menupunkt[2], this, SLOT(showSchedOutput()));
				delete(schedIcon);
				scheduleCount = 0;
				QMessageBox::information(this, i18n("Scheduling exited"),
						i18n("The scheduling-process\n"
							  "is done !"));
				return;
			}
		}
	}
}

void KWebGet::writeListFile()
{
	QString tmp, tmp2;
	QFile listFile ("/tmp/~urllist");
	if ( !listFile.open( IO_WriteOnly | IO_Append )){
		QMessageBox::warning(this, i18n("IO-Error"),
			i18n("An error occured, while trying to read the list of urls.\n"
			"Please make sure, that you have read/write-permissions,\n"
			"to files in the /tmp-directory and try again !!!"));
			return;
	} else {
		for ( int i=0; i <= mainFrame->listWidg->addNum ; i++) {
			tmp = mainFrame->listWidg->protChoose[i]->currentText();
			tmp += mainFrame->listWidg->siteLine[i]->text();
			listFile.writeBlock(tmp, strlen(tmp));
			listFile.writeBlock(term, strlen(term));
		}
		listFile.close();
	}
}

void KWebGet::autoScroll()
{
	if ( outputWidget->noScroll->isChecked() )
		scrollIt = true;
	else
		scrollIt = false;
}

// If everything is OK with the Setup, 'wget' can be started, and the logfile can created
void KWebGet::letItRoll()
{
/*	If everything is ok with the output-Directory, it's time to create an output-Widget
	and disable all other widgets :-) */

	outputWidget = new OutputWidget(this, "OutputDialog", true,0);
	connect(outputWidget->outDismiss, SIGNAL(clicked()), this, SLOT(dismissWget()));
	connect(outputWidget->outCancel, SIGNAL(clicked()), this, SLOT(cancelWget()));
	connect(outputWidget->noScroll, SIGNAL(clicked()), this, SLOT(autoScroll()));
	outputWidget->setFixedSize(600,300);
	outputWidget->setCaption(i18n("KWebGet - Work in Process ..."));
	outputWidget->move(this->pos().x(), this->pos().y()+50);
	outputWidget->getSchedInfo( scheduleFrame->schedBox->isChecked() );

	QString tmp, tmp2, tmp3;
	// Change Working directory to the ProjectDirectory
	QDir::setCurrent(projDir.absPath());
	tmp = wgetopt;
	if ( writeLog ) {
		tmp2 = projDir.absPath();
		tmp3 = tmp2.right(1);
		if ( tmp3 == "/" )
			tmp2 += "kwebget.log";
		else
			tmp2 += "/kwebget.log";
		logFile.setName(tmp2);
		if ( !logFile.open( IO_WriteOnly )){
			writeLog = false;
			QMessageBox::warning(this, i18n("Log-File-Error "),
				i18n("An error occured while trying\n"
				"to write the Log-File !\n"
				"Logging is disabled now, sorry"));
		}
		tmp3 = "----KWebGet - Logfile-------\n";
		logFile.writeBlock(tmp3, strlen(tmp3));
		logFile.close();
	}
	outputWidget->startTimer(60);
	//Ok, lets start the process .

	delete(wget);
	wget = new KShellProcess("/bin/sh");
	(*wget) << tmp;
	connect(wget, SIGNAL(receivedStdout(KProcess *, char *, int)),
			this, SLOT(giveBackStdoutErr(KProcess *, char *, int)));
	connect(wget, SIGNAL(receivedStderr(KProcess *, char *, int)),
			this, SLOT(giveBackStdoutErr(KProcess *, char *, int)));
	connect(wget, SIGNAL(processExited(KProcess *)), this, SLOT(wgetReady(KProcess *)));

	wget->start( KProcess::NotifyOnExit ,KProcess::AllOutput );

	if ( !scheduling )
		outputWidget->show();
	else if (( scheduling )&&( scheduleFrame->schedOutputBox->isChecked() )) {
		outputWidget->show();
	} else {
	schedIcon->schedPop->setItemEnabled(schedIcon->menupunkt[2], false);
	}
}

// This function will test the schedule-settings and call the Scheduler, if no errors
void KWebGet::prepareScheduler()
{
	scheduleCount = 0;
	if ( scheduleFrame->schedCountBox->isChecked() )
		schedNums = scheduleFrame->schedCountSpBox->value();
	if ( scheduleFrame->hourlyBut->isChecked() ) {
		afterHour = scheduleFrame->afterHourSpBox->value();
		scheduleTime = hourly;
		startScheduler();
	} else if ( scheduleFrame->dailyBut->isChecked() ) {
		schedHour = scheduleFrame->hourSpBox->value();
		if ( scheduleFrame->pmBut->isChecked() ) {
			schedHour = schedHour+12;
		}
		schedMinute = scheduleFrame->minSpBox->value();
		scheduleTime = daily;
		startScheduler();
	} else if ( scheduleFrame->weeklyBut->isChecked() ) {
		schedHour = scheduleFrame->hourSpBox->value();
		if ( scheduleFrame->pmBut->isChecked() ) {
			schedHour = schedHour+12;
		}
		schedMinute = scheduleFrame->minSpBox->value();
		scheduleTime = weekly;
		if ( scheduleFrame->monBut->isChecked() )
			days[1] = 1;
		else
			days[1] = 0;
		if ( scheduleFrame->tueBut->isChecked() )
			days[2] = 2;
		else
			days[2] = 0;
		if ( scheduleFrame->wedBut->isChecked() )
			days[3] = 3;
		else
			days[3] = 0;
		if ( scheduleFrame->thuBut->isChecked() )
			days[4] = 4;
		else
			days[4] = 0;
		if ( scheduleFrame->friBut->isChecked() )
			days[5] = 5;
		else
			days[5] = 0;
		if ( scheduleFrame->satBut->isChecked() )
			days[6] = 6;
		else
			days[6] = 0;
		if ( scheduleFrame->sunBut->isChecked() )
			days[7] = 7;
		else
			days[7] = 0;
		startScheduler();
	} else if ( scheduleFrame->monthlyBut->isChecked() ) {
		schedMonth = scheduleFrame->monthSpBox->value();
		schedHour = scheduleFrame->hourSpBox->value();
		if ( scheduleFrame->pmBut->isChecked() ) {
			schedHour = schedHour+12;
		}
		schedMinute = scheduleFrame->minSpBox->value();
		scheduleTime = monthly;
		startScheduler();
	}
}

void KWebGet::startScheduler()
{
	schedIcon = new KScheduleIcon();
	schedIcon->schedPop->connectItem(schedIcon->menupunkt[0], this, SLOT(cancelScheduler()));
	schedIcon->schedPop->connectItem(schedIcon->menupunkt[1], this, SLOT(showSchedInfo()));
	schedIcon->schedPop->connectItem(schedIcon->menupunkt[2], this, SLOT(showSchedOutput()));
	schedIcon->schedPop->setItemEnabled(schedIcon->menupunkt[2], false);
	QToolTip::add(schedIcon, i18n("KWebGet-Scheduler"));
	schedIcon->setActive(false);

	schedIcon->show();

	this->hide();

	// First run the Timer once
	cnt = 1;
	startTimer(1000);
}

void KWebGet::timerEvent(QTimerEvent *ev)
{
	// This is needed to start the timer imediatly, when the scheduler is startet
	if ( cnt == 1 ) {
		// After the first timer, kill it ...
		killTimers();
		// and start the timer minutly
		startTimer(60000);
	}
	cnt = 0;

	switch ( scheduleTime )
	{
// ------------ HOURLY-SCHEDULER --------------
		case hourly:
			 if ( !wget->isRunning() ){
				if ( checkMinute() == afterHour ) {
					scheduleCount++;
					scheduling = true;
					letItRoll();
					schedIcon->setActive(true);
					schedIcon->schedPop->setItemEnabled(schedIcon->menupunkt[2], true);
				}
			} else {
				return;
			}
			break;
// ------------ DAILY-SCHEDULER ----------------
		case daily:
			 if ( !wget->isRunning() ){
				if ( checkHour() == schedHour ) {
					if ( checkMinute() == schedMinute ) {
						scheduleCount++;
						scheduling = true;
						letItRoll();
						schedIcon->setActive(true);
						schedIcon->schedPop->setItemEnabled(schedIcon->menupunkt[2], true);
					}
				}
			} else {
				return;
			}
			break;
// ------------ WEEKLY-SCHEDULER -----------
		case weekly:
			 if ( !wget->isRunning() ){
			 	if (( checkDay() == days[1] )||( checkDay() == days[2] )||
					( checkDay() == days[3] )||( checkDay() == days[4] )||
					( checkDay() == days[5] )||( checkDay() == days[6] )||
					( checkDay() == days[7] )) {
					if ( checkHour() == schedHour ) {
						if ( checkMinute() == schedMinute ) {
							scheduleCount++;
							scheduling = true;
							letItRoll();
							schedIcon->schedPop->setItemEnabled(schedIcon->menupunkt[2], true);
							schedIcon->setActive(true);
						}
					}
				}
			} else {
				return;
			}
			break;
// ------------ MONTHLY-SCHEDULER -----------
		case monthly:
			 if ( !wget->isRunning() ){
			 	if ( checkMonth() == schedMonth ) {
					if ( checkHour() == schedHour ) {
						if ( checkMinute() == schedMinute ) {
							scheduleCount++;
							scheduling = true;
							letItRoll();
							schedIcon->schedPop->setItemEnabled(schedIcon->menupunkt[2], true);
							schedIcon->setActive(true);
						}
					}
				}
			} else {
				return;
			}
			break;
	}
}

int KWebGet::checkMinute()
{
	QTime time;
	return time.currentTime().minute();
}

int KWebGet::checkHour()
{
	QTime time;
	return time.currentTime().hour();
}

int KWebGet::checkDay()
{
	QDate date;
	return date.currentDate().dayOfWeek();
}

int KWebGet::checkMonth()
{
	QDate date;
	return date.currentDate().day();
}

void KWebGet::cancelScheduler()
{
	if ( wget->isRunning() ) {
		cancelWget();
	} else {
		switch (QMessageBox::warning(this, i18n("Stop scheduler ?"),
			i18n("Do you really want to exit the schduler ?"),
			i18n("Yes"), i18n("No"), 0,0,1 ))
			{
			  case 0:
				killTimers();
				this->show();
				scheduleCount = schedNums;
				scheduling = false;
				delete(schedIcon);
				break;
			  case 1:
				return;
				break;
			}
	}
}

void KWebGet::showSchedInfo()
{
	QString status, dateStr, time, nums, ap;
	QString month, day, minute;
	int hour;
	QDate date;
	bool hasDate;
	hasDate = false;
	int d = 0;
	if ( wget->isRunning() )
		status = i18n("activ");
	else
		status = i18n("inactiv");

	switch ( scheduleTime )
	{
		case hourly:
			if ( afterHour < 10 ) {
				minute.sprintf("0%d", afterHour);
			} else {
				minute.sprintf("%d", afterHour);
			}
			if ( checkHour() >= 12 ) {
				if ( checkHour() > 12 ) {
					hour = checkHour()-12;
					ap = "PM";
				} else {
					hour = checkHour();
					ap = "AM";
				}
			} else {
				hour = checkHour();
				ap = "AM";
			}
			if ( checkMinute() <= afterHour ) {
				time.sprintf(i18n("%s  %d:%s o'clock"),(const char*)ap, hour, (const char*)minute);
				dateStr = i18n(date.currentDate().toString() );
			} else {
				if ( (checkHour()+1) > 23 ) {
					dateStr = i18n(date.currentDate().addDays(1).toString() );
				} else {
					dateStr = i18n(date.currentDate().toString() );
				}
				if ( hour+1 > 12 ) {
					hour = 0;
					ap = "PM";
				}
				time.sprintf(i18n("%s  %d:%s o'clock"),(const char*)ap, (hour+1), (const char*)minute);
			}
			break;
//---------------------------------------------
		case daily:
			if ( schedMinute < 10 ) {
				minute.sprintf("0%d", schedMinute);
			} else {
				minute.sprintf("%d", schedMinute);
			}
			if ( schedHour > 12 ) {
				hour = schedHour-12;
				ap = "PM";
			} else {
				hour = schedHour;
				ap = "AM";
			}
			if ( checkHour() < schedHour ) {
				dateStr = i18n(date.currentDate().toString() );
			} else if (( checkHour() == schedHour )&&( checkMinute() <= schedMinute )){
				dateStr = i18n(date.currentDate().toString() );
			} else {
				dateStr = i18n(date.currentDate().addDays(1).toString() );
			}
			time.sprintf(i18n("%s  %d:%s o'clock"),(const char*)ap, hour, (const char*)minute);
			break;
//---------------------------
		case  weekly:
			if ( schedMinute < 10 ) {
				minute.sprintf("0%d", schedMinute);
			} else {
				minute.sprintf("%d", schedMinute);
			}
			if ( schedHour > 12 ) {
				hour = schedHour-12;
				ap = "PM";
			} else {
				ap = "AM";
				hour = schedHour;
			}

			for ( int i=1 ; i <= 7 ; i++) {
				if ( checkDay() == days[i] ) {
					if ( checkHour() < schedHour ) {
						dateStr = i18n(date.currentDate().toString() );
						hasDate = true;
					} else if (( checkHour() == schedHour )&&( checkMinute() <= schedMinute )) {
						dateStr = i18n(date.currentDate().toString() );
						hasDate = true;
					} else if ((checkHour() <= schedHour )&&( checkMinute() >= schedMinute )) {
						d = 0;
						for ( int j=i+1 ; j <= 7 ; j++) {
							d++;
							if ( j == days[j] ) {
								dateStr = i18n(date.currentDate().addDays(d).toString() );
								hasDate = true;
								break;
							}
						}
						if ( !hasDate ) {
							for ( int j=1 ; j <= i ; j++) {
								d++;
								if ( j == days[j] ) {
									dateStr = i18n(date.currentDate().addDays(d).toString() );
									hasDate = true;
									break;
								}
							}
						}
					} else if (checkHour() > schedHour ) {
						for ( int j=i+1 ; j <= 7 ; j++) {
							d++;
							if ( j == days[j] ) {
								dateStr = i18n(date.currentDate().addDays(d).toString() );
								hasDate = true;
								break;
							}
						}
						if ( !hasDate ) {
							for ( int j=1 ; j <= i ; j++) {
								d++;
								if ( j == days[j] ) {
									dateStr = i18n(date.currentDate().addDays(d).toString() );
									hasDate = true;
									break;
								}
							}
						}
					} // else if
				}
			}
				
			if ( !hasDate ) {
				d = 0;
				for ( int j=checkDay()+1 ; j <= 7 ; j++) {
					d++;
					if ( j == days[j] ) {
						dateStr = i18n(date.currentDate().addDays(d).toString() );
						hasDate = true;
						break;
					}
				}
				if ( !hasDate ) {
					for ( int j=1 ; j <= checkDay() ; j++) {
						d++;
						if ( j == days[j] ) {
							dateStr = i18n(date.currentDate().addDays(d).toString() );
							break;
						}
					}
				}
			}
			time.sprintf(i18n("%s  %d:%s o'clock"),(const char*)ap, hour, (const char*)minute);
			break;
//---------------------------
		case monthly:
			if ( schedMinute < 10 ) {
				minute.sprintf("0%d", schedMinute);
			} else {
				minute.sprintf("%d", schedMinute);
			}
			if ( schedHour > 12 ) {
				hour = schedHour-12;
				ap = "PM";
			} else {
				hour = schedHour;
				ap = "AM";
			}

			int daysLeft = 0;
			QDate maxdays, dateVal;
			int y, m;
			y = date.currentDate().year();
			m = date.currentDate().month();

			if ( maxdays.currentDate().daysInMonth() >= schedMonth ) {
				if ( checkMonth() < schedMonth ) {
					daysLeft = schedMonth-checkMonth();
					dateStr = i18n(date.currentDate().addDays(daysLeft).toString() );
				} else if ( checkMonth() == schedMonth ) {
					if ( checkHour() < schedHour ) {
						dateStr = i18n(date.currentDate().toString() );
					} else if ((checkHour() == schedHour)&&( checkMinute() <= schedMinute )) {
						dateStr = i18n(date.currentDate().toString() );
					} else {
						if ( m < 12 ) {
							if (dateVal.setYMD( y, (m+1) , schedMonth )) {
								dateStr = i18n(dateVal.toString() );
							} else if (dateVal.setYMD(y, (m+2) , schedMonth)){
							dateStr = i18n(dateVal.toString() );
							} else if (dateVal.setYMD(y, (m+3) , schedMonth)){
								dateStr = i18n(dateVal.toString() );
							}
						} else {
							if (dateVal.setYMD(y+1, 1 , schedMonth)){
								dateStr = i18n(dateVal.toString() );
							} else if (dateVal.setYMD(y+1, 2 , schedMonth)){
								dateStr = i18n(dateVal.toString() );
							}
						}
					}
				}  else if ( checkMonth() > schedMonth ) {
					if ( m < 12 ) {
						if (dateVal.setYMD( y, (m+1) , schedMonth )) {
							dateStr = i18n(dateVal.toString() );
						} else if (dateVal.setYMD(y, (m+2) , schedMonth)){
						dateStr = i18n(dateVal.toString() );
						} else if (dateVal.setYMD(y, (m+3) , schedMonth)){
							dateStr = i18n(dateVal.toString() );
						}
					} else {
						if (dateVal.setYMD(y+1, 1 , schedMonth)){
							dateStr = i18n(dateVal.toString() );
						} else if (dateVal.setYMD(y+1, 2 , schedMonth)){
							dateStr = i18n(dateVal.toString() );
						}
					}
				}
			} else {
				if ( m < 12 ) {
					if (dateVal.setYMD( y, (m+1) , schedMonth )) {
						dateStr = i18n(dateVal.toString() );
					} else if (dateVal.setYMD(y, (m+2) , schedMonth)){
						dateStr = i18n(dateVal.toString() );
					} else if (dateVal.setYMD(y, (m+3) , schedMonth)){
						dateStr = i18n(dateVal.toString() );
					}
				} else {
					if (dateVal.setYMD(y+1, 1 , schedMonth)){
						dateStr = i18n(dateVal.toString() );
					} else if (dateVal.setYMD(y+1, 2 , schedMonth)){
						dateStr = i18n(dateVal.toString() );
					}
				}
			}
			time.sprintf(i18n("%s  %d:%s o'clock"),(const char*)ap, hour, (const char*)minute);
			break;
	}
	if ( scheduleFrame->schedCountBox->isChecked() ) {
		nums.sprintf("%d", (schedNums-scheduleCount));
		if ( (schedNums-scheduleCount) == 0 ) {
			dateStr = i18n("-");
			time = i18n("");
			nums = i18n("none");
		}
	} else {
		nums = i18n("unlimited");
	}

	statusDialog = new StatusDialog(this,0, true);
	statusDialog->setFixedSize(300,155);
	statusDialog->setCaption(i18n("KWebGet-SchedulerInfo"));
	
	statusDialog->getInfo(status, dateStr, time, nums);
	
	statusDialog->show();
}

void KWebGet::showSchedOutput()
{
	outputWidget->show();
}