/***************************************************************************
    Description          : KPuzzle - A KDE Jigsaw Puzzle Game
    Version              : 0.2
    Copyright            : (C) 2000-2001 by Michael Wand
    EMail                : mwand@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPUZZLEWIDGET_H
#define KPUZZLEWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kstatusbar.h>
#include <ktmainwindow.h>

#include <qwidget.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qevent.h>
#include <qlcdnumber.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <qarray.h>
#include <qbitmap.h>

class KGameWidget;
class KPuzzleApp;
class CPieceWidget;
class CPicview;

// These game pixmaps may be used. Before any function uses one, it has to
// call useGamePixmap(int) to ensure the pixmap is available.
#define GP_BIGLOGO 0x1
#define GP_PAUSE 0x2
#define GP_WIN 0x4
#define GP_LOSE 0x8
#define GP_LOGO 0x10

class KPuzzleView : public QWidget
{
	Q_OBJECT
 public:
	KPuzzleView(QWidget *parent = 0, const char *name = 0);
	virtual ~KPuzzleView();

// Data
 public:
	int status();
// These functions all return pointers on widgets
	QLCDNumber* time() { return _time; }
	CPicview* picview() { return _picview; }
	CPicview* fullview() { return _fullview; }
	KGameWidget* gameWidget() { return _gameWidget; }
	CPieceWidget* pieceWidget() { return _pieceWidget; }
	KPuzzleApp* game() { return _game; }

	void setLargePxm(QPixmap* p) { _largePxm = p; }

// Load or unload game pixmaps. May have visible effect on slower computers
	void useGamePixmap(int which);
	void freeGamePixmap(int which);

 protected:
	KGameWidget* _gameWidget;
	QPushButton* _bLeft;
	QPushButton* _bRight;
	QPushButton* _bUp;
	QPushButton* _bDown;

	CPieceWidget* _pieceWidget;
	QPushButton* _bNextPiece;
	QPushButton* _bPrevPiece;
	QPushButton* _bTurn1;
	QPushButton* _bTurn2;

	CPicview* _picview;
	CPicview* _fullview;

	QLCDNumber* _score;
	QLCDNumber* _time;

	KPuzzleApp* _game;

	QPixmap* _largePxm;

	QPixmap* _logoPxm;
	QPixmap* _bigLogoPxm;
	QPixmap* _winPxm;
	QPixmap* _losePxm;
	QPixmap* _pausePxm;

	int _usedGamePixmaps;

 private:

// Implementation
 public:
// Updates game widget & piece widget
	void updateAll();
// Changes the status of the moving buttons
	void updateButtons(bool b1,bool b2,bool b3,bool b4);
/* 	void showStatusMsg(QString s) { ((KTMainWindow*) parentWidget())->statusBar()-> */
/* 							   message(s,time); } */
	void showStatusMsg(const QString s) { emit sigChangeStatusbar(s); }
	void hideStatusMsg() { ((KTMainWindow*) parentWidget())->statusBar()->clear(); }
// Create or destroy all widgets necessary during the game
	void createPlayground(bool unbearable);
	void destroyPlayground();
// Show/hide the widgets mentioned above
	void showAll(bool s);

 protected:
	virtual void paintEvent(QPaintEvent* e);
	virtual void mousePressEvent(QMouseEvent* e);

 signals:
	void sigChangeStatusbar(const QString&);

 public slots:
	void slotTerm(int reason);

 protected slots:
// Slot called on start after the basic work is done
	void slotLoadBackgroundPixmap();

};

#endif // KPUZZLEWIDGET_H
