/***************************************************************************
                          kbeartransferview.cpp  -  description
                             -------------------
    begin                : Wed Jun 28 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbeartransferview.h"
#include "kbeartransferviewitem.h"
//-----------------------------------------------
KBearTransferView::KBearTransferView(QWidget *parent, const char *name )
: KBearTreeView(parent,name)
{
	addColumn( i18n("Host") );
	addColumn( i18n("Source") );
	addColumn( i18n("Destination") );
	addColumn( i18n("Transfer Type") );
	addColumn( i18n("Total Size") );
	addColumn( i18n("Processed Size") );
	addColumn( i18n("Progress") );
	addColumn( i18n("Speed") );
	addColumn( i18n("Remaining time") );
//	addColumn( i18n("Info") );
	addColumn( i18n("Total Dirs") );
	addColumn( i18n("Total Files") );
	QWhatsThis::add( this, i18n("This window displays the progress and status of all current transfers."));
	connect( this, SIGNAL( contextMenu( KListView*, QListViewItem*, const QPoint& ) ),
					this, SLOT( slotItemRightPressed( KListView*, QListViewItem*, const QPoint& ) ) );
}
//-----------------------------------------------
KBearTransferView::~KBearTransferView(){
}
//-----------------------------------------------
void KBearTransferView::slotItemRightPressed( KListView*, QListViewItem* i, const QPoint& ){
	KBearTransferViewItem* item = (KBearTransferViewItem*)i;
	emit showMenu( item );
}
//-----------------------------------------------
