//Auto-generated by kalyptus. DO NOT EDIT.
namespace Plasma {
    using Plasma;
    using System;
    using Kimono;
    using Qyoto;
    /// <remarks>
    ///  @class ToolTipManager plasma/tooltipmanager.h <Plasma/ToolTipManager>
    ///  If you want a widget to have a tooltip displayed when the mouse is hovered over
    ///  it, you should do something like:
    ///  @code
    ///  // widget is a QGraphicsWidget
    ///  Plasma.ToolTipContent data;
    ///  data.mainText = i18n("My Title");
    ///  data.subText = i18n("This is a little tooltip");
    ///  data.image = KIcon("some-icon").pixmap(IconSize(KIconLoader.Desktop));
    ///  Plasma.ToolTipManager.Self().SetContent(widget, data);
    ///  @endcode
    ///  Note that, since a Plasma.Applet is a QGraphicsWidget, you can use
    ///  Plasma.ToolTipManager.Self().SetContent(this, data); in the
    ///  applet's init() method to set a tooltip for the whole applet.
    ///  The tooltip will be registered automatically by setContent().  It will be
    ///  automatically unregistered when the associated widget is deleted, freeing the
    ///  memory used by the tooltip, but you can manually unregister it at any time by
    ///  calling unregisterWidget().
    ///  When a tooltip for a widget is about to be shown, the widget's toolTipAboutToShow slot will be
    ///  invoked if it exists. Similarly, when a tooltip is hidden, the widget's toolTipHidden() slot
    ///  will be invoked if it exists. This allows widgets to provide on-demand tooltip data.
    ///  </remarks>        <short> Manages tooltips for QGraphicsWidgets in Plasma.</short>
    [SmokeClass("Plasma::ToolTipManager")]
    public class ToolTipManager : QObject {
        protected ToolTipManager(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(ToolTipManager), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static ToolTipManager() {
            staticInterceptor = new SmokeInvocation(typeof(ToolTipManager), null);
        }
        public enum State {
            Activated = 0,
            Inhibited = 1,
            Deactivated = 2,
        }
        /// <remarks>
        ///  Show the tooltip for a widget registered in the tooltip manager
        /// <param> name="widget" the widget for which the tooltip will be displayed
        ///      </param></remarks>        <short>    Show the tooltip for a widget registered in the tooltip manager </short>
        public void Show(QGraphicsWidget widget) {
            interceptor.Invoke("show#", "show(QGraphicsWidget*)", typeof(void), typeof(QGraphicsWidget), widget);
        }
        /// <remarks>
        ///  Find out whether the tooltip for a given widget is currently being displayed.
        /// <param> name="widget" the widget to check the tooltip for
        /// </param></remarks>        <return> true if the tooltip of the widget is currently displayed,
        ///          false if not
        ///      </return>
        ///         <short>    Find out whether the tooltip for a given widget is currently being displayed.</short>
        public bool IsVisible(QGraphicsWidget widget) {
            return (bool) interceptor.Invoke("isVisible#", "isVisible(QGraphicsWidget*) const", typeof(bool), typeof(QGraphicsWidget), widget);
        }
        /// <remarks>
        ///  Hides the tooltip for a widget immediately.
        /// <param> name="widget" the widget to hide the tooltip for
        ///      </param></remarks>        <short>    Hides the tooltip for a widget immediately.</short>
        public void Hide(QGraphicsWidget widget) {
            interceptor.Invoke("hide#", "hide(QGraphicsWidget*)", typeof(void), typeof(QGraphicsWidget), widget);
        }
        /// <remarks>
        ///  Registers a widget with the tooltip manager.
        ///  Note that setContent() will register the widget if it
        ///  has not already been registered, and so you do not normally
        ///  need to use the method.
        ///  This is useful for creating tooltip content on demand.  You can
        ///  register your widget with registerWidget(), then implement
        ///  a slot named toolTipAboutToShow for the widget.  This will be
        ///  called before the tooltip is shown, allowing you to set the
        ///  data with setContent().
        ///  If the widget also has a toolTipHidden slot, this will be called
        ///  after the tooltip is hidden.
        /// <param> name="widget" the desired widget
        ///      </param></remarks>        <short>    Registers a widget with the tooltip manager.</short>
        public void RegisterWidget(QGraphicsWidget widget) {
            interceptor.Invoke("registerWidget#", "registerWidget(QGraphicsWidget*)", typeof(void), typeof(QGraphicsWidget), widget);
        }
        /// <remarks>
        ///  Unregisters a widget from the tooltip manager.
        ///  This will free the memory used by the tooltip associated with the widget.
        /// <param> name="widget" the desired widget to delete
        ///      </param></remarks>        <short>    Unregisters a widget from the tooltip manager.</short>
        public void UnregisterWidget(QGraphicsWidget widget) {
            interceptor.Invoke("unregisterWidget#", "unregisterWidget(QGraphicsWidget*)", typeof(void), typeof(QGraphicsWidget), widget);
        }
        /// <remarks>
        ///  Sets the content for the tooltip associated with a widget.
        ///  Note that this will register the widget with the ToolTipManager if
        ///  necessary, so there is usually no need to call registerWidget().
        /// <param> name="widget" the widget the tooltip should be associated with
        /// </param><param> name="data" the content of the tooltip. If an empty Content
        ///                is passed in, the tooltip content will be reset.
        ///      </param></remarks>        <short>    Sets the content for the tooltip associated with a widget.</short>
        public void SetContent(QGraphicsWidget widget, Plasma.ToolTipContent data) {
            interceptor.Invoke("setContent##", "setContent(QGraphicsWidget*, const Plasma::ToolTipContent&)", typeof(void), typeof(QGraphicsWidget), widget, typeof(Plasma.ToolTipContent), data);
        }
        /// <remarks>
        ///  Clears the tooltip data associated with this widget, but keeps
        ///  the widget registered.
        ///      </remarks>        <short>    Clears the tooltip data associated with this widget, but keeps  the widget registered.</short>
        public void ClearContent(QGraphicsWidget widget) {
            interceptor.Invoke("clearContent#", "clearContent(QGraphicsWidget*)", typeof(void), typeof(QGraphicsWidget), widget);
        }
        /// <remarks>
        ///  Sets the current state of the manager.
        /// </remarks>        <short>    Sets the current state of the manager.</short>
        ///         <see> State</see>
        ///         <see> @arg</see>
        ///         <see> state</see>
        ///         <see> the</see>
        ///         <see> state</see>
        ///         <see> to</see>
        ///         <see> put</see>
        ///         <see> the</see>
        ///         <see> manager</see>
        ///         <see> in</see>
        public void SetState(Plasma.ToolTipManager.State state) {
            interceptor.Invoke("setState$", "setState(Plasma::ToolTipManager::State)", typeof(void), typeof(Plasma.ToolTipManager.State), state);
        }
        /// <remarks>
        /// </remarks>        <return> the current state of the manager; @see State
        ///      </return>
        ///         <short>   </short>
        public Plasma.ToolTipManager.State state() {
            return (Plasma.ToolTipManager.State) interceptor.Invoke("state", "state() const", typeof(Plasma.ToolTipManager.State));
        }
        /// <remarks>
        /// </remarks>        <return> The singleton instance of the manager.
        ///      </return>
        ///         <short>   </short>
        public static Plasma.ToolTipManager Self() {
            return (Plasma.ToolTipManager) staticInterceptor.Invoke("self", "self()", typeof(Plasma.ToolTipManager));
        }
        protected new IToolTipManagerSignals Emit {
            get { return (IToolTipManagerSignals) Q_EMIT; }
        }
    }

    public interface IToolTipManagerSignals : IQObjectSignals {
    }
}
