//Auto-generated by kalyptus. DO NOT EDIT.
namespace KParts {
    using Kimono;
    using System;
    using Qyoto;
    using System.Text;
    using System.Collections.Generic;
    /// <remarks>
    ///  Base class for parts.
    ///  A "part" is a GUI component, featuring:
    /// 
    /// <li>
    /// A widget embeddedable in any application.
    /// </li>
    /// 
    /// <li>
    /// GUI elements that will be merged in the "host" user interface
    ///  (menubars, toolbars... ).
    /// </li>
    ///  <li><b>About the widget:</b></li>
    ///  Note that KParts.Part does not inherit QWidget.
    ///  This is due to the fact that the "visual representation"
    ///  will probably not be a mere QWidget, but an elaborate one.
    ///  That's why when implementing your KParts.Part (or derived)
    ///  you should call KParts.Part.SetWidget() in your constructor.
    ///  <li><b>About the GUI elements:</b></li>
    ///  Those elements trigger actions, defined by the part ( action()).
    ///  The layout of the actions in the GUI is defined by an XML file ( setXMLFile()).
    ///  See also ReadOnlyPart and ReadWritePart, which define the
    ///  framework for a "viewer" part and for an "editor"-like part.
    ///  Use Part directly only if your part doesn't fit into those.
    ///   See <see cref="IPartSignals"></see> for signals emitted by Part
    /// </remarks>        <short>    Base class for parts.</short>
    [SmokeClass("KParts::Part")]
    public class Part : QObject, KParts.IPartBase, IDisposable {
        protected Part(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Part), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static Part() {
            staticInterceptor = new SmokeInvocation(typeof(Part), null);
        }
        // KParts::Part* Part(KParts::PartPrivate& arg1,QObject* arg2); >>>> NOT CONVERTED
        // KParts::PartBase* PartBase(KParts::PartBasePrivate& arg1); >>>> NOT CONVERTED
        // KXMLGUIClient::StateChange getActionsToChangeForState(const QString& arg1); >>>> NOT CONVERTED
        /// <remarks>
        ///   Constructor.
        /// <param> name="parent" Parent object of the part.
        ///      </param></remarks>        <short>     Constructor.</short>
        public Part(QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Part#", "Part(QObject*)", typeof(void), typeof(QObject), parent);
        }
        public Part() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Part", "Part()", typeof(void));
        }
        /// <remarks>
        ///  Embed this part into a host widget.
        ///  You don't need to do this if you created the widget with the
        ///  correct parent widget - this is just a QWidget.Reparent().
        ///  Note that the Part is still the holder
        ///  of the QWidget, meaning that if you delete the Part,
        ///  then the widget gets destroyed as well, and vice-versa.
        ///  This method is not recommended since creating the widget with the correct
        ///  parent is simpler anyway.
        ///      </remarks>        <short>    Embed this part into a host widget.</short>
        [SmokeMethod("embed(QWidget*)")]
        public virtual void Embed(QWidget parentWidget) {
            interceptor.Invoke("embed#", "embed(QWidget*)", typeof(void), typeof(QWidget), parentWidget);
        }
        /// <remarks>
        /// </remarks>        <return> The widget defined by this part, set by setWidget().
        ///      </return>
        ///         <short>   </short>
        [SmokeMethod("widget()")]
        public virtual QWidget Widget() {
            return (QWidget) interceptor.Invoke("widget", "widget()", typeof(QWidget));
        }
        /// <remarks>
        ///  Used by the part manager.
        ///      </remarks>        <short>   </short>
        [SmokeMethod("setManager(KParts::PartManager*)")]
        public virtual void SetManager(KParts.PartManager manager) {
            interceptor.Invoke("setManager#", "setManager(KParts::PartManager*)", typeof(void), typeof(KParts.PartManager), manager);
        }
        /// <remarks>
        ///  Returns the part manager handling this part, if any (null otherwise).
        ///      </remarks>        <short>    Returns the part manager handling this part, if any (0L otherwise).</short>
        public KParts.PartManager Manager() {
            return (KParts.PartManager) interceptor.Invoke("manager", "manager() const", typeof(KParts.PartManager));
        }
        /// <remarks>
        ///  By default, the widget is deleted by the part when the part is deleted.
        ///  The hosting application can call setAutoDeleteWidget(false) to
        ///  disable this behavior, given that the widget is usually deleted by
        ///  its parent widget anyway.
        ///  This is a method for the hosting application only, Part subclasses
        ///  should never call this.
        ///      </remarks>        <short>    By default, the widget is deleted by the part when the part is deleted.</short>
        public void SetAutoDeleteWidget(bool autoDeleteWidget) {
            interceptor.Invoke("setAutoDeleteWidget$", "setAutoDeleteWidget(bool)", typeof(void), typeof(bool), autoDeleteWidget);
        }
        /// <remarks>
        ///  By default, the part deletes itself when its widget is deleted.
        ///  The hosting application can call setAutoDeletePart(false) to
        ///  disable this behavior, to be able to delete the widget and then the part,
        ///  independently.
        ///  This is a method for the hosting application only, Part subclasses
        ///  should never call this.
        ///      </remarks>        <short>    By default, the part deletes itself when its widget is deleted.</short>
        public void SetAutoDeletePart(bool autoDeletePart) {
            interceptor.Invoke("setAutoDeletePart$", "setAutoDeletePart(bool)", typeof(void), typeof(bool), autoDeletePart);
        }
        /// <remarks>
        ///  Returns the part (this, or a child part) at the given global position.
        ///  This is called by the part manager to ask whether a part should be activated
        ///  when clicking somewhere. In most cases the default implementation is enough.
        ///  Reimplement this if your part has child parts in some areas (like in khtml or koffice)
        /// <param> name="widget" the part widget being clicked - usually the same as widget(), except in koffice.
        /// </param><param> name="globalPos" the mouse coordinates in global coordinates
        ///      </param></remarks>        <short>    Returns the part (this, or a child part) at the given global position.</short>
        [SmokeMethod("hitTest(QWidget*, const QPoint&)")]
        public virtual KParts.Part HitTest(QWidget widget, QPoint globalPos) {
            return (KParts.Part) interceptor.Invoke("hitTest##", "hitTest(QWidget*, const QPoint&)", typeof(KParts.Part), typeof(QWidget), widget, typeof(QPoint), globalPos);
        }
        /// <remarks>
        /// <param> name="selectable" Indicates whether the part is selectable or not.
        ///      </param></remarks>        <short>   </short>
        [SmokeMethod("setSelectable(bool)")]
        public virtual void SetSelectable(bool selectable) {
            interceptor.Invoke("setSelectable$", "setSelectable(bool)", typeof(void), typeof(bool), selectable);
        }
        /// <remarks>
        ///   Returns whether the part is selectable or not.
        ///      </remarks>        <short>     Returns whether the part is selectable or not.</short>
        public bool IsSelectable() {
            return (bool) interceptor.Invoke("isSelectable", "isSelectable() const", typeof(bool));
        }
        /// <remarks>
        ///  Use this icon loader to load any icons that are specific to this part,
        ///  i.e. icons installed into this part's own directories as opposed to standard
        ///  kde icons. Use KIcon("myicon", iconLoader()).
        ///  Make sure to call setComponentData before calling iconLoader.
        ///      </remarks>        <short>    Use this icon loader to load any icons that are specific to this part,  i.</short>
        public KIconLoader IconLoader() {
            return (KIconLoader) interceptor.Invoke("iconLoader", "iconLoader()", typeof(KIconLoader));
        }
        /// <remarks>
        ///  Set the main widget.
        ///  Call this in the Part-inherited class constructor.
        ///      </remarks>        <short>    Set the main widget.</short>
        [SmokeMethod("setWidget(QWidget*)")]
        protected virtual void SetWidget(QWidget widget) {
            interceptor.Invoke("setWidget#", "setWidget(QWidget*)", typeof(void), typeof(QWidget), widget);
        }
        /// <remarks>
        ///      </remarks>        <short>   </short>
        [SmokeMethod("customEvent(QEvent*)")]
        protected override void CustomEvent(QEvent arg1) {
            interceptor.Invoke("customEvent#", "customEvent(QEvent*)", typeof(void), typeof(QEvent), arg1);
        }
        /// <remarks>
        ///  Convenience method which is called when the Part received a PartActivateEvent .
        ///  Reimplement this if you don't want to reimplement event and test for the event yourself
        ///  or even install an event filter.
        ///      </remarks>        <short>    Convenience method which is called when the Part received a PartActivateEvent .</short>
        [SmokeMethod("partActivateEvent(KParts::PartActivateEvent*)")]
        protected virtual void PartActivateEvent(KParts.PartActivateEvent arg1) {
            interceptor.Invoke("partActivateEvent#", "partActivateEvent(KParts::PartActivateEvent*)", typeof(void), typeof(KParts.PartActivateEvent), arg1);
        }
        /// <remarks>
        ///  Convenience method which is called when the Part received a
        ///  PartSelectEvent .
        ///  Reimplement this if you don't want to reimplement event and
        ///  test for the event yourself or even install an event filter.
        ///      </remarks>        <short>    Convenience method which is called when the Part received a  PartSelectEvent .</short>
        [SmokeMethod("partSelectEvent(KParts::PartSelectEvent*)")]
        protected virtual void PartSelectEvent(KParts.PartSelectEvent arg1) {
            interceptor.Invoke("partSelectEvent#", "partSelectEvent(KParts::PartSelectEvent*)", typeof(void), typeof(KParts.PartSelectEvent), arg1);
        }
        /// <remarks>
        ///  Convenience method which is called when the Part received a
        ///  GUIActivateEvent .
        ///  Reimplement this if you don't want to reimplement event and
        ///  test for the event yourself or even install an event filter.
        ///      </remarks>        <short>    Convenience method which is called when the Part received a  GUIActivateEvent .</short>
        [SmokeMethod("guiActivateEvent(KParts::GUIActivateEvent*)")]
        protected virtual void GuiActivateEvent(KParts.GUIActivateEvent arg1) {
            interceptor.Invoke("guiActivateEvent#", "guiActivateEvent(KParts::GUIActivateEvent*)", typeof(void), typeof(KParts.GUIActivateEvent), arg1);
        }
        /// <remarks>
        ///  Convenience method for KXMLGUIFactory.Container.
        /// </remarks>        <return> a container widget owned by the Part's GUI.
        ///      </return>
        ///         <short>    Convenience method for KXMLGUIFactory.Container.</short>
        protected QWidget HostContainer(string containerName) {
            return (QWidget) interceptor.Invoke("hostContainer$", "hostContainer(const QString&)", typeof(QWidget), typeof(string), containerName);
        }
        /// <remarks>
        ///  Load this part's plugins now.
        ///  Normally you want to call this at the end of the part constructor,
        ///  if you used setComponentData(componentData, false)
        /// </remarks>        <short>    Load this part's plugins now.</short>
        protected void LoadPlugins() {
            interceptor.Invoke("loadPlugins", "loadPlugins()", typeof(void));
        }
        /// <remarks>
        ///      </remarks>        <short>   </short>
        [Q_SLOT("void slotWidgetDestroyed()")]
        protected void SlotWidgetDestroyed() {
            interceptor.Invoke("slotWidgetDestroyed", "slotWidgetDestroyed()", typeof(void));
        }
        ~Part() {
            interceptor.Invoke("~Part", "~Part()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~Part", "~Part()", typeof(void));
        }
        /// <remarks>
        ///   Internal method. Called by KParts.Part to specify the parent object for plugin objects.
        ///    </remarks>        <short>     Internal method.</short>
        public void SetPartObject(QObject arg1) {
            interceptor.Invoke("setPartObject#", "setPartObject(QObject*)", typeof(void), typeof(QObject), arg1);
        }
        public QObject PartObject() {
            return (QObject) interceptor.Invoke("partObject", "partObject() const", typeof(QObject));
        }
        /// <remarks>
        ///  Set the componentData(KComponentData) for this part.
        ///  Call this first in the inherited class constructor,
        ///  because it loads the i18n catalogs.
        ///    </remarks>        <short>    Set the componentData(KComponentData) for this part.</short>
        [SmokeMethod("setComponentData(const KComponentData&)")]
        protected virtual void SetComponentData(KComponentData componentData) {
            interceptor.Invoke("setComponentData#", "setComponentData(const KComponentData&)", typeof(void), typeof(KComponentData), componentData);
        }
        /// <remarks>
        ///  Set the componentData(KComponentData) for this part.
        ///  Call this first in the inherited class constructor,
        ///  because it loads the i18n catalogs.
        ///  It is recommended to call setComponentData with loadPlugins set to false,
        ///  and to load plugins at the end of your part constructor (in the case of
        ///  KParts.MainWindow, plugins are automatically loaded in createGUI anyway,
        ///  so set loadPlugins to false for KParts.MainWindow as well).
        ///    </remarks>        <short>    Set the componentData(KComponentData) for this part.</short>
        [SmokeMethod("setComponentData(const KComponentData&, bool)")]
        protected virtual void SetComponentData(KComponentData componentData, bool loadPlugins) {
            interceptor.Invoke("setComponentData#$", "setComponentData(const KComponentData&, bool)", typeof(void), typeof(KComponentData), componentData, typeof(bool), loadPlugins);
        }
        /// <remarks>
        ///  Load the Plugins honoring the PluginLoadingMode.
        ///  If you call this method in an already constructed GUI (like when the user
        ///  has changed which plugins are enabled) you need to add the new plugins to
        ///  the KXMLGUIFactory:
        ///  <pre>
        ///  if( factory() )
        ///  {
        ///    QList<KParts.Plugin > plugins = KParts.Plugin.PluginObjects( this );
        ///    for(int i = 0; i != plugins.size(); ++i) {
        ///       factory().AddClient( plugins[i] );
        ///    }
        ///  }
        ///  </pre>
        ///    </remarks>        <short>    Load the Plugins honoring the PluginLoadingMode.</short>
        protected void LoadPlugins(QObject parent, IKXMLGUIClient parentGUIClient, KComponentData componentData) {
            interceptor.Invoke("loadPlugins###", "loadPlugins(QObject*, KXMLGUIClient*, const KComponentData&)", typeof(void), typeof(QObject), parent, typeof(IKXMLGUIClient), parentGUIClient, typeof(KComponentData), componentData);
        }
        /// <remarks>
        ///  Set how plugins should be loaded
        /// <param> name="loadingMode" see PluginLoadingMode
        /// </param> For a KParts.Part: call this before setComponentData.
        ///  For a KParts.MainWindow: call this before createGUI.
        ///    </remarks>        <short>    Set how plugins should be loaded </short>
        protected void SetPluginLoadingMode(KParts.PartBase.PluginLoadingMode loadingMode) {
            interceptor.Invoke("setPluginLoadingMode$", "setPluginLoadingMode(KParts::PartBase::PluginLoadingMode)", typeof(void), typeof(KParts.PartBase.PluginLoadingMode), loadingMode);
        }
        /// <remarks>
        ///  If you change the binary interface offered by your part, you can avoid crashes
        ///  from old plugins lying around by setting X-KDE-InterfaceVersion=2 in the
        ///  .desktop files of the plugins, and calling setPluginInterfaceVersion( 2 ), so that
        ///  the old plugins are not loaded. Increase both numbers every time a
        ///  binary incompatible change in the application's plugin interface is made.
        /// <param> name="version" the interface version that plugins must have in order to be loaded.
        /// </param> For a KParts.Part: call this before setComponentData.
        ///  For a KParts.MainWindow: call this before createGUI.
        ///    </remarks>        <short>    If you change the binary interface offered by your part, you can avoid crashes  from old plugins lying around by setting X-KDE-InterfaceVersion=2 in the  .</short>
        protected void SetPluginInterfaceVersion(int version) {
            interceptor.Invoke("setPluginInterfaceVersion$", "setPluginInterfaceVersion(int)", typeof(void), typeof(int), version);
        }
        /// <remarks>
        ///  Retrieves an action of the client by name.  If not found, it looks in its child clients.
        ///  This method is provided for convenience, as it uses actionCollection()
        ///  to get the action object.
        ///    </remarks>        <short>    Retrieves an action of the client by name.</short>
        public QAction Action(string name) {
            return (QAction) interceptor.Invoke("action$", "action(const char*) const", typeof(QAction), typeof(string), name);
        }
        /// <remarks>
        ///  Retrieves an action for a given QDomElement. The default
        ///  implementation uses the "name" attribute to query the action
        ///  object via the other action() method.
        ///    </remarks>        <short>    Retrieves an action for a given QDomElement.</short>
        [SmokeMethod("action(const QDomElement&) const")]
        public virtual QAction Action(QDomElement element) {
            return (QAction) interceptor.Invoke("action#", "action(const QDomElement&) const", typeof(QAction), typeof(QDomElement), element);
        }
        /// <remarks>
        ///  Retrieves the entire action collection for the GUI client.
        ///    </remarks>        <short>    Retrieves the entire action collection for the GUI client.</short>
        [SmokeMethod("actionCollection() const")]
        public virtual KActionCollection ActionCollection() {
            return (KActionCollection) interceptor.Invoke("actionCollection", "actionCollection() const", typeof(KActionCollection));
        }
        /// <remarks>
        /// </remarks>        <return> The componentData ( KComponentData ) for this GUI client.
        ///    </return>
        ///         <short>   </short>
        [SmokeMethod("componentData() const")]
        public virtual KComponentData ComponentData() {
            return (KComponentData) interceptor.Invoke("componentData", "componentData() const", typeof(KComponentData));
        }
        /// <remarks>
        /// </remarks>        <return> The parsed XML in a QDomDocument, set by
        ///  setXMLFile() or setXML().
        ///  This document describes the layout of the GUI.
        ///    </return>
        ///         <short>   </short>
        [SmokeMethod("domDocument() const")]
        public virtual QDomDocument DomDocument() {
            return (QDomDocument) interceptor.Invoke("domDocument", "domDocument() const", typeof(QDomDocument));
        }
        /// <remarks>
        ///  This will return the name of the XML file as set by setXMLFile().
        ///  If setXML() is used directly, then this will return NULL.
        ///  The filename that this returns is obvious for components as each
        ///  component has exactly one XML file.  In non-components, however,
        ///  there are usually two: the global file and the local file.  This
        ///  function doesn't really care about that, though.  It will always
        ///  return the last XML file set.  This, in almost all cases, will
        ///  be the local XML file.
        /// </remarks>        <return> The name of the XML file or string()
        ///    </return>
        ///         <short>    This will return the name of the XML file as set by setXMLFile().</short>
        [SmokeMethod("xmlFile() const")]
        public virtual string XmlFile() {
            return (string) interceptor.Invoke("xmlFile", "xmlFile() const", typeof(string));
        }
        [SmokeMethod("localXMLFile() const")]
        public virtual string LocalXMLFile() {
            return (string) interceptor.Invoke("localXMLFile", "localXMLFile() const", typeof(string));
        }
        /// <remarks>
        ///    </remarks>        <short>   </short>
        public void SetXMLGUIBuildDocument(QDomDocument doc) {
            interceptor.Invoke("setXMLGUIBuildDocument#", "setXMLGUIBuildDocument(const QDomDocument&)", typeof(void), typeof(QDomDocument), doc);
        }
        /// <remarks>
        ///    </remarks>        <short>   </short>
        public QDomDocument XmlguiBuildDocument() {
            return (QDomDocument) interceptor.Invoke("xmlguiBuildDocument", "xmlguiBuildDocument() const", typeof(QDomDocument));
        }
        /// <remarks>
        ///  This method is called by the KXMLGUIFactory as soon as the client
        ///  is added to the KXMLGUIFactory's GUI.
        ///    </remarks>        <short>    This method is called by the KXMLGUIFactory as soon as the client  is added to the KXMLGUIFactory's GUI.</short>
        public void SetFactory(KXMLGUIFactory factory) {
            interceptor.Invoke("setFactory#", "setFactory(KXMLGUIFactory*)", typeof(void), typeof(KXMLGUIFactory), factory);
        }
        /// <remarks>
        ///  Retrieves a pointer to the KXMLGUIFactory this client is
        ///  associated with (will return 0 if the client's GUI has not been built
        ///  by a KXMLGUIFactory.
        ///    </remarks>        <short>    Retrieves a pointer to the KXMLGUIFactory this client is  associated with (will return 0 if the client's GUI has not been built  by a KXMLGUIFactory.</short>
        public KXMLGUIFactory Factory() {
            return (KXMLGUIFactory) interceptor.Invoke("factory", "factory() const", typeof(KXMLGUIFactory));
        }
        /// <remarks>
        ///  KXMLGUIClients can form a simple child/parent object tree. This
        ///  method returns a pointer to the parent client or 0 if it has no
        ///  parent client assigned.
        ///    </remarks>        <short>    KXMLGUIClients can form a simple child/parent object tree.</short>
        public IKXMLGUIClient ParentClient() {
            return (IKXMLGUIClient) interceptor.Invoke("parentClient", "parentClient() const", typeof(IKXMLGUIClient));
        }
        /// <remarks>
        ///  Use this method to make a client a child client of another client.
        ///  Usually you don't need to call this method, as it is called
        ///  automatically when using the second constructor, which takes a
        ///  parent argument.
        ///    </remarks>        <short>    Use this method to make a client a child client of another client.</short>
        public void InsertChildClient(IKXMLGUIClient child) {
            interceptor.Invoke("insertChildClient#", "insertChildClient(KXMLGUIClient*)", typeof(void), typeof(IKXMLGUIClient), child);
        }
        /// <remarks>
        ///  Removes the given <code>child</code> from the client's children list.
        ///    </remarks>        <short>    Removes the given <code>child</code> from the client's children list.</short>
        public void RemoveChildClient(IKXMLGUIClient child) {
            interceptor.Invoke("removeChildClient#", "removeChildClient(KXMLGUIClient*)", typeof(void), typeof(IKXMLGUIClient), child);
        }
        /// <remarks>
        ///  Retrieves a list of all child clients.
        ///    </remarks>        <short>    Retrieves a list of all child clients.</short>
        public List<KXMLGUIClient> ChildClients() {
            return (List<KXMLGUIClient>) interceptor.Invoke("childClients", "childClients()", typeof(List<KXMLGUIClient>));
        }
        /// <remarks>
        ///  A client can have an own KXMLGUIBuilder.
        ///  Use this method to assign your builder instance to the client (so that the
        ///  KXMLGUIFactory can use it when building the client's GUI)
        ///  Client specific guibuilders are useful if you want to create
        ///  custom container widgets for your GUI.
        ///    </remarks>        <short>    A client can have an own KXMLGUIBuilder.</short>
        public void SetClientBuilder(IKXMLGUIBuilder builder) {
            interceptor.Invoke("setClientBuilder#", "setClientBuilder(KXMLGUIBuilder*)", typeof(void), typeof(IKXMLGUIBuilder), builder);
        }
        /// <remarks>
        ///  Retrieves the client's GUI builder or 0 if no client specific
        ///  builder has been assigned via setClientBuilder()
        ///    </remarks>        <short>    Retrieves the client's GUI builder or 0 if no client specific  builder has been assigned via setClientBuilder()    </short>
        public IKXMLGUIBuilder ClientBuilder() {
            return (IKXMLGUIBuilder) interceptor.Invoke("clientBuilder", "clientBuilder() const", typeof(IKXMLGUIBuilder));
        }
        /// <remarks>
        ///  Forces this client to re-read its XML resource file.  This is
        ///  intended to be used when you know that the resource file has
        ///  changed and you will soon be rebuilding the GUI.  It has no
        ///  useful effect with non-KParts GUIs, so don't bother using it
        ///  unless your app is component based.
        ///    </remarks>        <short>    Forces this client to re-read its XML resource file.</short>
        public void ReloadXML() {
            interceptor.Invoke("reloadXML", "reloadXML()", typeof(void));
        }
        /// <remarks>
        ///  ActionLists are a way for XMLGUI to support dynamic lists of
        ///  actions.  E.g. if you are writing a file manager, and there is a
        ///  menu file whose contents depend on the mimetype of the file that
        ///  is selected, then you can achieve this using ActionLists. It
        ///  works as follows:
        ///  In your xxxui.rc file ( the one that you set in setXMLFile() / pass to setupGUI()
        ///  ), you put a tag <tt>\<ActionList name="xxx"\></tt>.
        ///  Example:
        ///  <pre>
        ///  <kpartgui name="xxx_part" version="1">
        ///  <MenuBar>
        ///    <Menu name="file">
        ///      ...  <!-- some useful actions-->
        ///      <ActionList name="xxx_file_actionlist" />
        ///      ...  <!-- even more useful actions-->
        ///    </Menu>
        ///    ...
        ///  </MenuBar>
        ///  </kpartgui>
        ///  </pre>
        ///  This tag will get expanded to a list of actions.  In the example
        ///  above ( a file manager with a dynamic file menu ), you would call
        ///  <pre>
        ///  QList<QAction> file_actions;
        ///  for( ... )
        ///    if( ... )
        ///      file_actions.append( cool_action );
        ///  unplugActionList( "xxx_file_actionlist" );
        ///  plugActionList( "xxx_file_actionlist", file_actions );
        ///  </pre>
        ///  every time a file is selected, unselected or ...
        ///  <b>Note:<> You should not call createGUI() after calling this
        ///        function.  In fact, that would remove the newly added
        ///        actionlists again...
        ///  <b>Note:<> Forgetting to call unplugActionList() before
        ///        plugActionList() would leave the previous actions in the
        ///        menu too..
        ///  \see unplugActionList()
        ///    </remarks>        <short>    ActionLists are a way for XMLGUI to support dynamic lists of  actions.</short>
        public void PlugActionList(string name, List<QAction> actionList) {
            interceptor.Invoke("plugActionList$?", "plugActionList(const QString&, const QList<QAction*>&)", typeof(void), typeof(string), name, typeof(List<QAction>), actionList);
        }
        /// <remarks>
        ///  Unplugs the action list <pre>name</pre> from the XMLGUI.
        ///  Calling this removes the specified action list, i.e. this is the
        ///  complement to plugActionList(). See plugActionList() for a more
        ///  detailed example.
        ///  \see plugActionList()
        ///    </remarks>        <short>    Unplugs the action list \p name from the XMLGUI.</short>
        public void UnplugActionList(string name) {
            interceptor.Invoke("unplugActionList$", "unplugActionList(const QString&)", typeof(void), typeof(string), name);
        }
        public void AddStateActionEnabled(string state, string action) {
            interceptor.Invoke("addStateActionEnabled$$", "addStateActionEnabled(const QString&, const QString&)", typeof(void), typeof(string), state, typeof(string), action);
        }
        public void AddStateActionDisabled(string state, string action) {
            interceptor.Invoke("addStateActionDisabled$$", "addStateActionDisabled(const QString&, const QString&)", typeof(void), typeof(string), state, typeof(string), action);
        }
        public void BeginXMLPlug(QWidget arg1) {
            interceptor.Invoke("beginXMLPlug#", "beginXMLPlug(QWidget*)", typeof(void), typeof(QWidget), arg1);
        }
        public void EndXMLPlug() {
            interceptor.Invoke("endXMLPlug", "endXMLPlug()", typeof(void));
        }
        public void PrepareXMLUnplug(QWidget arg1) {
            interceptor.Invoke("prepareXMLUnplug#", "prepareXMLUnplug(QWidget*)", typeof(void), typeof(QWidget), arg1);
        }
        /// <remarks>
        ///  Sets the name of the rc file containing the XML for the part.
        ///  Call this in the Part-inherited class constructor.
        ///  If you're writing usual application, use KXmlGuiWindow.SetupGUI() with non-default arguments
        /// <param> name="file" Either an absolute path for the file, or simply the
        ///              filename, which will then be assumed to be installed
        ///              in the "data" resource, under a directory named like
        ///              the componentData.
        /// </param><param> name="merge" Whether to merge with the global document.
        /// </param><param> name="setXMLDoc" Specify whether to call setXML. Default is true.
        /// </param></remarks>        <short>    Sets the name of the rc file containing the XML for the part.</short>
        [SmokeMethod("setXMLFile(const QString&, bool, bool)")]
        protected virtual void SetXMLFile(string file, bool merge, bool setXMLDoc) {
            interceptor.Invoke("setXMLFile$$$", "setXMLFile(const QString&, bool, bool)", typeof(void), typeof(string), file, typeof(bool), merge, typeof(bool), setXMLDoc);
        }
        [SmokeMethod("setXMLFile(const QString&, bool)")]
        protected virtual void SetXMLFile(string file, bool merge) {
            interceptor.Invoke("setXMLFile$$", "setXMLFile(const QString&, bool)", typeof(void), typeof(string), file, typeof(bool), merge);
        }
        [SmokeMethod("setXMLFile(const QString&)")]
        protected virtual void SetXMLFile(string file) {
            interceptor.Invoke("setXMLFile$", "setXMLFile(const QString&)", typeof(void), typeof(string), file);
        }
        [SmokeMethod("setLocalXMLFile(const QString&)")]
        protected virtual void SetLocalXMLFile(string file) {
            interceptor.Invoke("setLocalXMLFile$", "setLocalXMLFile(const QString&)", typeof(void), typeof(string), file);
        }
        /// <remarks>
        ///  Sets the XML for the part.
        ///  Call this in the Part-inherited class constructor if you
        ///   don't call setXMLFile().
        /// </remarks>        <short>    Sets the XML for the part.</short>
        [SmokeMethod("setXML(const QString&, bool)")]
        protected virtual void SetXML(string document, bool merge) {
            interceptor.Invoke("setXML$$", "setXML(const QString&, bool)", typeof(void), typeof(string), document, typeof(bool), merge);
        }
        [SmokeMethod("setXML(const QString&)")]
        protected virtual void SetXML(string document) {
            interceptor.Invoke("setXML$", "setXML(const QString&)", typeof(void), typeof(string), document);
        }
        /// <remarks>
        ///  Sets the Document for the part, describing the layout of the GUI.
        ///  Call this in the Part-inherited class constructor if you don't call
        ///  setXMLFile or setXML .
        ///    </remarks>        <short>    Sets the Document for the part, describing the layout of the GUI.</short>
        [SmokeMethod("setDOMDocument(const QDomDocument&, bool)")]
        protected virtual void SetDOMDocument(QDomDocument document, bool merge) {
            interceptor.Invoke("setDOMDocument#$", "setDOMDocument(const QDomDocument&, bool)", typeof(void), typeof(QDomDocument), document, typeof(bool), merge);
        }
        [SmokeMethod("setDOMDocument(const QDomDocument&)")]
        protected virtual void SetDOMDocument(QDomDocument document) {
            interceptor.Invoke("setDOMDocument#", "setDOMDocument(const QDomDocument&)", typeof(void), typeof(QDomDocument), document);
        }
        /// <remarks>
        ///  Actions can collectively be assigned a "State". To accomplish this
        ///  the respective actions are tagged as \<enable\> or \<disable\> in
        ///  a \<State\> \</State\> group of the XMLfile. During program execution the
        ///  programmer can call stateChanged() to set actions to a defined state.
        /// <param> name="newstate" Name of a State in the XMLfile.
        /// </param><param> name="reverse" If the flag reverse is set to StateReverse, the State is reversed.
        ///  (actions to be enabled will be disabled and action to be disabled will be enabled)
        ///  Default is reverse=false.
        ///    </param></remarks>        <short>    Actions can collectively be assigned a "State".</short>
        [SmokeMethod("stateChanged(const QString&, KXMLGUIClient::ReverseStateChange)")]
        protected virtual void StateChanged(string newstate, KXMLGUIClient.ReverseStateChange reverse) {
            interceptor.Invoke("stateChanged$$", "stateChanged(const QString&, KXMLGUIClient::ReverseStateChange)", typeof(void), typeof(string), newstate, typeof(KXMLGUIClient.ReverseStateChange), reverse);
        }
        [SmokeMethod("stateChanged(const QString&)")]
        protected virtual void StateChanged(string newstate) {
            interceptor.Invoke("stateChanged$", "stateChanged(const QString&)", typeof(void), typeof(string), newstate);
        }
        public static string FindMostRecentXMLFile(List<string> files, StringBuilder doc) {
            return (string) staticInterceptor.Invoke("findMostRecentXMLFile?$", "findMostRecentXMLFile(const QStringList&, QString&)", typeof(string), typeof(List<string>), files, typeof(StringBuilder), doc);
        }
        protected new IPartSignals Emit {
            get { return (IPartSignals) Q_EMIT; }
        }
    }

    public interface IPartSignals : IQObjectSignals {
        /// <remarks>
        ///  Emitted by the part, to set the caption of the window(s)
        ///  hosting this part
        ///      </remarks>        <short>    Emitted by the part, to set the caption of the window(s)  hosting this part      </short>
        [Q_SIGNAL("void setWindowCaption(QString)")]
        void SetWindowCaption(string caption);
        /// <remarks>
        ///  Emitted by the part, to set a text in the statusbar of the window(s)
        ///  hosting this part
        ///      </remarks>        <short>    Emitted by the part, to set a text in the statusbar of the window(s)  hosting this part      </short>
        [Q_SIGNAL("void setStatusBarText(QString)")]
        void SetStatusBarText(string text);
    }
}
