//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  \class KConfigGroup kconfiggroup.h <KConfigGroup>
    ///  A class for one specific group in a KConfig object.
    ///  If you want to access the top-level entries of a KConfig
    ///  object, which are not associated with any group, use an
    ///  empty group name.
    ///  A KConfigGroup can be read-only if it is constructed from a const config object
    ///  or from another read-only group.
    ///  </remarks>        <short>    \class KConfigGroup kconfiggroup.</short>
    [SmokeClass("KConfigGroup")]
    public partial class KConfigGroup : KConfigBase, IDisposable {
        protected KConfigGroup(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KConfigGroup), this);
        }
        /// <remarks>
        ///  Constructs a null group. A null group is invalid.
        ///  \see isValid
        ///      </remarks>        <short>    Constructs a null group.</short>
        public KConfigGroup() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KConfigGroup", "KConfigGroup()", typeof(void));
        }
        /// <remarks>
        ///  Construct a config group corresponding to <code>group</code> in <code>master.</code>
        ///  This allows to create subgroups, by passing an existing group as <code>master.</code>
        ///  <code>group</code> is the group name encoded in UTF-8.
        ///      </remarks>        <short>    Construct a config group corresponding to <code>group</code> in <code>master.</code></short>
        public KConfigGroup(KConfigBase master, string group) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KConfigGroup#$", "KConfigGroup(KConfigBase*, const QString&)", typeof(void), typeof(KConfigBase), master, typeof(string), group);
        }
        public KConfigGroup(KSharedConfig master, string group) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KConfigGroup?$", "KConfigGroup(const KSharedPtr<KSharedConfig>&, const QString&)", typeof(void), typeof(KSharedConfig), master, typeof(string), group);
        }
        public KConfigGroup(KConfigGroup arg1) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KConfigGroup#", "KConfigGroup(const KConfigGroup&)", typeof(void), typeof(KConfigGroup), arg1);
        }
        /// <remarks>
        ///  Returns <pre>true</pre> if the group is valid; otherwise returns <pre>false</pre>. A group is invalid if it
        ///  was constructed without arguments.
        ///  You should not call any functions on an invalid group.
        ///      </remarks>        <short>    Returns \p true if the group is valid; otherwise returns \p false.</short>
        public bool IsValid() {
            return (bool) interceptor.Invoke("isValid", "isValid() const", typeof(bool));
        }
        /// <remarks>
        ///  The name of this group.
        ///  The root group is named "<default>".
        ///      </remarks>        <short>    The name of this group.</short>
        public string Name() {
            return (string) interceptor.Invoke("name", "name() const", typeof(string));
        }
        /// <remarks>
        ///  Check whether the containing KConfig object acutally contains a
        ///  group with this name.
        ///      </remarks>        <short>    Check whether the containing KConfig object acutally contains a  group with this name.</short>
        public bool Exists() {
            return (bool) interceptor.Invoke("exists", "exists() const", typeof(bool));
        }
        [SmokeMethod("sync()")]
        public override void Sync() {
            interceptor.Invoke("sync", "sync()", typeof(void));
        }
        [SmokeMethod("markAsClean()")]
        public override void MarkAsClean() {
            interceptor.Invoke("markAsClean", "markAsClean()", typeof(void));
        }
        [SmokeMethod("accessMode() const")]
        public override KConfigBase.AccessMode accessMode() {
            return (KConfigBase.AccessMode) interceptor.Invoke("accessMode", "accessMode() const", typeof(KConfigBase.AccessMode));
        }
        /// <remarks>
        ///  Return the config object that this group belongs to.
        ///      </remarks>        <short>    Return the config object that this group belongs to.</short>
        public KConfig Config() {
            return (KConfig) interceptor.Invoke("config", "config()", typeof(KConfig));
        }
        /// <remarks>
        ///  Copies the entries in this group to another config object.
        /// <param> name="other" The other config object to copy this group's entries to. @note <code>other</code>
        ///         <b>can</b> be either another group or a different file.
        /// </param></remarks>        <short>    Copies the entries in this group to another config object.</short>
        public void CopyTo(KConfigBase other, uint pFlags) {
            interceptor.Invoke("copyTo#$", "copyTo(KConfigBase*, KConfigBase::WriteConfigFlags) const", typeof(void), typeof(KConfigBase), other, typeof(uint), pFlags);
        }
        public void CopyTo(KConfigBase other) {
            interceptor.Invoke("copyTo#", "copyTo(KConfigBase*) const", typeof(void), typeof(KConfigBase), other);
        }
        /// <remarks>
        ///  Changes the group that this group belongs to.
        /// <param> name="parent" the config object to place this group under. If <code>parent</code> is a KConfig it will be
        ///                promoted to a top-level group.
        /// </param></remarks>        <short>    Changes the group that this group belongs to.</short>
        public void Reparent(KConfigBase parent, uint pFlags) {
            interceptor.Invoke("reparent#$", "reparent(KConfigBase*, KConfigBase::WriteConfigFlags)", typeof(void), typeof(KConfigBase), parent, typeof(uint), pFlags);
        }
        public void Reparent(KConfigBase parent) {
            interceptor.Invoke("reparent#", "reparent(KConfigBase*)", typeof(void), typeof(KConfigBase), parent);
        }
        /// <remarks>
        ///  Returns the group that this group belongs to, can be invalid if this is a top-level group.
        /// </remarks>        <short>    Returns the group that this group belongs to, can be invalid if this is a top-level group.</short>
        public KConfigGroup Parent() {
            return (KConfigGroup) interceptor.Invoke("parent", "parent() const", typeof(KConfigGroup));
        }
        /// <remarks> 
        ///  @reimp
        ///      </remarks>        <short>     @reimp      </short>
        [SmokeMethod("groupList() const")]
        public override List<string> GroupList() {
            return (List<string>) interceptor.Invoke("groupList", "groupList() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Returns a list of keys this group contains.
        ///      </remarks>        <short>    Returns a list of keys this group contains.</short>
        public List<string> KeyList() {
            return (List<string>) interceptor.Invoke("keyList", "keyList() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Delete all entries in the entire group
        /// <param> name="pFlags" flags passed to KConfig.DeleteGroup
        ///      </param></remarks>        <short>    Delete all entries in the entire group </short>
        public void DeleteGroup(uint pFlags) {
            interceptor.Invoke("deleteGroup$", "deleteGroup(KConfigBase::WriteConfigFlags)", typeof(void), typeof(uint), pFlags);
        }
        public void DeleteGroup() {
            interceptor.Invoke("deleteGroup", "deleteGroup()", typeof(void));
        }
        /// <remarks>
        ///  Reads the value of an entry specified by <code>key</code> in the current group.
        /// <param> name="key" The key to search for.
        /// </param><param> name="aDefault" A default value returned if the key was not found.
        /// </param></remarks>        <return> The value for this key. Can be QVariant() if aDefault is null.
        ///      </return>
        ///         <short>    Reads the value of an entry specified by <code>key</code> in the current group.</short>
        public QVariant ReadEntry(string key, QVariant aDefault) {
            return (QVariant) interceptor.Invoke("readEntry$#", "readEntry(const QString&, const QVariant&) const", typeof(QVariant), typeof(string), key, typeof(QVariant), aDefault);
        }
        /// <remarks>
        ///  Reads the value of an entry specified by <code>key</code> in the current group.
        ///  If you want to read a path, please use readPathEntry().
        /// <param> name="key" The key to search for.
        /// </param><param> name="aDefault" A default value returned if the key was not found.
        /// </param></remarks>        <return> The value for this key. Can be string() if aDefault is null.
        ///      </return>
        ///         <short>    Reads the value of an entry specified by <code>key</code> in the current group.</short>
        public string ReadEntry(string key, string aDefault) {
            return (string) interceptor.Invoke("readEntry$$", "readEntry(const char*, const QString&) const", typeof(string), typeof(string), key, typeof(string), aDefault);
        }
        public string ReadEntry(string key) {
            return (string) interceptor.Invoke("readEntry$", "readEntry(const QString&) const", typeof(string), typeof(string), key);
        }
        /// <remarks>
        ///  Reads a list from the config object.
        ///  @copydoc readEntry(string, const QList<T>&) const
        ///  @warning This function doesn't convert the items returned
        ///           to any type. It's actually a list of QVariant.String's. If you
        ///           want the items converted to a specific type use
        ///           readEntry(string, const QList<T>&) const
        ///      </remarks>        <short>    Reads a list from the config object.</short>
        public List<QVariant> ReadEntry(string key, List<QVariant> aDefault) {
            return (List<QVariant>) interceptor.Invoke("readEntry$?", "readEntry(const QString&, const QList<QVariant>&) const", typeof(List<QVariant>), typeof(string), key, typeof(List<QVariant>), aDefault);
        }
        /// <remarks>
        ///  Reads a list of strings from the config object.
        /// <param> name="key" The key to search for.
        /// </param><param> name="aDefault" The default value to use if the key does not exist.
        /// </param></remarks>        <return> The list. Contains <code>aDefault</code> if <code>key</code> does not exist.
        ///      </return>
        ///         <short>    Reads a list of strings from the config object.</short>
        public List<string> ReadEntry(string key, List<string> aDefault) {
            return (List<string>) interceptor.Invoke("readEntry$?", "readEntry(const QString&, const QStringList&) const", typeof(List<string>), typeof(string), key, typeof(List<string>), aDefault);
        }
        /// <remarks>
        ///  Reads a list of strings from the config object, following XDG
        ///  desktop entry spec separator semantics.
        /// <param> name="pKey" The key to search for.
        /// </param><param> name="aDefault" The default value to use if the key does not exist.
        /// </param></remarks>        <return> The list. Contains <code>aDefault</code> if <code>pKey</code> does not exist.
        ///      </return>
        ///         <short>    Reads a list of strings from the config object, following XDG  desktop entry spec separator semantics.</short>
        public List<string> ReadXdgListEntry(string pKey, List<string> aDefault) {
            return (List<string>) interceptor.Invoke("readXdgListEntry$?", "readXdgListEntry(const QString&, const QStringList&) const", typeof(List<string>), typeof(string), pKey, typeof(List<string>), aDefault);
        }
        public List<string> ReadXdgListEntry(string pKey) {
            return (List<string>) interceptor.Invoke("readXdgListEntry$", "readXdgListEntry(const QString&) const", typeof(List<string>), typeof(string), pKey);
        }
        /// <remarks>
        ///  Reads a path.
        ///  Read the value of an entry specified by <code>pKey</code> in the current group
        ///  and interpret it as a path. This means, dollar expansion is activated
        ///  for this value, so that e.g. $HOME gets expanded.
        /// <param> name="pKey" The key to search for.
        /// </param><param> name="aDefault" A default value returned if the key was not found.
        /// </param></remarks>        <return> The value for this key. Can be string() if <code>aDefault</code> is null.
        ///      </return>
        ///         <short>    Reads a path.</short>
        public string ReadPathEntry(string pKey, string aDefault) {
            return (string) interceptor.Invoke("readPathEntry$$", "readPathEntry(const QString&, const QString&) const", typeof(string), typeof(string), pKey, typeof(string), aDefault);
        }
        /// <remarks>
        ///  Reads a list of string paths.
        ///  Read the value of an entry specified by <code>pKey</code> in the current group
        ///  and interpret it as a list of paths. This means, dollar expansion is activated
        ///  for this value, so that e.g. $HOME gets expanded.
        /// <param> name="pKey" The key to search for.
        /// </param><param> name="aDefault" A default value returned if the key was not found.
        /// </param></remarks>        <return> The list. Empty if the entry does not exist.
        ///      </return>
        ///         <short>    Reads a list of string paths.</short>
        public List<string> ReadPathEntry(string pKey, List<string> aDefault) {
            return (List<string>) interceptor.Invoke("readPathEntry$?", "readPathEntry(const QString&, const QStringList&) const", typeof(List<string>), typeof(string), pKey, typeof(List<string>), aDefault);
        }
        /// <remarks>
        ///  Reads the value of an entry specified by <code>pKey</code> in the current group.
        ///  The untranslated entry is returned, you normally do not need this.
        /// <param> name="pKey" The key to search for.
        /// </param><param> name="aDefault" A default value returned if the key was not found.
        /// </param></remarks>        <return> The value for this key.
        ///      </return>
        ///         <short>    Reads the value of an entry specified by <code>pKey</code> in the current group.</short>
        public string ReadEntryUntranslated(string pKey, string aDefault) {
            return (string) interceptor.Invoke("readEntryUntranslated$$", "readEntryUntranslated(const QString&, const QString&) const", typeof(string), typeof(string), pKey, typeof(string), aDefault);
        }
        public string ReadEntryUntranslated(string pKey) {
            return (string) interceptor.Invoke("readEntryUntranslated$", "readEntryUntranslated(const QString&) const", typeof(string), typeof(string), pKey);
        }
        /// <remarks>
        ///  Writes a value to the config object.
        /// <param> name="key" The key to write
        /// </param><param> name="value" The value to write
        /// </param><param> name="pFlags" The flags to use when writing this entry.
        ///      </param></remarks>        <short>    Writes a value to the config object.</short>
        public void WriteEntry(string key, QVariant value, uint pFlags) {
            interceptor.Invoke("writeEntry$#$", "writeEntry(const QString&, const QVariant&, KConfigBase::WriteConfigFlags)", typeof(void), typeof(string), key, typeof(QVariant), value, typeof(uint), pFlags);
        }
        public void WriteEntry(string key, QVariant value) {
            interceptor.Invoke("writeEntry$#", "writeEntry(const QString&, const QVariant&)", typeof(void), typeof(string), key, typeof(QVariant), value);
        }
        /// <remarks>
        ///  Writes a value to the config object.
        /// <param> name="key" The key to write
        /// </param><param> name="value" The value to write
        /// </param><param> name="pFlags" The flags to use when writing this entry.
        ///      </param></remarks>        <short>    Writes a value to the config object.</short>
        public void WriteEntry(string key, string value, uint pFlags) {
            interceptor.Invoke("writeEntry$$$", "writeEntry(const QString&, const QString&, KConfigBase::WriteConfigFlags)", typeof(void), typeof(string), key, typeof(string), value, typeof(uint), pFlags);
        }
        public void WriteEntry(string key, string value) {
            interceptor.Invoke("writeEntry$$", "writeEntry(const QString&, const QString&)", typeof(void), typeof(string), key, typeof(string), value);
        }
        /// <remarks>
        ///  Writes a value to the config object.
        /// <param> name="key" The key to write
        /// </param><param> name="value" The value to write
        /// </param><param> name="pFlags" The flags to use when writing this entry.
        ///      </param></remarks>        <short>    Writes a value to the config object.</short>
        public void WriteEntry(string key, QByteArray value, uint pFlags) {
            interceptor.Invoke("writeEntry$#$", "writeEntry(const QString&, const QByteArray&, KConfigBase::WriteConfigFlags)", typeof(void), typeof(string), key, typeof(QByteArray), value, typeof(uint), pFlags);
        }
        public void WriteEntry(string key, QByteArray value) {
            interceptor.Invoke("writeEntry$#", "writeEntry(const QString&, const QByteArray&)", typeof(void), typeof(string), key, typeof(QByteArray), value);
        }
        /// <remarks>
        ///  writeEntry() overridden to accept a list of strings.
        /// <param> name="key" The key to write
        /// </param><param> name="value" The list to write
        /// </param><param> name="pFlags" The flags to use when writing this entry.
        /// </param></remarks>        <short>    writeEntry() overridden to accept a list of strings.</short>
        ///         <see> writeEntry</see>
        public void WriteEntry(string key, List<string> value, uint pFlags) {
            interceptor.Invoke("writeEntry$?$", "writeEntry(const QString&, const QStringList&, KConfigBase::WriteConfigFlags)", typeof(void), typeof(string), key, typeof(List<string>), value, typeof(uint), pFlags);
        }
        public void WriteEntry(string key, List<string> value) {
            interceptor.Invoke("writeEntry$?", "writeEntry(const QString&, const QStringList&)", typeof(void), typeof(string), key, typeof(List<string>), value);
        }
        /// <remarks>
        ///  writeEntry() overridden to accept a list of QVariant values.
        /// <param> name="key" The key to write
        /// </param><param> name="value" The list to write
        /// </param><param> name="pFlags" The flags to use when writing this entry.
        /// </param></remarks>        <short>    writeEntry() overridden to accept a list of QVariant values.</short>
        ///         <see> writeEntry</see>
        public void WriteEntry(string key, List<QVariant> value, uint pFlags) {
            interceptor.Invoke("writeEntry$?$", "writeEntry(const QString&, const QList<QVariant>&, KConfigBase::WriteConfigFlags)", typeof(void), typeof(string), key, typeof(List<QVariant>), value, typeof(uint), pFlags);
        }
        public void WriteEntry(string key, List<QVariant> value) {
            interceptor.Invoke("writeEntry$?", "writeEntry(const QString&, const QList<QVariant>&)", typeof(void), typeof(string), key, typeof(List<QVariant>), value);
        }
        /// <remarks>
        ///  Writes a list of strings to the config object, following XDG
        ///  desktop entry spec separator semantics.
        /// <param> name="pKey" The key to write
        /// </param><param> name="value" The list to write
        /// </param><param> name="pFlags" The flags to use when writing this entry.
        /// </param></remarks>        <short>    Writes a list of strings to the config object, following XDG  desktop entry spec separator semantics.</short>
        ///         <see> writeEntry</see>
        public void WriteXdgListEntry(string pKey, List<string> value, uint pFlags) {
            interceptor.Invoke("writeXdgListEntry$?$", "writeXdgListEntry(const QString&, const QStringList&, KConfigBase::WriteConfigFlags)", typeof(void), typeof(string), pKey, typeof(List<string>), value, typeof(uint), pFlags);
        }
        public void WriteXdgListEntry(string pKey, List<string> value) {
            interceptor.Invoke("writeXdgListEntry$?", "writeXdgListEntry(const QString&, const QStringList&)", typeof(void), typeof(string), pKey, typeof(List<string>), value);
        }
        /// <remarks>
        ///  Writes a file path.
        ///  It is checked whether the path is located under $HOME. If so the
        ///  path is written out with the user's home-directory replaced with
        ///  $HOME. The path should be read back with readPathEntry()
        /// <param> name="pKey" The key to write.
        /// </param><param> name="path" The path to write.
        /// </param><param> name="pFlags" The flags to use when writing this entry.
        ///      </param></remarks>        <short>    Writes a file path.</short>
        public void WritePathEntry(string pKey, string path, uint pFlags) {
            interceptor.Invoke("writePathEntry$$$", "writePathEntry(const QString&, const QString&, KConfigBase::WriteConfigFlags)", typeof(void), typeof(string), pKey, typeof(string), path, typeof(uint), pFlags);
        }
        public void WritePathEntry(string pKey, string path) {
            interceptor.Invoke("writePathEntry$$", "writePathEntry(const QString&, const QString&)", typeof(void), typeof(string), pKey, typeof(string), path);
        }
        /// <remarks>
        ///  writePathEntry() overridden to accept a list of paths (strings).
        ///  It is checked whether the paths are located under $HOME. If so each of
        ///  the paths are written out with the user's home-directory replaced with
        ///  $HOME. The paths should be read back with readPathEntry()
        /// <param> name="pKey" The key to write
        /// </param><param> name="value" The list to write
        /// </param><param> name="pFlags" The flags to use when writing this entry.
        /// </param></remarks>        <short>    writePathEntry() overridden to accept a list of paths (strings).</short>
        ///         <see> readPathEntry</see>
        public void WritePathEntry(string pKey, List<string> value, uint pFlags) {
            interceptor.Invoke("writePathEntry$?$", "writePathEntry(const QString&, const QStringList&, KConfigBase::WriteConfigFlags)", typeof(void), typeof(string), pKey, typeof(List<string>), value, typeof(uint), pFlags);
        }
        public void WritePathEntry(string pKey, List<string> value) {
            interceptor.Invoke("writePathEntry$?", "writePathEntry(const QString&, const QStringList&)", typeof(void), typeof(string), pKey, typeof(List<string>), value);
        }
        /// <remarks>
        ///  Deletes the entry specified by <code>pKey</code> in the current group.
        ///  This also hides system wide defaults.
        /// <param> name="pKey" The key to delete.
        /// </param><param> name="pFlags" The flags to use when deleting this entry.
        ///      </param></remarks>        <short>    Deletes the entry specified by <code>pKey</code> in the current group.</short>
        public void DeleteEntry(string pKey, uint pFlags) {
            interceptor.Invoke("deleteEntry$$", "deleteEntry(const QString&, KConfigBase::WriteConfigFlags)", typeof(void), typeof(string), pKey, typeof(uint), pFlags);
        }
        public void DeleteEntry(string pKey) {
            interceptor.Invoke("deleteEntry$", "deleteEntry(const QString&)", typeof(void), typeof(string), pKey);
        }
        /// <remarks>
        ///  Checks whether the key has an entry in the currently active group.
        ///  Use this to determine whether a key is not specified for the current
        ///  group (hasKey() returns false).
        /// <param> name="key" The key to search for.
        /// </param></remarks>        <return> If true, the key is available.
        ///      </return>
        ///         <short>    Checks whether the key has an entry in the currently active group.</short>
        public bool HasKey(string key) {
            return (bool) interceptor.Invoke("hasKey$", "hasKey(const QString&) const", typeof(bool), typeof(string), key);
        }
        /// <remarks>
        ///  Checks whether it is possible to change the given group.
        /// </remarks>        <return> whether changes may be made to this group.
        ///      </return>
        ///         <short>    Checks whether it is possible to change the given group.</short>
        [SmokeMethod("isImmutable() const")]
        public override bool IsImmutable() {
            return (bool) interceptor.Invoke("isImmutable", "isImmutable() const", typeof(bool));
        }
        /// <remarks>
        ///  Checks whether it is possible to change the given entry.
        /// <param> name="key" the key to check
        /// </param></remarks>        <return> whether the entry <code>key</code> may be changed in the current group
        ///  in this configuration file.
        ///      </return>
        ///         <short>    Checks whether it is possible to change the given entry.</short>
        public bool IsEntryImmutable(string key) {
            return (bool) interceptor.Invoke("isEntryImmutable$", "isEntryImmutable(const QString&) const", typeof(bool), typeof(string), key);
        }
        /// <remarks>
        ///  Reverts the entry with key <code>key</code> in the current group in the
        ///  application specific config file to either the system wide (default)
        ///  value or the value specified in the global KDE config file.
        ///  To revert entries in the global KDE config file, the global KDE config
        ///  file should be opened explicitly in a separate config object.
        /// <param> name="key" The key of the entry to revert.
        ///      </param></remarks>        <short>    Reverts the entry with key <code>key</code> in the current group in the  application specific config file to either the system wide (default)  value or the value specified in the global KDE config file.</short>
        public void RevertToDefault(string key) {
            interceptor.Invoke("revertToDefault$", "revertToDefault(const QString&)", typeof(void), typeof(string), key);
        }
        /// <remarks>
        ///  Returns whether a default is specified for an entry in either the
        ///  system wide configuration file or the global KDE config file.
        ///  If an application computes a default value at runtime for
        ///  a certain entry, e.g. like:
        ///  <pre>
        ///  QColor computedDefault = qApp.Palette().color(QPalette.Active, QPalette.Text)
        ///  QColor color = config.ReadEntry(key, computedDefault);
        ///  </pre>
        ///  Then it may wish to make the following check before
        ///  writing back changes:
        ///  <pre>
        ///  if ( (value == computedDefault) && !config.HasDefault(key) )
        ///     config.RevertToDefault(key)
        ///  else
        ///     config.WriteEntry(key, value)
        ///  </pre>
        ///  This ensures that as long as the entry is not modified to differ from
        ///  the computed default, the application will keep using the computed default
        ///  and will follow changes the computed default makes over time.
        /// <param> name="key" The key of the entry to check.
        ///      </param></remarks>        <short>    Returns whether a default is specified for an entry in either the  system wide configuration file or the global KDE config file.</short>
        public bool HasDefault(string key) {
            return (bool) interceptor.Invoke("hasDefault$", "hasDefault(const QString&) const", typeof(bool), typeof(string), key);
        }
        /// <remarks>
        ///  Returns a map (tree) of entries for all entries in this group.
        ///  Only the actual entry string is returned, none of the
        ///  other internal data should be included.
        /// </remarks>        <return> A map of entries in this group, indexed by key.
        ///      </return>
        ///         <short>    Returns a map (tree) of entries for all entries in this group.</short>
        public Dictionary<string, string> EntryMap() {
            return (Dictionary<string, string>) interceptor.Invoke("entryMap", "entryMap() const", typeof(Dictionary<string, string>));
        }
        [SmokeMethod("hasGroupImpl(const QByteArray&) const")]
        protected override bool HasGroupImpl(QByteArray group) {
            return (bool) interceptor.Invoke("hasGroupImpl#", "hasGroupImpl(const QByteArray&) const", typeof(bool), typeof(QByteArray), group);
        }
        [SmokeMethod("deleteGroupImpl(const QByteArray&, KConfigBase::WriteConfigFlags)")]
        protected override void DeleteGroupImpl(QByteArray group, uint flags) {
            interceptor.Invoke("deleteGroupImpl#$", "deleteGroupImpl(const QByteArray&, KConfigBase::WriteConfigFlags)", typeof(void), typeof(QByteArray), group, typeof(uint), flags);
        }
        [SmokeMethod("isGroupImmutableImpl(const QByteArray&) const")]
        protected override bool IsGroupImmutableImpl(QByteArray aGroup) {
            return (bool) interceptor.Invoke("isGroupImmutableImpl#", "isGroupImmutableImpl(const QByteArray&) const", typeof(bool), typeof(QByteArray), aGroup);
        }
        // WARNING: Unimplemented C++ pure virtual - DO NOT CALL
        [SmokeMethod("groupImpl(const QByteArray&)")]
        protected override KConfigGroup GroupImpl(QByteArray b) {
            return (KConfigGroup) interceptor.Invoke("groupImpl#", "groupImpl(const QByteArray&)", typeof(KConfigGroup), typeof(QByteArray), b);
        }
        ~KConfigGroup() {
            interceptor.Invoke("~KConfigGroup", "~KConfigGroup()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~KConfigGroup", "~KConfigGroup()", typeof(void));
        }
    }
}
