/* match-name.c generated by valac 0.12.0, the Vala compiler
 * generated from match-name.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <tracker-test.h>
#include <folks.h>
#include <stdlib.h>
#include <string.h>
#include <folks-tracker.h>
#include <gio/gio.h>


#define TYPE_MATCH_NAME_TESTS (match_name_tests_get_type ())
#define MATCH_NAME_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATCH_NAME_TESTS, MatchNameTests))
#define MATCH_NAME_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATCH_NAME_TESTS, MatchNameTestsClass))
#define IS_MATCH_NAME_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATCH_NAME_TESTS))
#define IS_MATCH_NAME_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATCH_NAME_TESTS))
#define MATCH_NAME_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATCH_NAME_TESTS, MatchNameTestsClass))

typedef struct _MatchNameTests MatchNameTests;
typedef struct _MatchNameTestsClass MatchNameTestsClass;
typedef struct _MatchNameTestsPrivate MatchNameTestsPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _tracker_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (tracker_test_backend_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MatchNameTestsTestMatchNameAsyncData MatchNameTestsTestMatchNameAsyncData;
typedef struct _MatchNameTestsTryToAddData MatchNameTestsTryToAddData;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _MatchNameTestsAddPersonasData MatchNameTestsAddPersonasData;

struct _MatchNameTests {
	FolksTestCase parent_instance;
	MatchNameTestsPrivate * priv;
};

struct _MatchNameTestsClass {
	FolksTestCaseClass parent_class;
};

struct _MatchNameTestsPrivate {
	GMainLoop* _main_loop;
	TrackerTestBackend* _tracker_backend;
	FolksIndividualAggregator* _aggregator;
	gchar* _persona_fullname_1;
	gchar* _persona_fullname_2;
	gboolean _added_personas;
	GStaticRecMutex __lock__added_personas;
	gchar* _individual_id_1;
	gchar* _individual_id_2;
	FolksMatchResult _match;
	TrfPersonaStore* _pstore;
};

struct _MatchNameTestsTestMatchNameAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MatchNameTests* self;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* store;
	FolksIndividualAggregator* _tmp1_;
	GList* _tmp2_;
	GList* backend_collection;
	GList* backend_it;
	FolksBackend* _tmp3_;
	FolksBackend* backend;
	GHashTable* _tmp4_;
	gconstpointer _tmp5_;
	TrfPersonaStore* _tmp6_;
	GError * e;
	GError * _inner_error_;
};

struct _MatchNameTestsTryToAddData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MatchNameTests* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_;
};

struct _MatchNameTestsAddPersonasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	MatchNameTests* self;
	GHashTable* _tmp0_;
	GHashTable* details1;
	GHashTable* _tmp1_;
	GHashTable* details2;
	GValue* val;
	GValue _tmp2_;
	GValue _tmp3_;
	GValue _tmp4_;
	GValue* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GValue* _tmp8_;
	GValue _tmp9_;
	GValue _tmp10_;
	GValue _tmp11_;
	GValue* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	GValue* _tmp15_;
	FolksPersona* _tmp16_;
	FolksPersona* _tmp17_;
	FolksPersona* _tmp18_;
	FolksPersona* _tmp19_;
	GError * e;
	GError * _inner_error_;
};


static gpointer match_name_tests_parent_class = NULL;

GType match_name_tests_get_type (void) G_GNUC_CONST;
#define MATCH_NAME_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATCH_NAME_TESTS, MatchNameTestsPrivate))
enum  {
	MATCH_NAME_TESTS_DUMMY_PROPERTY
};
MatchNameTests* match_name_tests_new (void);
MatchNameTests* match_name_tests_construct (GType object_type);
void match_name_tests_test_match_name_1 (MatchNameTests* self);
static void _match_name_tests_test_match_name_1_folks_test_case_test_method (gpointer self);
void match_name_tests_test_match_name_2 (MatchNameTests* self);
static void _match_name_tests_test_match_name_2_folks_test_case_test_method (gpointer self);
void match_name_tests_test_match_name_3 (MatchNameTests* self);
static void _match_name_tests_test_match_name_3_folks_test_case_test_method (gpointer self);
static void match_name_tests_real_set_up (FolksTestCase* base);
static void match_name_tests_real_tear_down (FolksTestCase* base);
static void _match_name_tests_test_match_name_async (MatchNameTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _match_name_tests_test_match_name_finish (MatchNameTests* self, GAsyncResult* _res_);
static gboolean _lambda0_ (MatchNameTests* self);
static gboolean __lambda0__gsource_func (gpointer self);
static gboolean _lambda1_ (MatchNameTests* self);
static gboolean __lambda1__gsource_func (gpointer self);
static gboolean _lambda2_ (MatchNameTests* self);
static gboolean __lambda2__gsource_func (gpointer self);
static void _match_name_tests_test_match_name_async_data_free (gpointer _data);
static gboolean _match_name_tests_test_match_name_async_co (MatchNameTestsTestMatchNameAsyncData* data);
static void _match_name_tests_test_match_name_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _match_name_tests_individuals_changed_cb (MatchNameTests* self, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __match_name_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void _match_name_tests_notify_pstore_cb (MatchNameTests* self, GObject* _pstore, GParamSpec* ps);
static void __match_name_tests_notify_pstore_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _match_name_tests_try_to_add (MatchNameTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _match_name_tests_try_to_add_finish (MatchNameTests* self, GAsyncResult* _res_);
static void _match_name_tests_try_potential_match (MatchNameTests* self);
static void _match_name_tests_try_to_add_data_free (gpointer _data);
static gboolean _match_name_tests_try_to_add_co (MatchNameTestsTryToAddData* data);
static void _match_name_tests_add_personas (MatchNameTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _match_name_tests_add_personas_finish (MatchNameTests* self, GAsyncResult* _res_);
static void _match_name_tests_try_to_add_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _match_name_tests_add_personas_data_free (gpointer _data);
static gboolean _match_name_tests_add_personas_co (MatchNameTestsAddPersonasData* data);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static GValue* _g_value_dup (GValue* self);
static void _match_name_tests_add_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void match_name_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _match_name_tests_test_match_name_1_folks_test_case_test_method (gpointer self) {
	match_name_tests_test_match_name_1 (self);
}


static void _match_name_tests_test_match_name_2_folks_test_case_test_method (gpointer self) {
	match_name_tests_test_match_name_2 (self);
}


static void _match_name_tests_test_match_name_3_folks_test_case_test_method (gpointer self) {
	match_name_tests_test_match_name_3 (self);
}


MatchNameTests* match_name_tests_construct (GType object_type) {
	MatchNameTests * self = NULL;
	TrackerTestBackend* _tmp0_ = NULL;
	self = (MatchNameTests*) folks_test_case_construct (object_type, "MatchNameTests");
	_tmp0_ = tracker_test_backend_new ();
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	self->priv->_tracker_backend = _tmp0_;
	folks_test_case_add_test ((FolksTestCase*) self, "test potential match by name #1 ", _match_name_tests_test_match_name_1_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "test potential match by name #2 ", _match_name_tests_test_match_name_2_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "test potential match by name #3 ", _match_name_tests_test_match_name_3_folks_test_case_test_method, self);
	return self;
}


MatchNameTests* match_name_tests_new (void) {
	return match_name_tests_construct (TYPE_MATCH_NAME_TESTS);
}


static void match_name_tests_real_set_up (FolksTestCase* base) {
	MatchNameTests * self;
	self = (MatchNameTests*) base;
}


static void match_name_tests_real_tear_down (FolksTestCase* base) {
	MatchNameTests * self;
	self = (MatchNameTests*) base;
	tracker_test_backend_tear_down (self->priv->_tracker_backend);
}


static gboolean _lambda0_ (MatchNameTests* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->_main_loop);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


void match_name_tests_test_match_name_1 (MatchNameTests* self) {
	GMainLoop* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	self->priv->_match = FOLKS_MATCH_RESULT_MIN;
	self->priv->_added_personas = FALSE;
	_tmp1_ = g_strdup ("Bernie Innocenti");
	_g_free0 (self->priv->_persona_fullname_1);
	self->priv->_persona_fullname_1 = _tmp1_;
	_tmp2_ = g_strdup ("Bernardo H. Innocenti");
	_g_free0 (self->priv->_persona_fullname_2);
	self->priv->_persona_fullname_2 = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->_individual_id_1);
	self->priv->_individual_id_1 = _tmp3_;
	_tmp4_ = g_strdup ("");
	_g_free0 (self->priv->_individual_id_2);
	self->priv->_individual_id_2 = _tmp4_;
	_match_name_tests_test_match_name_async (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->_main_loop);
	g_assert (self->priv->_match >= FOLKS_MATCH_RESULT_MEDIUM);
}


static gboolean _lambda1_ (MatchNameTests* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->_main_loop);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda1_ (self);
	return result;
}


void match_name_tests_test_match_name_2 (MatchNameTests* self) {
	GMainLoop* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	self->priv->_match = FOLKS_MATCH_RESULT_MIN;
	self->priv->_added_personas = FALSE;
	_tmp1_ = g_strdup ("AAAA BBBBB");
	_g_free0 (self->priv->_persona_fullname_1);
	self->priv->_persona_fullname_1 = _tmp1_;
	_tmp2_ = g_strdup ("CCCCC DDDDD");
	_g_free0 (self->priv->_persona_fullname_2);
	self->priv->_persona_fullname_2 = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->_individual_id_1);
	self->priv->_individual_id_1 = _tmp3_;
	_tmp4_ = g_strdup ("");
	_g_free0 (self->priv->_individual_id_2);
	self->priv->_individual_id_2 = _tmp4_;
	_match_name_tests_test_match_name_async (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda1__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->_main_loop);
	g_assert (self->priv->_match <= FOLKS_MATCH_RESULT_LOW);
}


static gboolean _lambda2_ (MatchNameTests* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->_main_loop);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda2_ (self);
	return result;
}


void match_name_tests_test_match_name_3 (MatchNameTests* self) {
	GMainLoop* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	self->priv->_match = FOLKS_MATCH_RESULT_MIN;
	self->priv->_added_personas = FALSE;
	_tmp1_ = g_strdup ("Travis Reitter");
	_g_free0 (self->priv->_persona_fullname_1);
	self->priv->_persona_fullname_1 = _tmp1_;
	_tmp2_ = g_strdup ("Travis R.");
	_g_free0 (self->priv->_persona_fullname_2);
	self->priv->_persona_fullname_2 = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->_individual_id_1);
	self->priv->_individual_id_1 = _tmp3_;
	_tmp4_ = g_strdup ("");
	_g_free0 (self->priv->_individual_id_2);
	self->priv->_individual_id_2 = _tmp4_;
	_match_name_tests_test_match_name_async (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda2__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->_main_loop);
	g_assert (self->priv->_match >= FOLKS_MATCH_RESULT_MEDIUM);
}


static void _match_name_tests_test_match_name_async_data_free (gpointer _data) {
	MatchNameTestsTestMatchNameAsyncData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (MatchNameTestsTestMatchNameAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _match_name_tests_test_match_name_async (MatchNameTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MatchNameTestsTestMatchNameAsyncData* _data_;
	_data_ = g_slice_new0 (MatchNameTestsTestMatchNameAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _match_name_tests_test_match_name_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _match_name_tests_test_match_name_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_match_name_tests_test_match_name_async_co (_data_);
}


static void _match_name_tests_test_match_name_finish (MatchNameTests* self, GAsyncResult* _res_) {
	MatchNameTestsTestMatchNameAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _match_name_tests_test_match_name_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	MatchNameTestsTestMatchNameAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_match_name_tests_test_match_name_async_co (data);
}


static void __match_name_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_match_name_tests_individuals_changed_cb (self, added, removed, message, actor, reason);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void __match_name_tests_notify_pstore_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_match_name_tests_notify_pstore_cb (self, _sender, pspec);
}


static gboolean _match_name_tests_test_match_name_async_co (MatchNameTestsTestMatchNameAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_store_dup ();
	data->store = data->_tmp0_;
	data->_state_ = 1;
	folks_backend_store_prepare (data->store, _match_name_tests_test_match_name_async_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (data->store, data->_res_);
	if (data->self->priv->_aggregator == NULL) {
		data->_tmp1_ = NULL;
		data->_tmp1_ = folks_individual_aggregator_new ();
		_g_object_unref0 (data->self->priv->_aggregator);
		data->self->priv->_aggregator = data->_tmp1_;
		g_signal_connect_object (data->self->priv->_aggregator, "individuals-changed", (GCallback) __match_name_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed, data->self, 0);
	}
	data->_state_ = 2;
	folks_individual_aggregator_prepare (data->self->priv->_aggregator, _match_name_tests_test_match_name_async_ready, data);
	return FALSE;
	_state_2:
	folks_individual_aggregator_prepare_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	_g_object_unref0 (data->self->priv->_pstore);
	data->self->priv->_pstore = NULL;
	data->_tmp2_ = NULL;
	data->_tmp2_ = folks_backend_store_dup_enabled_backends (data->store);
	{
		data->backend_collection = data->_tmp2_;
		for (data->backend_it = data->backend_collection; data->backend_it != NULL; data->backend_it = data->backend_it->next) {
			data->_tmp3_ = _g_object_ref0 ((FolksBackend*) data->backend_it->data);
			data->backend = data->_tmp3_;
			{
				data->_tmp4_ = NULL;
				data->_tmp4_ = folks_backend_get_persona_stores (data->backend);
				data->_tmp5_ = NULL;
				data->_tmp5_ = g_hash_table_lookup (data->_tmp4_, "tracker");
				data->_tmp6_ = _g_object_ref0 (TRF_PERSONA_STORE ((FolksPersonaStore*) data->_tmp5_));
				_g_object_unref0 (data->self->priv->_pstore);
				data->self->priv->_pstore = data->_tmp6_;
				if (data->self->priv->_pstore != NULL) {
					_g_object_unref0 (data->backend);
					break;
				}
				_g_object_unref0 (data->backend);
			}
		}
		__g_list_free__g_object_unref0_0 (data->backend_collection);
	}
	g_assert (data->self->priv->_pstore != NULL);
	g_signal_connect_object ((GObject*) data->self->priv->_pstore, "notify::is-prepared", (GCallback) __match_name_tests_notify_pstore_cb_g_object_notify, data->self, 0);
	_match_name_tests_try_to_add (data->self, NULL, NULL);
	goto __finally0;
	__catch0_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("match-name.vala:163: Error when calling prepare: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally0:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->store);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _match_name_tests_individuals_changed_cb (MatchNameTests* self, GList* added, GList* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	{
		GList* i_collection;
		GList* i_it;
		i_collection = added;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			FolksIndividual* i;
			i = (FolksIndividual*) i_it->data;
			{
				const gchar* _tmp0_ = NULL;
				_tmp0_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
				if (g_strcmp0 (_tmp0_, self->priv->_persona_fullname_1) == 0) {
					const gchar* _tmp1_ = NULL;
					gchar* _tmp2_;
					_tmp1_ = folks_individual_get_id (i);
					_tmp2_ = g_strdup (_tmp1_);
					_g_free0 (self->priv->_individual_id_1);
					self->priv->_individual_id_1 = _tmp2_;
				} else {
					const gchar* _tmp3_ = NULL;
					_tmp3_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
					if (g_strcmp0 (_tmp3_, self->priv->_persona_fullname_2) == 0) {
						const gchar* _tmp4_ = NULL;
						gchar* _tmp5_;
						_tmp4_ = folks_individual_get_id (i);
						_tmp5_ = g_strdup (_tmp4_);
						_g_free0 (self->priv->_individual_id_2);
						self->priv->_individual_id_2 = _tmp5_;
					}
				}
			}
		}
	}
	if (g_strcmp0 (self->priv->_individual_id_1, "") != 0) {
		_tmp6_ = g_strcmp0 (self->priv->_individual_id_2, "") != 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_match_name_tests_try_potential_match (self);
	}
	g_assert (removed == NULL);
}


static void _match_name_tests_try_potential_match (MatchNameTests* self) {
	GHashTable* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	FolksIndividual* _tmp2_;
	FolksIndividual* ind1;
	GHashTable* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	FolksIndividual* _tmp5_;
	FolksIndividual* ind2;
	FolksPotentialMatch* _tmp6_ = NULL;
	FolksPotentialMatch* matchObj;
	FolksMatchResult _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_individual_aggregator_get_individuals (self->priv->_aggregator);
	_tmp1_ = g_hash_table_lookup (_tmp0_, self->priv->_individual_id_1);
	_tmp2_ = _g_object_ref0 ((FolksIndividual*) _tmp1_);
	ind1 = _tmp2_;
	_tmp3_ = folks_individual_aggregator_get_individuals (self->priv->_aggregator);
	_tmp4_ = g_hash_table_lookup (_tmp3_, self->priv->_individual_id_2);
	_tmp5_ = _g_object_ref0 ((FolksIndividual*) _tmp4_);
	ind2 = _tmp5_;
	_tmp6_ = folks_potential_match_new ();
	matchObj = _tmp6_;
	_tmp7_ = folks_potential_match_potential_match (matchObj, ind1, ind2);
	self->priv->_match = _tmp7_;
	g_main_loop_quit (self->priv->_main_loop);
	_g_object_unref0 (matchObj);
	_g_object_unref0 (ind2);
	_g_object_unref0 (ind1);
}


static void _match_name_tests_notify_pstore_cb (MatchNameTests* self, GObject* _pstore, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (_pstore != NULL);
	g_return_if_fail (ps != NULL);
	_match_name_tests_try_to_add (self, NULL, NULL);
}


static void _match_name_tests_try_to_add_data_free (gpointer _data) {
	MatchNameTestsTryToAddData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (MatchNameTestsTryToAddData, data);
}


static void _match_name_tests_try_to_add (MatchNameTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MatchNameTestsTryToAddData* _data_;
	_data_ = g_slice_new0 (MatchNameTestsTryToAddData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _match_name_tests_try_to_add);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _match_name_tests_try_to_add_data_free);
	_data_->self = _g_object_ref0 (self);
	_match_name_tests_try_to_add_co (_data_);
}


static void _match_name_tests_try_to_add_finish (MatchNameTests* self, GAsyncResult* _res_) {
	MatchNameTestsTryToAddData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _match_name_tests_try_to_add_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	MatchNameTestsTryToAddData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_match_name_tests_try_to_add_co (data);
}


static gboolean _match_name_tests_try_to_add_co (MatchNameTestsTryToAddData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_static_rec_mutex_lock (&data->self->priv->__lock__added_personas);
		data->_tmp1_ = folks_persona_store_get_is_prepared ((FolksPersonaStore*) data->self->priv->_pstore);
		if (data->_tmp1_) {
			data->_tmp0_ = data->self->priv->_added_personas == FALSE;
		} else {
			data->_tmp0_ = FALSE;
		}
		if (data->_tmp0_) {
			data->self->priv->_added_personas = TRUE;
			data->_state_ = 1;
			_match_name_tests_add_personas (data->self, _match_name_tests_try_to_add_ready, data);
			return FALSE;
			_state_1:
			_match_name_tests_add_personas_finish (data->self, data->_res_);
		}
		__finally1:
		g_static_rec_mutex_unlock (&data->self->priv->__lock__added_personas);
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _match_name_tests_add_personas_data_free (gpointer _data) {
	MatchNameTestsAddPersonasData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (MatchNameTestsAddPersonasData, data);
}


static void _match_name_tests_add_personas (MatchNameTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MatchNameTestsAddPersonasData* _data_;
	_data_ = g_slice_new0 (MatchNameTestsAddPersonasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _match_name_tests_add_personas);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _match_name_tests_add_personas_data_free);
	_data_->self = _g_object_ref0 (self);
	_match_name_tests_add_personas_co (_data_);
}


static void _match_name_tests_add_personas_finish (MatchNameTests* self, GAsyncResult* _res_) {
	MatchNameTestsAddPersonasData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void _match_name_tests_add_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	MatchNameTestsAddPersonasData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_match_name_tests_add_personas_co (data);
}


static gboolean _match_name_tests_add_personas_co (MatchNameTestsAddPersonasData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	data->details1 = data->_tmp0_;
	data->_tmp1_ = NULL;
	data->_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	data->details2 = data->_tmp1_;
	memset (&data->_tmp2_, 0, sizeof (GValue));
	g_value_init (&data->_tmp2_, G_TYPE_STRING);
	memset (&data->_tmp3_, 0, sizeof (GValue));
	data->_tmp3_ = data->_tmp2_;
	data->_tmp4_ = data->_tmp3_;
	data->_tmp5_ = __g_value_dup0 (&data->_tmp4_);
	__vala_GValue_free0 (data->val);
	data->val = data->_tmp5_;
	G_IS_VALUE (&data->_tmp4_) ? (g_value_unset (&data->_tmp4_), NULL) : NULL;
	g_value_set_string (data->val, data->self->priv->_persona_fullname_1);
	data->_tmp6_ = NULL;
	data->_tmp6_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_FULL_NAME);
	data->_tmp7_ = g_strdup (data->_tmp6_);
	data->_tmp8_ = data->val;
	data->val = NULL;
	g_hash_table_insert (data->details1, data->_tmp7_, data->_tmp8_);
	memset (&data->_tmp9_, 0, sizeof (GValue));
	g_value_init (&data->_tmp9_, G_TYPE_STRING);
	memset (&data->_tmp10_, 0, sizeof (GValue));
	data->_tmp10_ = data->_tmp9_;
	data->_tmp11_ = data->_tmp10_;
	data->_tmp12_ = __g_value_dup0 (&data->_tmp11_);
	__vala_GValue_free0 (data->val);
	data->val = data->_tmp12_;
	G_IS_VALUE (&data->_tmp11_) ? (g_value_unset (&data->_tmp11_), NULL) : NULL;
	g_value_set_string (data->val, data->self->priv->_persona_fullname_2);
	data->_tmp13_ = NULL;
	data->_tmp13_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_FULL_NAME);
	data->_tmp14_ = g_strdup (data->_tmp13_);
	data->_tmp15_ = data->val;
	data->val = NULL;
	g_hash_table_insert (data->details2, data->_tmp14_, data->_tmp15_);
	data->_state_ = 1;
	folks_individual_aggregator_add_persona_from_details (data->self->priv->_aggregator, NULL, (FolksPersonaStore*) data->self->priv->_pstore, data->details1, _match_name_tests_add_personas_ready, data);
	return FALSE;
	_state_1:
	data->_tmp16_ = NULL;
	data->_tmp16_ = folks_individual_aggregator_add_persona_from_details_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	data->_tmp17_ = data->_tmp16_;
	_g_object_unref0 (data->_tmp17_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			goto __catch2_folks_individual_aggregator_error;
		}
		__vala_GValue_free0 (data->val);
		_g_hash_table_unref0 (data->details2);
		_g_hash_table_unref0 (data->details1);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_state_ = 2;
	folks_individual_aggregator_add_persona_from_details (data->self->priv->_aggregator, NULL, (FolksPersonaStore*) data->self->priv->_pstore, data->details2, _match_name_tests_add_personas_ready, data);
	return FALSE;
	_state_2:
	data->_tmp18_ = NULL;
	data->_tmp18_ = folks_individual_aggregator_add_persona_from_details_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	data->_tmp19_ = data->_tmp18_;
	_g_object_unref0 (data->_tmp19_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			goto __catch2_folks_individual_aggregator_error;
		}
		__vala_GValue_free0 (data->val);
		_g_hash_table_unref0 (data->details2);
		_g_hash_table_unref0 (data->details1);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	goto __finally2;
	__catch2_folks_individual_aggregator_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("match-name.vala:252: [AddPersonaError] add_persona_from_details: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally2:
	if (data->_inner_error_ != NULL) {
		__vala_GValue_free0 (data->val);
		_g_hash_table_unref0 (data->details2);
		_g_hash_table_unref0 (data->details1);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	__vala_GValue_free0 (data->val);
	_g_hash_table_unref0 (data->details2);
	_g_hash_table_unref0 (data->details1);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void match_name_tests_class_init (MatchNameTestsClass * klass) {
	match_name_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MatchNameTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = match_name_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = match_name_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = match_name_tests_finalize;
}


static void match_name_tests_instance_init (MatchNameTests * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self->priv = MATCH_NAME_TESTS_GET_PRIVATE (self);
	self->priv->_aggregator = NULL;
	_tmp0_ = g_strdup ("Bernie Innocenti");
	self->priv->_persona_fullname_1 = _tmp0_;
	_tmp1_ = g_strdup ("Bernardo H. Innocenti");
	self->priv->_persona_fullname_2 = _tmp1_;
	g_static_rec_mutex_init (&self->priv->__lock__added_personas);
	_tmp2_ = g_strdup ("");
	self->priv->_individual_id_1 = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_individual_id_2 = _tmp3_;
}


static void match_name_tests_finalize (GObject* obj) {
	MatchNameTests * self;
	self = MATCH_NAME_TESTS (obj);
	_g_main_loop_unref0 (self->priv->_main_loop);
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	_g_object_unref0 (self->priv->_aggregator);
	_g_free0 (self->priv->_persona_fullname_1);
	_g_free0 (self->priv->_persona_fullname_2);
	g_static_rec_mutex_free (&self->priv->__lock__added_personas);
	_g_free0 (self->priv->_individual_id_1);
	_g_free0 (self->priv->_individual_id_2);
	_g_object_unref0 (self->priv->_pstore);
	G_OBJECT_CLASS (match_name_tests_parent_class)->finalize (obj);
}


GType match_name_tests_get_type (void) {
	static volatile gsize match_name_tests_type_id__volatile = 0;
	if (g_once_init_enter (&match_name_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MatchNameTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) match_name_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MatchNameTests), 0, (GInstanceInitFunc) match_name_tests_instance_init, NULL };
		GType match_name_tests_type_id;
		match_name_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "MatchNameTests", &g_define_type_info, 0);
		g_once_init_leave (&match_name_tests_type_id__volatile, match_name_tests_type_id);
	}
	return match_name_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	MatchNameTests* _tmp1_ = NULL;
	MatchNameTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = match_name_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



